//$Id: CSGDialog.java,v 1.2 2004/09/24 08:50:51 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;


import java.io.*;
import java.lang.Runtime.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

class CSGDialog extends SolidDialog implements ActionListener{
  private JTextField paramField[];
  private JComboBox paramUnit[];
  private CSGItem solid;
  private JButton viewButton, okButton;
  DAWNSourceFrame dawnSFrame;
  private String csgTitle;
  private Process p;

//MOMO
public  CSGDialog(SolidCellEditor parent, CSGItem solid){
    //     super(parent.parent, solid.toString());
    //     super();
     this.solid = solid;


     JLabel lbl;
     dawnSFrame = new DAWNSourceFrame();
 
     GridBagConstraints gbc = new GridBagConstraints();
     GridBagLayout gbl = new GridBagLayout();
     getContentPane().setLayout(gbl);

     GridBagLayout csgGBL = new GridBagLayout();
     GridBagConstraints csgGBC = new GridBagConstraints();
                 JPanel csgPanel = new JPanel(csgGBL);

     gbc.gridx = 0; csgGBC.gridy = 0;
     gbc.gridwidth = GridBagConstraints.REMAINDER; gbc.gridheight = 1;
     gbc.weightx = 1; gbc.weighty = 1;
     gbc.fill = GridBagConstraints.HORIZONTAL;
     gbc.anchor = GridBagConstraints.CENTER;
      
       JPanel csgButtonPanel = new JPanel();
              csgButtonPanel.setLayout(new GridLayout(1,2));
              csgButtonPanel.add(okButton = new JButton(" OK "));
              csgButtonPanel.add(viewButton = new JButton(" VIEW "));

     gbl.setConstraints(csgButtonPanel, gbc);
     getContentPane().add(csgButtonPanel);

     int paraCount = solid.getParaCount();
     paramField = new JTextField[paraCount];
     paramUnit = new JComboBox[paraCount];
    for (int i=0; i<paraCount; i++){
      csgGBC.gridx = 0; csgGBC.gridy = i+1;
        csgGBC.gridwidth = 1; csgGBC.gridheight = 1;
        csgGBC.weightx = 1; csgGBC.weighty = 1;
        csgGBC.fill = GridBagConstraints.NONE;
        csgGBC.anchor = GridBagConstraints.EAST;
        lbl = new JLabel(solid.getParaName(i));
        csgGBL.setConstraints(lbl, csgGBC);
        csgPanel.add(lbl);
      csgGBC.gridx = 1;
        csgGBC.weightx = 1; csgGBC.weighty = 1;
        csgGBC.fill = GridBagConstraints.HORIZONTAL;
        paramField[i] = new JTextField(8);
        csgGBL.setConstraints(paramField[i], csgGBC);
        csgPanel.add(paramField[i]);
      csgGBC.gridx = 2;
        csgGBC.weightx = 1; csgGBC.weighty = 1;
        csgGBC.fill = GridBagConstraints.NONE;
        csgGBC.anchor = GridBagConstraints.WEST;
        if (solid.isAngle(i)) paramUnit[i] = new AngUnitCombo();
          else  paramUnit[i] = new LenUnitCombo();
        csgGBL.setConstraints(paramUnit[i], csgGBC);
        csgPanel.add(paramUnit[i]);
    }

    gbc.gridx = 0; gbc.gridy = 1;
         gbc.gridwidth = GridBagConstraints.REMAINDER; gbc.gridheight = 1;
         gbc.weightx = 0; gbc.weighty = 0;
         gbc.fill = GridBagConstraints.HORIZONTAL;
         gbc.anchor = GridBagConstraints.CENTER;
         gbl.setConstraints(csgPanel, gbc);
         getContentPane().add(csgPanel);

    okButton.addActionListener(parent);
    viewButton.addActionListener(this);
    setValues();
    pack();
    setVisible(true);
    setResizable(false);
  }
//MOMOMOMO
public  void editStop(){
    dispose();
  }

  public void actionPerformed(ActionEvent ae){
    Object o = ae.getSource();
    if(o == viewButton ){ 
      getValues();
      getDAWN();
    }
  }
  private void getDAWN(){
    dawnSFrame.setVisible(true);
    dawnSFrame.dawnEditor.setText(solid.getPrim());
    try{
      FileOutputStream fileout = new FileOutputStream("GGESolid.prim");
      PrintWriter outf = new PrintWriter(new DataOutputStream(fileout));
      outf.println(solid.getPrim());
      outf.close();
    }catch(IOException e){
      System.out.println(e.toString());
    }
    try{
      String cmd="dawn -v GGESolid.prim";
      Runtime r = Runtime.getRuntime();
      Process p = r.exec(cmd);
    }catch(IOException e){
      System.out.println(e.toString());
    }       
  }
  private void setValues(){
    if (solid.isEmpty) return;
    for (int i=0; i<solid.getParaCount(); i++){
      paramField[i].setText(Double.toString(solid.getValues(i)));
      paramUnit[i].setSelectedItem(solid.getUnits(i));
    }
  }
//MOMOMOMO try public
public  SolidItem getValues(){
    double tmp;
    for (int i=0; i<solid.getParaCount(); i++){
      try{
	tmp = new Double(paramField[i].getText()).doubleValue();
      }catch(NumberFormatException e){
	tmp = 0.0;
      }
      solid.setValuesUnits(i, tmp, (String)paramUnit[i].getSelectedItem());
    }
//    dispose();
    return solid;
  }
}
