//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

 // G4 Low energy model: n-n or p-p scattering -- Data
 // THIS FILE contains static array initialization
 // F.W. Jones, L.G. Greeniaus, H.P. Wellisch

// FWJ 27-AUG-2010: extended Coulomb-suppressed data to 5 GeV

 // Table of Cumulative nn or pp Scattering Probabilities
 // To be used for generation as a function of std::cos(theta cm)
 // Coulomb effects are SUPPRESSED
 // -- including pp Coulomb-nuclear interference  
 // NOTE: Assumes angle range to be generated is 0-180 degrees  
 //       even for IDENTICAL particles.  This allows tracking of  
 //       well-defined GEANT4 particles and generation of secondary  
 // Range of validity of tables: 10 - 1200 MeV  
 // Results are extracted from RA Arndt's PSA of 1998  
 // CM Angle range: 0.5 - 179.5 degrees in 1 degree steps  

 #include "G4Types.hh"

 // CM momentum (GeV/c)
 const G4float G4LEpp::Pcm[NENERGY] = {
     0.685E-01, 0.969E-01, 0.137, 0.181, 0.217, 0.237, 0.256,
     0.291, 0.321, 0.349, 0.363, 0.375, 0.400, 0.444,
     0.494, 0.540, 0.573, 0.613, 0.650, 0.685, 0.719, 0.751,
     0.781, 0.810, 0.839, 0.866, 0.893, 0.919, 0.944,
     0.969, 1.016, 1.061, 1.104, 1.146, 1.186, 1.263,
     1.335, 1.404, 1.469, 1.532
 };
 
 // Lab energy (GeV)
 const G4float G4LEpp::Elab[NENERGY] = {
     0.100E-01, 0.200E-01, 0.400E-01, 0.700E-01, 0.100, 0.120, 0.140,
     0.180, 0.220, 0.260, 0.280, 0.300, 0.340, 0.420,
     0.520, 0.620, 0.700, 0.800, 0.900, 1.00, 1.10, 1.20,
     1.30, 1.40, 1.50, 1.60, 1.70, 1.80, 1.90,
     2.00, 2.20, 2.40, 2.60, 2.80, 3.00, 3.40,
     3.80, 4.20, 4.60, 5.00
 };
 
 // Max dSigma/domega-CM (mb/sr)
 const G4float G4LEpp::dSigmax[NENERGY] = {
     63.9, 29.9, 14.5, 8.97, 7.23, 6.66, 6.30,
     5.89, 5.68, 5.57, 5.56, 5.57, 5.74, 6.38,
     7.66, 9.65, 12.4, 15.6, 18.0, 20.1, 22.0, 23.8,
     26.710, 28.910, 31.000, 32.990, 34.900, 36.730, 38.520,
     40.270, 43.680, 46.950, 50.100, 53.160, 55.880, 58.820,
     57.420, 57.820, 58.590, 57.800
 };
 
 // Total cross section
 const G4float G4LEpp::Sigtot[NENERGY] = {
     396., 179., 80.7, 44.5, 32.8, 29.0, 26.9,
     24.9, 24.4, 24.3, 24.4, 24.4, 24.7, 25.5,
     26.4, 26.1, 25.6, 25.1, 24.4, 23.4, 22.4, 21.5,
     22.765, 23.275, 23.744, 24.188, 24.620, 25.058, 25.509,
     25.981, 26.984, 28.055, 29.242, 30.608, 32.026, 34.457,
     34.394, 33.885, 34.122, 33.603
 };
 
 const G4float G4LEpp::Sig[NENERGY][NANGLE] = {
     //------------  0.01 GeV
     {0.00008,   0.00031,   0.00070,   0.00124,   0.00193,   0.00278,   0.00378,
     0.00494,   0.00624,   0.00770,   0.00932,   0.01108,   0.01299,   0.01506,
     0.01727,   0.01963,   0.02214,   0.02480,   0.02760,   0.03055,   0.03364,
     0.03687,   0.04025,   0.04377,   0.04743,   0.05122,   0.05515,   0.05922,
     0.06342,   0.06776,   0.07223,   0.07682,   0.08155,   0.08640,   0.09138,
     0.09649,   0.10171,   0.10706,   0.11252,   0.11810,   0.12380,   0.12961,
     0.13553,   0.14156,   0.14770,   0.15395,   0.16030,   0.16675,   0.17330,
     0.17995,   0.18670,   0.19354,   0.20047,   0.20749,   0.21459,   0.22179,
     0.22906,   0.23642,   0.24385,   0.25136,   0.25895,   0.26660,   0.27433,
     0.28212,   0.28998,   0.29790,   0.30587,   0.31391,   0.32200,   0.33015,
     0.33834,   0.34658,   0.35487,   0.36320,   0.37157,   0.37998,   0.38842,
     0.39690,   0.40540,   0.41394,   0.42250,   0.43108,   0.43968,   0.44830,
     0.45694,   0.46559,   0.47424,   0.48291,   0.49158,   0.50025,   0.50892,
     0.51759,   0.52626,   0.53492,   0.54356,   0.55220,   0.56081,   0.56941,
     0.57799,   0.58655,   0.59508,   0.60358,   0.61206,   0.62050,   0.62890,
     0.63726,   0.64559,   0.65387,   0.66211,   0.67029,   0.67843,   0.68652,
     0.69455,   0.70252,   0.71043,   0.71828,   0.72607,   0.73378,   0.74143,
     0.74901,   0.75651,   0.76394,   0.77128,   0.77855,   0.78574,   0.79283,
     0.79985,   0.80677,   0.81360,   0.82033,   0.82697,   0.83352,   0.83996,
     0.84630,   0.85254,   0.85867,   0.86469,   0.87060,   0.87641,   0.88209,
     0.88767,   0.89312,   0.89846,   0.90368,   0.90877,   0.91374,   0.91859,
     0.92331,   0.92790,   0.93236,   0.93669,   0.94088,   0.94494,   0.94887,
     0.95266,   0.95631,   0.95982,   0.96319,   0.96642,   0.96951,   0.97245,
     0.97525,   0.97790,   0.98040,   0.98276,   0.98497,   0.98703,   0.98894,
     0.99070,   0.99231,   0.99377,   0.99507,   0.99623,   0.99723,   0.99807,
     0.99877,   0.99931,   0.99969,   0.99992,   1.00000},
     //---------  0.02 GeV
    {0.00008,   0.00032,   0.00072,   0.00128,   0.00199,   0.00287,   0.00390,
     0.00509,   0.00644,   0.00795,   0.00961,   0.01142,   0.01339,   0.01552,
     0.01779,   0.02022,   0.02280,   0.02553,   0.02840,   0.03142,   0.03459,
     0.03790,   0.04136,   0.04495,   0.04869,   0.05256,   0.05658,   0.06072,
     0.06500,   0.06942,   0.07396,   0.07863,   0.08343,   0.08835,   0.09340,
     0.09857,   0.10386,   0.10927,   0.11479,   0.12042,   0.12617,   0.13203,
     0.13800,   0.14407,   0.15025,   0.15653,   0.16290,   0.16938,   0.17595,
     0.18262,   0.18938,   0.19622,   0.20316,   0.21018,   0.21728,   0.22447,
     0.23173,   0.23907,   0.24648,   0.25397,   0.26152,   0.26914,   0.27683,
     0.28458,   0.29240,   0.30027,   0.30819,   0.31617,   0.32420,   0.33229,
     0.34041,   0.34859,   0.35680,   0.36506,   0.37335,   0.38168,   0.39004,
     0.39843,   0.40685,   0.41529,   0.42376,   0.43225,   0.44076,   0.44928,
     0.45782,   0.46637,   0.47493,   0.48350,   0.49207,   0.50064,   0.50921,
     0.51778,   0.52634,   0.53490,   0.54344,   0.55198,   0.56050,   0.56900,
     0.57748,   0.58594,   0.59438,   0.60279,   0.61117,   0.61952,   0.62783,
     0.63611,   0.64435,   0.65256,   0.66071,   0.66883,   0.67689,   0.68491,
     0.69287,   0.70078,   0.70863,   0.71642,   0.72416,   0.73182,   0.73943,
     0.74696,   0.75443,   0.76182,   0.76914,   0.77638,   0.78354,   0.79062,
     0.79762,   0.80453,   0.81136,   0.81809,   0.82473,   0.83128,   0.83774,
     0.84410,   0.85035,   0.85651,   0.86256,   0.86850,   0.87434,   0.88006,
     0.88568,   0.89118,   0.89656,   0.90183,   0.90698,   0.91201,   0.91691,
     0.92169,   0.92635,   0.93087,   0.93527,   0.93953,   0.94366,   0.94765,
     0.95151,   0.95523,   0.95882,   0.96226,   0.96555,   0.96871,   0.97172,
     0.97458,   0.97730,   0.97986,   0.98228,   0.98455,   0.98666,   0.98863,
     0.99043,   0.99209,   0.99359,   0.99493,   0.99612,   0.99714,   0.99802,
     0.99873,   0.99929,   0.99968,   0.99992,   1.00000},
     //---------  0.04 GeV
    {0.00009,   0.00034,   0.00077,   0.00138,   0.00215,   0.00309,   0.00421,
     0.00549,   0.00694,   0.00855,   0.01033,   0.01228,   0.01438,   0.01665,
     0.01908,   0.02166,   0.02440,   0.02729,   0.03033,   0.03352,   0.03686,
     0.04034,   0.04397,   0.04773,   0.05164,   0.05568,   0.05986,   0.06417,
     0.06861,   0.07318,   0.07787,   0.08269,   0.08763,   0.09269,   0.09786,
     0.10316,   0.10856,   0.11408,   0.11970,   0.12543,   0.13127,   0.13720,
     0.14324,   0.14938,   0.15561,   0.16194,   0.16836,   0.17487,   0.18146,
     0.18815,   0.19491,   0.20176,   0.20868,   0.21569,   0.22277,   0.22992,
     0.23714,   0.24443,   0.25179,   0.25921,   0.26669,   0.27424,   0.28184,
     0.28949,   0.29721,   0.30497,   0.31278,   0.32064,   0.32854,   0.33649,
     0.34448,   0.35250,   0.36057,   0.36867,   0.37680,   0.38496,   0.39314,
     0.40136,   0.40960,   0.41786,   0.42614,   0.43444,   0.44275,   0.45108,
     0.45942,   0.46777,   0.47612,   0.48448,   0.49285,   0.50121,   0.50958,
     0.51794,   0.52630,   0.53465,   0.54299,   0.55132,   0.55963,   0.56794,
     0.57622,   0.58449,   0.59273,   0.60095,   0.60914,   0.61731,   0.62545,
     0.63355,   0.64163,   0.64966,   0.65766,   0.66562,   0.67354,   0.68141,
     0.68923,   0.69701,   0.70474,   0.71241,   0.72003,   0.72760,   0.73510,
     0.74255,   0.74993,   0.75725,   0.76450,   0.77168,   0.77878,   0.78582,
     0.79278,   0.79966,   0.80647,   0.81319,   0.81983,   0.82638,   0.83285,
     0.83922,   0.84551,   0.85170,   0.85779,   0.86379,   0.86969,   0.87548,
     0.88117,   0.88675,   0.89223,   0.89759,   0.90285,   0.90799,   0.91301,
     0.91791,   0.92269,   0.92735,   0.93189,   0.93629,   0.94057,   0.94472,
     0.94873,   0.95261,   0.95635,   0.95995,   0.96341,   0.96672,   0.96989,
     0.97291,   0.97578,   0.97850,   0.98106,   0.98347,   0.98572,   0.98781,
     0.98974,   0.99151,   0.99311,   0.99455,   0.99582,   0.99693,   0.99786,
     0.99863,   0.99923,   0.99966,   0.99991,   1.00000},
     //---------  0.07 GeV
    {0.00010,   0.00039,   0.00087,   0.00154,   0.00240,   0.00345,   0.00469,
     0.00611,   0.00771,   0.00950,   0.01146,   0.01359,   0.01590,   0.01837,
     0.02101,   0.02381,   0.02677,   0.02988,   0.03314,   0.03656,   0.04012,
     0.04382,   0.04767,   0.05165,   0.05577,   0.06001,   0.06439,   0.06889,
     0.07352,   0.07827,   0.08314,   0.08812,   0.09322,   0.09843,   0.10376,
     0.10919,   0.11472,   0.12036,   0.12610,   0.13193,   0.13787,   0.14389,
     0.15001,   0.15622,   0.16252,   0.16890,   0.17537,   0.18191,   0.18854,
     0.19524,   0.20202,   0.20886,   0.21578,   0.22277,   0.22981,   0.23693,
     0.24410,   0.25133,   0.25862,   0.26596,   0.27335,   0.28079,   0.28828,
     0.29582,   0.30340,   0.31102,   0.31868,   0.32638,   0.33411,   0.34187,
     0.34967,   0.35750,   0.36535,   0.37323,   0.38114,   0.38906,   0.39701,
     0.40498,   0.41296,   0.42096,   0.42898,   0.43700,   0.44504,   0.45309,
     0.46114,   0.46921,   0.47727,   0.48534,   0.49342,   0.50149,   0.50956,
     0.51763,   0.52569,   0.53375,   0.54181,   0.54985,   0.55789,   0.56591,
     0.57392,   0.58191,   0.58989,   0.59786,   0.60580,   0.61372,   0.62162,
     0.62950,   0.63734,   0.64517,   0.65296,   0.66072,   0.66845,   0.67614,
     0.68380,   0.69142,   0.69899,   0.70653,   0.71402,   0.72146,   0.72886,
     0.73621,   0.74350,   0.75074,   0.75792,   0.76504,   0.77210,   0.77910,
     0.78603,   0.79289,   0.79969,   0.80641,   0.81306,   0.81963,   0.82612,
     0.83253,   0.83886,   0.84511,   0.85126,   0.85733,   0.86331,   0.86919,
     0.87497,   0.88066,   0.88625,   0.89174,   0.89712,   0.90239,   0.90756,
     0.91261,   0.91755,   0.92238,   0.92708,   0.93167,   0.93614,   0.94047,
     0.94469,   0.94877,   0.95271,   0.95653,   0.96020,   0.96373,   0.96712,
     0.97035,   0.97344,   0.97638,   0.97915,   0.98177,   0.98422,   0.98651,
     0.98863,   0.99057,   0.99234,   0.99394,   0.99535,   0.99657,   0.99762,
     0.99847,   0.99914,   0.99962,   0.99990,   1.00000},
     //---------  0.1 GeV
    {0.00011,   0.00042,   0.00095,   0.00168,   0.00262,   0.00377,   0.00511,
     0.00665,   0.00838,   0.01030,   0.01240,   0.01469,   0.01714,   0.01977,
     0.02257,   0.02552,   0.02863,   0.03189,   0.03531,   0.03886,   0.04256,
     0.04640,   0.05037,   0.05447,   0.05871,   0.06306,   0.06754,   0.07214,
     0.07686,   0.08170,   0.08664,   0.09170,   0.09687,   0.10214,   0.10752,
     0.11300,   0.11858,   0.12426,   0.13004,   0.13591,   0.14187,   0.14792,
     0.15406,   0.16028,   0.16659,   0.17297,   0.17944,   0.18598,   0.19259,
     0.19928,   0.20604,   0.21286,   0.21974,   0.22669,   0.23370,   0.24077,
     0.24789,   0.25506,   0.26229,   0.26956,   0.27688,   0.28425,   0.29166,
     0.29910,   0.30659,   0.31411,   0.32167,   0.32926,   0.33688,   0.34453,
     0.35221,   0.35991,   0.36764,   0.37539,   0.38316,   0.39096,   0.39877,
     0.40660,   0.41444,   0.42230,   0.43017,   0.43805,   0.44594,   0.45384,
     0.46174,   0.46966,   0.47757,   0.48549,   0.49342,   0.50134,   0.50926,
     0.51718,   0.52510,   0.53301,   0.54091,   0.54881,   0.55670,   0.56458,
     0.57244,   0.58030,   0.58814,   0.59596,   0.60377,   0.61156,   0.61933,
     0.62707,   0.63480,   0.64250,   0.65017,   0.65782,   0.66544,   0.67303,
     0.68058,   0.68810,   0.69559,   0.70304,   0.71045,   0.71781,   0.72514,
     0.73242,   0.73965,   0.74683,   0.75396,   0.76103,   0.76805,   0.77502,
     0.78192,   0.78876,   0.79553,   0.80224,   0.80888,   0.81544,   0.82194,
     0.82835,   0.83469,   0.84095,   0.84712,   0.85321,   0.85922,   0.86513,
     0.87095,   0.87668,   0.88231,   0.88785,   0.89329,   0.89862,   0.90385,
     0.90898,   0.91400,   0.91890,   0.92370,   0.92838,   0.93294,   0.93739,
     0.94171,   0.94591,   0.94998,   0.95392,   0.95773,   0.96140,   0.96493,
     0.96832,   0.97156,   0.97465,   0.97758,   0.98036,   0.98296,   0.98541,
     0.98767,   0.98976,   0.99167,   0.99339,   0.99492,   0.99626,   0.99739,
     0.99833,   0.99906,   0.99958,   0.99990,   1.00000},
     //---------  0.12 GeV
    {0.00011,   0.00044,   0.00099,   0.00175,   0.00272,   0.00391,   0.00530,
     0.00689,   0.00867,   0.01065,   0.01280,   0.01514,   0.01765,   0.02033,
     0.02318,   0.02618,   0.02933,   0.03263,   0.03608,   0.03966,   0.04339,
     0.04724,   0.05123,   0.05534,   0.05958,   0.06394,   0.06842,   0.07302,
     0.07773,   0.08255,   0.08748,   0.09252,   0.09767,   0.10292,   0.10827,
     0.11372,   0.11927,   0.12492,   0.13066,   0.13649,   0.14242,   0.14843,
     0.15453,   0.16071,   0.16697,   0.17332,   0.17974,   0.18624,   0.19281,
     0.19945,   0.20617,   0.21295,   0.21979,   0.22670,   0.23367,   0.24070,
     0.24778,   0.25492,   0.26211,   0.26935,   0.27664,   0.28398,   0.29136,
     0.29878,   0.30624,   0.31375,   0.32129,   0.32886,   0.33647,   0.34411,
     0.35178,   0.35948,   0.36720,   0.37495,   0.38273,   0.39052,   0.39834,
     0.40618,   0.41403,   0.42190,   0.42978,   0.43768,   0.44559,   0.45351,
     0.46144,   0.46937,   0.47731,   0.48525,   0.49320,   0.50114,   0.50909,
     0.51703,   0.52497,   0.53291,   0.54084,   0.54876,   0.55667,   0.56456,
     0.57245,   0.58032,   0.58818,   0.59602,   0.60383,   0.61163,   0.61941,
     0.62717,   0.63490,   0.64260,   0.65027,   0.65792,   0.66553,   0.67311,
     0.68066,   0.68817,   0.69564,   0.70307,   0.71046,   0.71781,   0.72511,
     0.73237,   0.73957,   0.74673,   0.75383,   0.76088,   0.76787,   0.77480,
     0.78166,   0.78847,   0.79521,   0.80188,   0.80848,   0.81501,   0.82147,
     0.82785,   0.83415,   0.84038,   0.84652,   0.85257,   0.85854,   0.86442,
     0.87022,   0.87592,   0.88152,   0.88703,   0.89245,   0.89776,   0.90297,
     0.90808,   0.91309,   0.91798,   0.92277,   0.92745,   0.93201,   0.93646,
     0.94079,   0.94500,   0.94908,   0.95304,   0.95687,   0.96057,   0.96413,
     0.96756,   0.97084,   0.97397,   0.97695,   0.97978,   0.98244,   0.98494,
     0.98726,   0.98941,   0.99137,   0.99315,   0.99473,   0.99611,   0.99729,
     0.99826,   0.99902,   0.99956,   0.99989,   1.00000},
     //---------  0.14 GeV
    {0.00011,   0.00045,   0.00101,   0.00178,   0.00278,   0.00398,   0.00540,
     0.00701,   0.00882,   0.01081,   0.01299,   0.01534,   0.01787,   0.02055,
     0.02340,   0.02640,   0.02954,   0.03283,   0.03626,   0.03983,   0.04352,
     0.04735,   0.05130,   0.05537,   0.05957,   0.06388,   0.06830,   0.07284,
     0.07750,   0.08226,   0.08712,   0.09210,   0.09718,   0.10236,   0.10764,
     0.11302,   0.11850,   0.12407,   0.12974,   0.13550,   0.14135,   0.14729,
     0.15331,   0.15942,   0.16562,   0.17190,   0.17825,   0.18469,   0.19120,
     0.19778,   0.20444,   0.21117,   0.21797,   0.22483,   0.23176,   0.23875,
     0.24580,   0.25292,   0.26008,   0.26731,   0.27458,   0.28191,   0.28929,
     0.29672,   0.30419,   0.31171,   0.31927,   0.32687,   0.33451,   0.34218,
     0.34990,   0.35764,   0.36542,   0.37323,   0.38107,   0.38894,   0.39683,
     0.40474,   0.41268,   0.42064,   0.42862,   0.43661,   0.44462,   0.45264,
     0.46067,   0.46871,   0.47676,   0.48481,   0.49287,   0.50093,   0.50899,
     0.51704,   0.52510,   0.53314,   0.54118,   0.54920,   0.55722,   0.56522,
     0.57320,   0.58117,   0.58912,   0.59705,   0.60495,   0.61283,   0.62068,
     0.62850,   0.63630,   0.64406,   0.65179,   0.65948,   0.66714,   0.67476,
     0.68234,   0.68988,   0.69737,   0.70482,   0.71222,   0.71957,   0.72688,
     0.73413,   0.74132,   0.74846,   0.75554,   0.76257,   0.76953,   0.77642,
     0.78326,   0.79002,   0.79672,   0.80334,   0.80989,   0.81637,   0.82277,
     0.82909,   0.83534,   0.84150,   0.84757,   0.85357,   0.85947,   0.86529,
     0.87101,   0.87664,   0.88218,   0.88763,   0.89298,   0.89822,   0.90337,
     0.90842,   0.91336,   0.91820,   0.92293,   0.92756,   0.93207,   0.93647,
     0.94075,   0.94492,   0.94897,   0.95290,   0.95670,   0.96037,   0.96392,
     0.96733,   0.97060,   0.97373,   0.97671,   0.97954,   0.98222,   0.98473,
     0.98707,   0.98924,   0.99122,   0.99302,   0.99463,   0.99603,   0.99723,
     0.99822,   0.99900,   0.99955,   0.99989,   1.00000},
     //---------  0.18 GeV
    {0.00011,   0.00045,   0.00101,   0.00180,   0.00279,   0.00400,   0.00541,
     0.00701,   0.00880,   0.01077,   0.01291,   0.01522,   0.01768,   0.02030,
     0.02307,   0.02597,   0.02901,   0.03218,   0.03549,   0.03891,   0.04246,
     0.04613,   0.04991,   0.05381,   0.05783,   0.06195,   0.06619,   0.07053,
     0.07498,   0.07954,   0.08420,   0.08897,   0.09384,   0.09881,   0.10388,
     0.10905,   0.11432,   0.11969,   0.12515,   0.13071,   0.13637,   0.14212,
     0.14796,   0.15390,   0.15993,   0.16605,   0.17225,   0.17855,   0.18493,
     0.19140,   0.19795,   0.20458,   0.21129,   0.21809,   0.22496,   0.23191,
     0.23893,   0.24602,   0.25319,   0.26043,   0.26773,   0.27510,   0.28254,
     0.29004,   0.29760,   0.30522,   0.31289,   0.32063,   0.32841,   0.33625,
     0.34414,   0.35207,   0.36006,   0.36808,   0.37615,   0.38426,   0.39240,
     0.40058,   0.40880,   0.41704,   0.42531,   0.43360,   0.44192,   0.45026,
     0.45862,   0.46699,   0.47537,   0.48376,   0.49215,   0.50055,   0.50895,
     0.51734,   0.52573,   0.53411,   0.54248,   0.55083,   0.55917,   0.56748,
     0.57578,   0.58404,   0.59228,   0.60049,   0.60867,   0.61681,   0.62491,
     0.63297,   0.64099,   0.64896,   0.65689,   0.66477,   0.67260,   0.68038,
     0.68810,   0.69577,   0.70337,   0.71092,   0.71841,   0.72583,   0.73319,
     0.74048,   0.74770,   0.75486,   0.76194,   0.76894,   0.77587,   0.78273,
     0.78950,   0.79620,   0.80281,   0.80935,   0.81579,   0.82216,   0.82843,
     0.83462,   0.84071,   0.84672,   0.85264,   0.85846,   0.86419,   0.86982,
     0.87536,   0.88081,   0.88615,   0.89140,   0.89655,   0.90160,   0.90655,
     0.91139,   0.91614,   0.92078,   0.92532,   0.92975,   0.93407,   0.93829,
     0.94239,   0.94639,   0.95027,   0.95404,   0.95770,   0.96123,   0.96464,
     0.96793,   0.97109,   0.97412,   0.97701,   0.97976,   0.98237,   0.98483,
     0.98713,   0.98926,   0.99123,   0.99301,   0.99461,   0.99601,   0.99721,
     0.99821,   0.99899,   0.99955,   0.99989,   1.00000},
     //---------  0.22 GeV
    {0.00011,   0.00045,   0.00100,   0.00177,   0.00274,   0.00392,   0.00529,
     0.00685,   0.00858,   0.01049,   0.01255,   0.01477,   0.01714,   0.01964,
     0.02229,   0.02506,   0.02796,   0.03099,   0.03414,   0.03740,   0.04078,
     0.04428,   0.04789,   0.05161,   0.05544,   0.05938,   0.06343,   0.06759,
     0.07186,   0.07623,   0.08071,   0.08529,   0.08998,   0.09477,   0.09967,
     0.10467,   0.10977,   0.11498,   0.12029,   0.12571,   0.13122,   0.13684,
     0.14256,   0.14839,   0.15431,   0.16033,   0.16645,   0.17267,   0.17898,
     0.18540,   0.19190,   0.19850,   0.20519,   0.21197,   0.21884,   0.22580,
     0.23284,   0.23997,   0.24718,   0.25447,   0.26183,   0.26928,   0.27680,
     0.28440,   0.29206,   0.29980,   0.30760,   0.31547,   0.32340,   0.33139,
     0.33945,   0.34755,   0.35572,   0.36394,   0.37220,   0.38052,   0.38887,
     0.39728,   0.40572,   0.41419,   0.42270,   0.43124,   0.43981,   0.44840,
     0.45702,   0.46565,   0.47429,   0.48295,   0.49161,   0.50028,   0.50894,
     0.51760,   0.52626,   0.53490,   0.54354,   0.55215,   0.56074,   0.56931,
     0.57785,   0.58636,   0.59484,   0.60328,   0.61168,   0.62004,   0.62835,
     0.63662,   0.64483,   0.65300,   0.66110,   0.66916,   0.67715,   0.68508,
     0.69294,   0.70075,   0.70848,   0.71614,   0.72373,   0.73125,   0.73869,
     0.74606,   0.75334,   0.76055,   0.76767,   0.77470,   0.78165,   0.78852,
     0.79529,   0.80197,   0.80856,   0.81506,   0.82146,   0.82776,   0.83397,
     0.84008,   0.84609,   0.85200,   0.85781,   0.86352,   0.86913,   0.87464,
     0.88004,   0.88534,   0.89053,   0.89562,   0.90061,   0.90550,   0.91028,
     0.91495,   0.91952,   0.92398,   0.92834,   0.93259,   0.93674,   0.94078,
     0.94471,   0.94853,   0.95224,   0.95583,   0.95932,   0.96269,   0.96595,
     0.96909,   0.97210,   0.97500,   0.97776,   0.98040,   0.98290,   0.98526,
     0.98747,   0.98953,   0.99143,   0.99316,   0.99472,   0.99609,   0.99726,
     0.99824,   0.99900,   0.99956,   0.99989,   1.00000},
     //---------  0.26 GeV
    {0.00011,   0.00044,   0.00098,   0.00173,   0.00269,   0.00384,   0.00518,
     0.00670,   0.00838,   0.01023,   0.01222,   0.01436,   0.01665,   0.01906,
     0.02161,   0.02428,   0.02707,   0.02999,   0.03302,   0.03617,   0.03943,
     0.04281,   0.04630,   0.04990,   0.05361,   0.05743,   0.06137,   0.06541,
     0.06956,   0.07382,   0.07819,   0.08267,   0.08726,   0.09195,   0.09676,
     0.10167,   0.10669,   0.11182,   0.11706,   0.12241,   0.12787,   0.13344,
     0.13911,   0.14489,   0.15078,   0.15678,   0.16288,   0.16909,   0.17540,
     0.18182,   0.18834,   0.19495,   0.20167,   0.20849,   0.21540,   0.22241,
     0.22950,   0.23669,   0.24397,   0.25133,   0.25878,   0.26631,   0.27392,
     0.28160,   0.28936,   0.29720,   0.30510,   0.31307,   0.32111,   0.32921,
     0.33736,   0.34558,   0.35385,   0.36217,   0.37054,   0.37896,   0.38743,
     0.39593,   0.40447,   0.41305,   0.42166,   0.43030,   0.43897,   0.44766,
     0.45636,   0.46509,   0.47383,   0.48258,   0.49133,   0.50009,   0.50885,
     0.51761,   0.52636,   0.53510,   0.54383,   0.55254,   0.56123,   0.56990,
     0.57854,   0.58715,   0.59573,   0.60427,   0.61278,   0.62125,   0.62967,
     0.63804,   0.64637,   0.65464,   0.66286,   0.67102,   0.67912,   0.68716,
     0.69514,   0.70304,   0.71088,   0.71864,   0.72633,   0.73394,   0.74147,
     0.74892,   0.75628,   0.76356,   0.77075,   0.77785,   0.78485,   0.79176,
     0.79858,   0.80530,   0.81191,   0.81843,   0.82484,   0.83115,   0.83736,
     0.84345,   0.84945,   0.85533,   0.86111,   0.86678,   0.87234,   0.87779,
     0.88313,   0.88836,   0.89349,   0.89850,   0.90341,   0.90821,   0.91290,
     0.91748,   0.92195,   0.92631,   0.93056,   0.93471,   0.93874,   0.94267,
     0.94648,   0.95019,   0.95378,   0.95726,   0.96063,   0.96389,   0.96703,
     0.97006,   0.97297,   0.97576,   0.97842,   0.98096,   0.98338,   0.98565,
     0.98779,   0.98979,   0.99163,   0.99331,   0.99483,   0.99616,   0.99731,
     0.99827,   0.99902,   0.99956,   0.99989,   1.00000},
     //---------  0.28 GeV
    {0.00011,   0.00044,   0.00098,   0.00172,   0.00267,   0.00382,   0.00514,
     0.00664,   0.00831,   0.01014,   0.01211,   0.01422,   0.01648,   0.01886,
     0.02137,   0.02401,   0.02677,   0.02965,   0.03265,   0.03576,   0.03899,
     0.04233,   0.04578,   0.04935,   0.05303,   0.05683,   0.06073,   0.06475,
     0.06888,   0.07311,   0.07746,   0.08192,   0.08650,   0.09118,   0.09597,
     0.10088,   0.10589,   0.11102,   0.11626,   0.12161,   0.12708,   0.13265,
     0.13834,   0.14413,   0.15004,   0.15605,   0.16218,   0.16841,   0.17474,
     0.18119,   0.18773,   0.19438,   0.20113,   0.20797,   0.21492,   0.22195,
     0.22908,   0.23630,   0.24361,   0.25101,   0.25848,   0.26604,   0.27368,
     0.28139,   0.28918,   0.29704,   0.30496,   0.31295,   0.32101,   0.32912,
     0.33730,   0.34553,   0.35381,   0.36214,   0.37052,   0.37895,   0.38741,
     0.39592,   0.40446,   0.41304,   0.42165,   0.43029,   0.43895,   0.44763,
     0.45634,   0.46506,   0.47379,   0.48253,   0.49128,   0.50003,   0.50878,
     0.51753,   0.52627,   0.53500,   0.54373,   0.55243,   0.56112,   0.56978,
     0.57842,   0.58703,   0.59561,   0.60416,   0.61267,   0.62114,   0.62957,
     0.63796,   0.64629,   0.65458,   0.66281,   0.67099,   0.67911,   0.68717,
     0.69516,   0.70309,   0.71096,   0.71875,   0.72646,   0.73410,   0.74166,
     0.74914,   0.75654,   0.76385,   0.77108,   0.77821,   0.78525,   0.79219,
     0.79904,   0.80579,   0.81243,   0.81898,   0.82542,   0.83176,   0.83799,
     0.84411,   0.85012,   0.85603,   0.86182,   0.86750,   0.87307,   0.87853,
     0.88388,   0.88912,   0.89424,   0.89925,   0.90415,   0.90894,   0.91362,
     0.91818,   0.92264,   0.92698,   0.93122,   0.93534,   0.93935,   0.94325,
     0.94704,   0.95071,   0.95427,   0.95773,   0.96106,   0.96429,   0.96739,
     0.97039,   0.97326,   0.97601,   0.97865,   0.98116,   0.98354,   0.98579,
     0.98790,   0.98987,   0.99170,   0.99336,   0.99486,   0.99619,   0.99733,
     0.99828,   0.99902,   0.99956,   0.99989,   1.00000},
     //---------  0.30 GeV
    {0.00011,   0.00044,   0.00097,   0.00172,   0.00267,   0.00380,   0.00512,
     0.00661,   0.00827,   0.01008,   0.01204,   0.01414,   0.01637,   0.01873,
     0.02122,   0.02384,   0.02658,   0.02944,   0.03241,   0.03551,   0.03872,
     0.04204,   0.04548,   0.04904,   0.05271,   0.05650,   0.06039,   0.06441,
     0.06853,   0.07277,   0.07712,   0.08159,   0.08617,   0.09086,   0.09567,
     0.10059,   0.10562,   0.11077,   0.11604,   0.12141,   0.12690,   0.13251,
     0.13822,   0.14405,   0.14999,   0.15605,   0.16221,   0.16847,   0.17485,
     0.18133,   0.18791,   0.19460,   0.20138,   0.20827,   0.21525,   0.22232,
     0.22948,   0.23673,   0.24406,   0.25148,   0.25898,   0.26656,   0.27422,
     0.28194,   0.28974,   0.29761,   0.30554,   0.31353,   0.32158,   0.32969,
     0.33786,   0.34607,   0.35434,   0.36266,   0.37102,   0.37942,   0.38786,
     0.39634,   0.40485,   0.41340,   0.42197,   0.43057,   0.43919,   0.44784,
     0.45650,   0.46518,   0.47387,   0.48256,   0.49127,   0.49998,   0.50868,
     0.51739,   0.52609,   0.53478,   0.54346,   0.55212,   0.56077,   0.56939,
     0.57800,   0.58657,   0.59512,   0.60364,   0.61212,   0.62057,   0.62897,
     0.63734,   0.64566,   0.65393,   0.66215,   0.67032,   0.67844,   0.68650,
     0.69450,   0.70243,   0.71030,   0.71811,   0.72584,   0.73350,   0.74108,
     0.74858,   0.75601,   0.76335,   0.77060,   0.77777,   0.78484,   0.79182,
     0.79871,   0.80550,   0.81218,   0.81877,   0.82525,   0.83163,   0.83790,
     0.84406,   0.85011,   0.85605,   0.86188,   0.86759,   0.87320,   0.87869,
     0.88406,   0.88932,   0.89447,   0.89950,   0.90442,   0.90922,   0.91391,
     0.91849,   0.92295,   0.92730,   0.93154,   0.93566,   0.93966,   0.94356,
     0.94734,   0.95101,   0.95456,   0.95800,   0.96132,   0.96452,   0.96761,
     0.97059,   0.97344,   0.97618,   0.97879,   0.98128,   0.98364,   0.98587,
     0.98797,   0.98993,   0.99173,   0.99339,   0.99488,   0.99620,   0.99733,
     0.99828,   0.99903,   0.99957,   0.99989,   1.00000},
     //---------  0.34 GeV
    {0.00011,   0.00044,   0.00099,   0.00175,   0.00271,   0.00387,   0.00520,
     0.00671,   0.00838,   0.01021,   0.01218,   0.01429,   0.01654,   0.01892,
     0.02143,   0.02406,   0.02682,   0.02969,   0.03269,   0.03581,   0.03905,
     0.04241,   0.04588,   0.04947,   0.05318,   0.05701,   0.06095,   0.06501,
     0.06918,   0.07347,   0.07788,   0.08240,   0.08704,   0.09180,   0.09667,
     0.10166,   0.10676,   0.11198,   0.11732,   0.12277,   0.12833,   0.13401,
     0.13980,   0.14571,   0.15172,   0.15785,   0.16408,   0.17042,   0.17687,
     0.18341,   0.19006,   0.19680,   0.20364,   0.21057,   0.21760,   0.22471,
     0.23190,   0.23918,   0.24653,   0.25397,   0.26147,   0.26905,   0.27670,
     0.28441,   0.29218,   0.30002,   0.30791,   0.31586,   0.32386,   0.33191,
     0.34001,   0.34815,   0.35634,   0.36457,   0.37284,   0.38114,   0.38948,
     0.39785,   0.40624,   0.41467,   0.42312,   0.43159,   0.44009,   0.44860,
     0.45713,   0.46567,   0.47422,   0.48277,   0.49134,   0.49990,   0.50847,
     0.51703,   0.52559,   0.53414,   0.54268,   0.55121,   0.55973,   0.56822,
     0.57670,   0.58516,   0.59359,   0.60199,   0.61036,   0.61871,   0.62702,
     0.63529,   0.64352,   0.65172,   0.65987,   0.66797,   0.67603,   0.68404,
     0.69199,   0.69989,   0.70773,   0.71551,   0.72323,   0.73088,   0.73847,
     0.74598,   0.75342,   0.76078,   0.76806,   0.77526,   0.78238,   0.78941,
     0.79634,   0.80319,   0.80994,   0.81659,   0.82314,   0.82959,   0.83593,
     0.84216,   0.84829,   0.85431,   0.86022,   0.86601,   0.87169,   0.87726,
     0.88271,   0.88805,   0.89327,   0.89837,   0.90336,   0.90823,   0.91299,
     0.91763,   0.92215,   0.92655,   0.93084,   0.93502,   0.93907,   0.94301,
     0.94684,   0.95054,   0.95413,   0.95761,   0.96096,   0.96420,   0.96732,
     0.97031,   0.97319,   0.97595,   0.97858,   0.98109,   0.98346,   0.98571,
     0.98782,   0.98980,   0.99162,   0.99329,   0.99480,   0.99613,   0.99729,
     0.99825,   0.99901,   0.99956,   0.99989,   1.00000},
     //---------  0.42 GeV
    {0.00012,   0.00048,   0.00107,   0.00188,   0.00291,   0.00414,   0.00557,
     0.00717,   0.00895,   0.01089,   0.01299,   0.01523,   0.01762,   0.02014,
     0.02281,   0.02561,   0.02854,   0.03160,   0.03479,   0.03811,   0.04155,
     0.04513,   0.04882,   0.05264,   0.05658,   0.06064,   0.06482,   0.06912,
     0.07355,   0.07809,   0.08275,   0.08752,   0.09242,   0.09742,   0.10255,
     0.10779,   0.11315,   0.11861,   0.12419,   0.12988,   0.13568,   0.14159,
     0.14760,   0.15372,   0.15994,   0.16625,   0.17266,   0.17917,   0.18576,
     0.19244,   0.19921,   0.20606,   0.21298,   0.21998,   0.22705,   0.23419,
     0.24139,   0.24865,   0.25598,   0.26335,   0.27078,   0.27826,   0.28579,
     0.29336,   0.30098,   0.30863,   0.31632,   0.32405,   0.33181,   0.33960,
     0.34742,   0.35527,   0.36315,   0.37106,   0.37898,   0.38694,   0.39491,
     0.40290,   0.41091,   0.41894,   0.42698,   0.43504,   0.44311,   0.45119,
     0.45929,   0.46739,   0.47549,   0.48360,   0.49172,   0.49984,   0.50795,
     0.51607,   0.52418,   0.53229,   0.54039,   0.54849,   0.55657,   0.56465,
     0.57271,   0.58076,   0.58879,   0.59680,   0.60480,   0.61278,   0.62073,
     0.62867,   0.63658,   0.64446,   0.65232,   0.66015,   0.66795,   0.67572,
     0.68345,   0.69115,   0.69881,   0.70643,   0.71401,   0.72154,   0.72903,
     0.73647,   0.74385,   0.75118,   0.75845,   0.76566,   0.77281,   0.77988,
     0.78689,   0.79382,   0.80067,   0.80745,   0.81414,   0.82074,   0.82725,
     0.83367,   0.83999,   0.84621,   0.85233,   0.85835,   0.86426,   0.87006,
     0.87576,   0.88134,   0.88681,   0.89217,   0.89742,   0.90254,   0.90756,
     0.91245,   0.91723,   0.92189,   0.92643,   0.93086,   0.93516,   0.93935,
     0.94341,   0.94735,   0.95117,   0.95486,   0.95844,   0.96188,   0.96520,
     0.96839,   0.97146,   0.97439,   0.97719,   0.97985,   0.98238,   0.98477,
     0.98701,   0.98910,   0.99104,   0.99282,   0.99443,   0.99585,   0.99709,
     0.99812,   0.99893,   0.99952,   0.99988,   1.00000},
     //---------  0.52 GeV
    {0.00014,   0.00055,   0.00124,   0.00219,   0.00338,   0.00481,   0.00647,
     0.00834,   0.01041,   0.01267,   0.01512,   0.01775,   0.02055,   0.02353,
     0.02666,   0.02996,   0.03341,   0.03701,   0.04076,   0.04466,   0.04870,
     0.05288,   0.05719,   0.06164,   0.06621,   0.07092,   0.07574,   0.08069,
     0.08575,   0.09093,   0.09622,   0.10162,   0.10713,   0.11275,   0.11847,
     0.12429,   0.13020,   0.13621,   0.14231,   0.14850,   0.15477,   0.16112,
     0.16755,   0.17406,   0.18063,   0.18726,   0.19396,   0.20071,   0.20751,
     0.21436,   0.22126,   0.22819,   0.23516,   0.24217,   0.24920,   0.25625,
     0.26333,   0.27043,   0.27754,   0.28467,   0.29181,   0.29896,   0.30611,
     0.31328,   0.32044,   0.32761,   0.33478,   0.34196,   0.34913,   0.35631,
     0.36348,   0.37066,   0.37784,   0.38501,   0.39219,   0.39936,   0.40654,
     0.41371,   0.42088,   0.42806,   0.43523,   0.44241,   0.44959,   0.45676,
     0.46394,   0.47112,   0.47830,   0.48547,   0.49265,   0.49983,   0.50701,
     0.51419,   0.52137,   0.52855,   0.53573,   0.54291,   0.55009,   0.55726,
     0.56444,   0.57162,   0.57880,   0.58598,   0.59316,   0.60034,   0.60752,
     0.61470,   0.62188,   0.62906,   0.63624,   0.64342,   0.65060,   0.65778,
     0.66496,   0.67214,   0.67932,   0.68649,   0.69366,   0.70083,   0.70798,
     0.71513,   0.72226,   0.72938,   0.73649,   0.74357,   0.75064,   0.75768,
     0.76469,   0.77166,   0.77861,   0.78551,   0.79237,   0.79918,   0.80593,
     0.81264,   0.81928,   0.82585,   0.83236,   0.83880,   0.84515,   0.85143,
     0.85763,   0.86373,   0.86975,   0.87567,   0.88149,   0.88721,   0.89283,
     0.89834,   0.90375,   0.90904,   0.91423,   0.91929,   0.92424,   0.92907,
     0.93377,   0.93835,   0.94279,   0.94711,   0.95129,   0.95533,   0.95923,
     0.96298,   0.96659,   0.97004,   0.97333,   0.97647,   0.97944,   0.98224,
     0.98487,   0.98732,   0.98959,   0.99166,   0.99353,   0.99519,   0.99662,
     0.99781,   0.99876,   0.99945,   0.99986,   1.00000},
     //---------  0.62 GeV
    {0.00018,   0.00070,   0.00158,   0.00278,   0.00431,   0.00615,   0.00828,
     0.01070,   0.01339,   0.01635,   0.01956,   0.02301,   0.02670,   0.03062,
     0.03476,   0.03912,   0.04368,   0.04843,   0.05337,   0.05850,   0.06379,
     0.06925,   0.07486,   0.08062,   0.08653,   0.09256,   0.09872,   0.10500,
     0.11139,   0.11789,   0.12448,   0.13117,   0.13795,   0.14480,   0.15172,
     0.15871,   0.16575,   0.17285,   0.17999,   0.18716,   0.19437,   0.20159,
     0.20883,   0.21607,   0.22332,   0.23055,   0.23777,   0.24497,   0.25214,
     0.25928,   0.26638,   0.27343,   0.28044,   0.28739,   0.29428,   0.30112,
     0.30789,   0.31460,   0.32125,   0.32782,   0.33433,   0.34077,   0.34714,
     0.35344,   0.35967,   0.36584,   0.37195,   0.37799,   0.38396,   0.38988,
     0.39574,   0.40155,   0.40730,   0.41301,   0.41866,   0.42428,   0.42985,
     0.43538,   0.44087,   0.44634,   0.45177,   0.45718,   0.46256,   0.46792,
     0.47327,   0.47860,   0.48391,   0.48922,   0.49452,   0.49982,   0.50512,
     0.51043,   0.51574,   0.52106,   0.52639,   0.53173,   0.53710,   0.54248,
     0.54789,   0.55333,   0.55880,   0.56430,   0.56983,   0.57541,   0.58103,
     0.58669,   0.59240,   0.59816,   0.60397,   0.60984,   0.61576,   0.62174,
     0.62779,   0.63390,   0.64008,   0.64632,   0.65263,   0.65900,   0.66545,
     0.67196,   0.67855,   0.68520,   0.69192,   0.69870,   0.70554,   0.71244,
     0.71940,   0.72642,   0.73348,   0.74059,   0.74773,   0.75491,   0.76211,
     0.76934,   0.77658,   0.78383,   0.79108,   0.79833,   0.80556,   0.81277,
     0.81995,   0.82709,   0.83419,   0.84124,   0.84824,   0.85517,   0.86202,
     0.86880,   0.87549,   0.88209,   0.88859,   0.89498,   0.90126,   0.90743,
     0.91346,   0.91937,   0.92513,   0.93074,   0.93620,   0.94150,   0.94662,
     0.95157,   0.95632,   0.96088,   0.96524,   0.96938,   0.97330,   0.97699,
     0.98044,   0.98365,   0.98660,   0.98930,   0.99171,   0.99385,   0.99569,
     0.99722,   0.99842,   0.99930,   0.99982,   1.00000},
     //---------  0.70 GeV
    {0.00023,   0.00093,   0.00207,   0.00366,   0.00567,   0.00810,   0.01091,
     0.01410,   0.01765,   0.02155,   0.02578,   0.03032,   0.03517,   0.04031,
     0.04572,   0.05139,   0.05731,   0.06345,   0.06981,   0.07636,   0.08310,
     0.09002,   0.09708,   0.10429,   0.11163,   0.11908,   0.12665,   0.13430,
     0.14203,   0.14984,   0.15771,   0.16562,   0.17357,   0.18155,   0.18955,
     0.19755,   0.20555,   0.21354,   0.22150,   0.22942,   0.23731,   0.24514,
     0.25290,   0.26060,   0.26822,   0.27575,   0.28318,   0.29052,   0.29774,
     0.30486,   0.31185,   0.31873,   0.32548,   0.33210,   0.33859,   0.34496,
     0.35118,   0.35728,   0.36325,   0.36908,   0.37479,   0.38036,   0.38581,
     0.39114,   0.39635,   0.40145,   0.40643,   0.41130,   0.41606,   0.42073,
     0.42529,   0.42977,   0.43416,   0.43846,   0.44268,   0.44683,   0.45091,
     0.45493,   0.45888,   0.46278,   0.46663,   0.47043,   0.47419,   0.47792,
     0.48161,   0.48528,   0.48893,   0.49256,   0.49619,   0.49981,   0.50342,
     0.50705,   0.51068,   0.51433,   0.51800,   0.52170,   0.52543,   0.52919,
     0.53300,   0.53685,   0.54075,   0.54471,   0.54872,   0.55281,   0.55696,
     0.56119,   0.56550,   0.56989,   0.57437,   0.57894,   0.58361,   0.58839,
     0.59326,   0.59825,   0.60335,   0.60856,   0.61390,   0.61936,   0.62494,
     0.63065,   0.63650,   0.64247,   0.64857,   0.65481,   0.66118,   0.66768,
     0.67431,   0.68107,   0.68795,   0.69496,   0.70208,   0.70931,   0.71665,
     0.72410,   0.73164,   0.73926,   0.74696,   0.75474,   0.76258,   0.77047,
     0.77840,   0.78637,   0.79436,   0.80237,   0.81037,   0.81838,   0.82636,
     0.83432,   0.84224,   0.85011,   0.85792,   0.86566,   0.87332,   0.88088,
     0.88834,   0.89568,   0.90289,   0.90996,   0.91688,   0.92362,   0.93018,
     0.93654,   0.94268,   0.94860,   0.95427,   0.95968,   0.96482,   0.96967,
     0.97422,   0.97845,   0.98235,   0.98590,   0.98909,   0.99190,   0.99433,
     0.99634,   0.99793,   0.99907,   0.99977,   1.00000},
     //---------  0.80 GeV
    {0.00030,   0.00119,   0.00266,   0.00469,   0.00727,   0.01037,   0.01397,
     0.01805,   0.02259,   0.02756,   0.03294,   0.03872,   0.04486,   0.05135,
     0.05816,   0.06528,   0.07267,   0.08031,   0.08818,   0.09626,   0.10452,
     0.11294,   0.12151,   0.13020,   0.13899,   0.14786,   0.15680,   0.16579,
     0.17481,   0.18385,   0.19288,   0.20190,   0.21089,   0.21984,   0.22873,
     0.23755,   0.24629,   0.25493,   0.26346,   0.27187,   0.28016,   0.28830,
     0.29630,   0.30414,   0.31182,   0.31933,   0.32666,   0.33381,   0.34078,
     0.34756,   0.35415,   0.36055,   0.36677,   0.37279,   0.37863,   0.38428,
     0.38974,   0.39503,   0.40014,   0.40507,   0.40984,   0.41445,   0.41890,
     0.42319,   0.42734,   0.43134,   0.43521,   0.43895,   0.44257,   0.44607,
     0.44945,   0.45273,   0.45590,   0.45898,   0.46197,   0.46487,   0.46770,
     0.47045,   0.47314,   0.47576,   0.47833,   0.48084,   0.48331,   0.48574,
     0.48814,   0.49051,   0.49286,   0.49518,   0.49750,   0.49981,   0.50212,
     0.50444,   0.50677,   0.50912,   0.51149,   0.51388,   0.51632,   0.51879,
     0.52130,   0.52387,   0.52650,   0.52918,   0.53194,   0.53477,   0.53767,
     0.54067,   0.54375,   0.54693,   0.55021,   0.55359,   0.55709,   0.56071,
     0.56445,   0.56833,   0.57234,   0.57649,   0.58079,   0.58524,   0.58985,
     0.59463,   0.59957,   0.60468,   0.60997,   0.61545,   0.62110,   0.62694,
     0.63297,   0.63919,   0.64560,   0.65220,   0.65899,   0.66597,   0.67313,
     0.68047,   0.68798,   0.69567,   0.70351,   0.71152,   0.71967,   0.72796,
     0.73638,   0.74492,   0.75357,   0.76231,   0.77114,   0.78004,   0.78899,
     0.79799,   0.80702,   0.81606,   0.82511,   0.83413,   0.84313,   0.85207,
     0.86095,   0.86975,   0.87844,   0.88701,   0.89544,   0.90371,   0.91179,
     0.91966,   0.92731,   0.93470,   0.94182,   0.94863,   0.95512,   0.96127,
     0.96705,   0.97243,   0.97740,   0.98194,   0.98602,   0.98962,   0.99273,
     0.99531,   0.99734,   0.99881,   0.99970,   1.00000},
     //---------  0.90 GeV
    {0.00035,   0.00141,   0.00316,   0.00557,   0.00863,   0.01231,   0.01657,
     0.02139,   0.02674,   0.03260,   0.03893,   0.04570,   0.05288,   0.06045,
     0.06837,   0.07660,   0.08513,   0.09391,   0.10292,   0.11212,   0.12149,
     0.13100,   0.14063,   0.15034,   0.16012,   0.16994,   0.17978,   0.18962,
     0.19944,   0.20922,   0.21894,   0.22859,   0.23814,   0.24758,   0.25690,
     0.26609,   0.27511,   0.28398,   0.29267,   0.30117,   0.30947,   0.31757,
     0.32546,   0.33313,   0.34057,   0.34779,   0.35477,   0.36153,   0.36806,
     0.37435,   0.38042,   0.38626,   0.39187,   0.39727,   0.40246,   0.40743,
     0.41221,   0.41679,   0.42118,   0.42538,   0.42942,   0.43328,   0.43698,
     0.44053,   0.44394,   0.44720,   0.45033,   0.45334,   0.45622,   0.45900,
     0.46167,   0.46424,   0.46671,   0.46910,   0.47141,   0.47364,   0.47580,
     0.47790,   0.47993,   0.48191,   0.48385,   0.48573,   0.48758,   0.48939,
     0.49118,   0.49294,   0.49468,   0.49640,   0.49812,   0.49983,   0.50154,
     0.50325,   0.50498,   0.50672,   0.50848,   0.51026,   0.51207,   0.51392,
     0.51581,   0.51774,   0.51972,   0.52176,   0.52386,   0.52602,   0.52825,
     0.53056,   0.53295,   0.53543,   0.53800,   0.54067,   0.54344,   0.54633,
     0.54934,   0.55247,   0.55574,   0.55915,   0.56270,   0.56641,   0.57027,
     0.57431,   0.57852,   0.58291,   0.58750,   0.59228,   0.59726,   0.60245,
     0.60785,   0.61347,   0.61932,   0.62539,   0.63169,   0.63822,   0.64498,
     0.65198,   0.65920,   0.66665,   0.67433,   0.68222,   0.69033,   0.69864,
     0.70715,   0.71585,   0.72472,   0.73376,   0.74295,   0.75227,   0.76173,
     0.77129,   0.78094,   0.79067,   0.80046,   0.81028,   0.82013,   0.82998,
     0.83980,   0.84959,   0.85931,   0.86894,   0.87846,   0.88783,   0.89704,
     0.90605,   0.91483,   0.92336,   0.93160,   0.93952,   0.94709,   0.95428,
     0.96106,   0.96739,   0.97325,   0.97860,   0.98342,   0.98769,   0.99137,
     0.99443,   0.99684,   0.99859,   0.99965,   1.00000},
     //---------  1.00 GeV
    {0.00041,   0.00164,   0.00366,   0.00645,   0.00999,   0.01423,   0.01914,
     0.02469,   0.03084,   0.03755,   0.04478,   0.05250,   0.06066,   0.06923,
     0.07815,   0.08741,   0.09694,   0.10672,   0.11670,   0.12685,   0.13714,
     0.14753,   0.15800,   0.16850,   0.17902,   0.18953,   0.20000,   0.21041,
     0.22075,   0.23098,   0.24109,   0.25107,   0.26088,   0.27053,   0.27999,
     0.28924,   0.29829,   0.30711,   0.31569,   0.32403,   0.33212,   0.33995,
     0.34752,   0.35483,   0.36187,   0.36864,   0.37515,   0.38140,   0.38738,
     0.39312,   0.39861,   0.40385,   0.40886,   0.41364,   0.41820,   0.42256,
     0.42671,   0.43066,   0.43443,   0.43803,   0.44146,   0.44473,   0.44786,
     0.45084,   0.45368,   0.45640,   0.45901,   0.46150,   0.46389,   0.46618,
     0.46838,   0.47050,   0.47253,   0.47450,   0.47639,   0.47823,   0.48000,
     0.48172,   0.48340,   0.48503,   0.48662,   0.48818,   0.48970,   0.49120,
     0.49267,   0.49413,   0.49557,   0.49700,   0.49842,   0.49984,   0.50125,
     0.50267,   0.50410,   0.50554,   0.50700,   0.50847,   0.50997,   0.51150,
     0.51305,   0.51464,   0.51627,   0.51795,   0.51967,   0.52145,   0.52328,
     0.52518,   0.52714,   0.52918,   0.53129,   0.53350,   0.53579,   0.53818,
     0.54067,   0.54328,   0.54600,   0.54885,   0.55183,   0.55495,   0.55823,
     0.56166,   0.56526,   0.56904,   0.57300,   0.57715,   0.58151,   0.58607,
     0.59086,   0.59587,   0.60112,   0.60661,   0.61235,   0.61835,   0.62460,
     0.63112,   0.63790,   0.64494,   0.65226,   0.65983,   0.66767,   0.67577,
     0.68412,   0.69271,   0.70153,   0.71059,   0.71985,   0.72932,   0.73897,
     0.74880,   0.75878,   0.76890,   0.77914,   0.78948,   0.79990,   0.81038,
     0.82089,   0.83142,   0.84193,   0.85240,   0.86280,   0.87309,   0.88325,
     0.89324,   0.90302,   0.91256,   0.92181,   0.93075,   0.93931,   0.94748,
     0.95520,   0.96244,   0.96915,   0.97530,   0.98085,   0.98576,   0.99001,
     0.99355,   0.99634,   0.99836,   0.99959,   1.00000},
     //---------  1.10 GeV
    {0.00047,   0.00187,   0.00418,   0.00737,   0.01140,   0.01623,   0.02181,
     0.02811,   0.03507,   0.04265,   0.05079,   0.05946,   0.06859,   0.07814,
     0.08806,   0.09829,   0.10878,   0.11950,   0.13038,   0.14140,   0.15250,
     0.16366,   0.17483,   0.18598,   0.19709,   0.20813,   0.21906,   0.22987,
     0.24053,   0.25103,   0.26134,   0.27145,   0.28134,   0.29100,   0.30041,
     0.30956,   0.31844,   0.32704,   0.33536,   0.34339,   0.35112,   0.35856,
     0.36569,   0.37253,   0.37908,   0.38533,   0.39130,   0.39699,   0.40241,
     0.40756,   0.41246,   0.41712,   0.42154,   0.42574,   0.42972,   0.43351,
     0.43710,   0.44050,   0.44374,   0.44682,   0.44974,   0.45253,   0.45518,
     0.45770,   0.46011,   0.46241,   0.46461,   0.46672,   0.46874,   0.47068,
     0.47254,   0.47434,   0.47607,   0.47774,   0.47936,   0.48093,   0.48246,
     0.48395,   0.48540,   0.48681,   0.48820,   0.48956,   0.49089,   0.49221,
     0.49351,   0.49479,   0.49606,   0.49733,   0.49859,   0.49984,   0.50110,
     0.50236,   0.50362,   0.50490,   0.50618,   0.50748,   0.50879,   0.51013,
     0.51149,   0.51288,   0.51429,   0.51574,   0.51722,   0.51875,   0.52032,
     0.52194,   0.52362,   0.52535,   0.52714,   0.52901,   0.53095,   0.53297,
     0.53507,   0.53728,   0.53958,   0.54199,   0.54452,   0.54717,   0.54995,
     0.55288,   0.55596,   0.55920,   0.56261,   0.56620,   0.56999,   0.57397,
     0.57818,   0.58260,   0.58726,   0.59217,   0.59733,   0.60275,   0.60845,
     0.61442,   0.62068,   0.62723,   0.63408,   0.64123,   0.64867,   0.65641,
     0.66444,   0.67277,   0.68138,   0.69027,   0.69943,   0.70884,   0.71851,
     0.72841,   0.73852,   0.74884,   0.75935,   0.77002,   0.78083,   0.79178,
     0.80282,   0.81393,   0.82509,   0.83627,   0.84743,   0.85854,   0.86956,
     0.88046,   0.89117,   0.90167,   0.91191,   0.92183,   0.93138,   0.94052,
     0.94919,   0.95734,   0.96492,   0.97188,   0.97818,   0.98377,   0.98860,
     0.99263,   0.99582,   0.99813,   0.99953,   1.00000},
     //---------  1.20 GeV
    {0.00053,   0.00211,   0.00472,   0.00832,   0.01286,   0.01829,   0.02456,
     0.03163,   0.03942,   0.04788,   0.05695,   0.06657,   0.07667,   0.08720,
     0.09809,   0.10927,   0.12069,   0.13230,   0.14403,   0.15585,   0.16769,
     0.17953,   0.19131,   0.20301,   0.21460,   0.22604,   0.23731,   0.24838,
     0.25924,   0.26986,   0.28023,   0.29033,   0.30015,   0.30968,   0.31890,
     0.32782,   0.33641,   0.34469,   0.35263,   0.36025,   0.36754,   0.37450,
     0.38114,   0.38746,   0.39347,   0.39918,   0.40459,   0.40971,   0.41456,
     0.41915,   0.42349,   0.42759,   0.43147,   0.43513,   0.43860,   0.44187,
     0.44497,   0.44791,   0.45069,   0.45332,   0.45583,   0.45821,   0.46047,
     0.46263,   0.46469,   0.46666,   0.46855,   0.47036,   0.47210,   0.47377,
     0.47538,   0.47694,   0.47845,   0.47991,   0.48133,   0.48272,   0.48407,
     0.48539,   0.48668,   0.48795,   0.48920,   0.49043,   0.49165,   0.49284,
     0.49403,   0.49521,   0.49637,   0.49754,   0.49869,   0.49985,   0.50101,
     0.50216,   0.50333,   0.50449,   0.50567,   0.50685,   0.50805,   0.50927,
     0.51049,   0.51174,   0.51301,   0.51431,   0.51563,   0.51698,   0.51836,
     0.51979,   0.52125,   0.52276,   0.52432,   0.52593,   0.52760,   0.52934,
     0.53115,   0.53303,   0.53500,   0.53707,   0.53923,   0.54149,   0.54387,
     0.54638,   0.54902,   0.55180,   0.55474,   0.55784,   0.56112,   0.56459,
     0.56825,   0.57213,   0.57624,   0.58058,   0.58518,   0.59003,   0.59516,
     0.60058,   0.60629,   0.61231,   0.61863,   0.62528,   0.63225,   0.63955,
     0.64717,   0.65512,   0.66340,   0.67201,   0.68093,   0.69016,   0.69970,
     0.70953,   0.71964,   0.73001,   0.74064,   0.75151,   0.76259,   0.77386,
     0.78531,   0.79690,   0.80861,   0.82040,   0.83224,   0.84409,   0.85591,
     0.86765,   0.87926,   0.89069,   0.90188,   0.91277,   0.92330,   0.93341,
     0.94303,   0.95210,   0.96057,   0.96836,   0.97543,   0.98170,   0.98714,
     0.99168,   0.99528,   0.99789,   0.99947,   1.00000},
  //---------  1.3 GeV
  {0.00015,   0.00134,   0.00371,   0.00720,   0.01178,   0.01737,   0.02391,
   0.03133,   0.03957,   0.04856,   0.05823,   0.06850,   0.07930,   0.09057,
   0.10223,   0.11420,   0.12643,   0.13883,   0.15137,   0.16396,   0.17656,
   0.18913,   0.20161,   0.21395,   0.22613,   0.23811,   0.24987,   0.26137,
   0.27259,   0.28351,   0.29412,   0.30440,   0.31434,   0.32392,   0.33315,
   0.34201,   0.35050,   0.35861,   0.36636,   0.37373,   0.38074,   0.38739,
   0.39369,   0.39964,   0.40526,   0.41056,   0.41555,   0.42024,   0.42465,
   0.42879,   0.43269,   0.43634,   0.43978,   0.44300,   0.44604,   0.44890,
   0.45160,   0.45414,   0.45654,   0.45882,   0.46097,   0.46302,   0.46497,
   0.46682,   0.46860,   0.47029,   0.47192,   0.47348,   0.47498,   0.47642,
   0.47782,   0.47918,   0.48049,   0.48177,   0.48301,   0.48423,   0.48542,
   0.48659,   0.48774,   0.48886,   0.48998,   0.49108,   0.49216,   0.49324,
   0.49431,   0.49537,   0.49643,   0.49748,   0.49853,   0.49957,   0.50062,
   0.50166,   0.50271,   0.50376,   0.50482,   0.50588,   0.50695,   0.50803,
   0.50911,   0.51021,   0.51133,   0.51246,   0.51360,   0.51477,   0.51596,
   0.51718,   0.51842,   0.51970,   0.52101,   0.52237,   0.52377,   0.52521,
   0.52671,   0.52827,   0.52990,   0.53159,   0.53337,   0.53522,   0.53717,
   0.53922,   0.54137,   0.54365,   0.54605,   0.54859,   0.55129,   0.55415,
   0.55719,   0.56041,   0.56385,   0.56750,   0.57139,   0.57554,   0.57995,
   0.58464,   0.58963,   0.59492,   0.60054,   0.60649,   0.61279,   0.61944,
   0.62645,   0.63383,   0.64157,   0.64969,   0.65818,   0.66703,   0.67626,
   0.68584,   0.69578,   0.70605,   0.71666,   0.72759,   0.73881,   0.75030,
   0.76205,   0.77403,   0.78621,   0.79856,   0.81104,   0.82360,   0.83621,
   0.84880,   0.86132,   0.87373,   0.88595,   0.89793,   0.90958,   0.92085,
   0.93165,   0.94192,   0.95159,   0.96058,   0.96882,   0.97624,   0.98278,
   0.98837,   0.99295,   0.99644,   0.99881,   1.00000},
  //---------  1.4 GeV
  {0.00017,   0.00149,   0.00412,   0.00800,   0.01307,   0.01926,   0.02649,
   0.03468,   0.04375,   0.05362,   0.06420,   0.07541,   0.08717,   0.09938,
   0.11197,   0.12485,   0.13795,   0.15118,   0.16447,   0.17777,   0.19101,
   0.20414,   0.21710,   0.22986,   0.24237,   0.25460,   0.26653,   0.27812,
   0.28937,   0.30024,   0.31074,   0.32085,   0.33055,   0.33986,   0.34876,
   0.35725,   0.36533,   0.37302,   0.38030,   0.38719,   0.39371,   0.39984,
   0.40562,   0.41104,   0.41614,   0.42091,   0.42538,   0.42956,   0.43347,
   0.43712,   0.44054,   0.44374,   0.44674,   0.44954,   0.45218,   0.45465,
   0.45698,   0.45918,   0.46125,   0.46322,   0.46508,   0.46685,   0.46854,
   0.47015,   0.47169,   0.47316,   0.47458,   0.47595,   0.47727,   0.47854,
   0.47978,   0.48098,   0.48214,   0.48329,   0.48440,   0.48550,   0.48657,
   0.48763,   0.48867,   0.48970,   0.49072,   0.49173,   0.49273,   0.49373,
   0.49472,   0.49570,   0.49668,   0.49766,   0.49864,   0.49962,   0.50059,
   0.50157,   0.50254,   0.50352,   0.50451,   0.50549,   0.50648,   0.50748,
   0.50848,   0.50949,   0.51051,   0.51154,   0.51258,   0.51364,   0.51471,
   0.51581,   0.51692,   0.51806,   0.51923,   0.52043,   0.52167,   0.52294,
   0.52426,   0.52562,   0.52704,   0.52852,   0.53006,   0.53167,   0.53336,
   0.53513,   0.53699,   0.53895,   0.54103,   0.54322,   0.54555,   0.54803,
   0.55066,   0.55347,   0.55646,   0.55966,   0.56308,   0.56674,   0.57065,
   0.57483,   0.57929,   0.58407,   0.58916,   0.59459,   0.60036,   0.60650,
   0.61301,   0.61990,   0.62719,   0.63487,   0.64295,   0.65144,   0.66034,
   0.66965,   0.67935,   0.68946,   0.69995,   0.71083,   0.72207,   0.73367,
   0.74559,   0.75782,   0.77033,   0.78309,   0.79604,   0.80917,   0.82240,
   0.83569,   0.84899,   0.86222,   0.87531,   0.88820,   0.90078,   0.91300,
   0.92476,   0.93597,   0.94655,   0.95642,   0.96549,   0.97368,   0.98091,
   0.98709,   0.99216,   0.99604,   0.99867,   1.00000},
  //---------  1.5 GeV
  {0.00018,   0.00164,   0.00453,   0.00879,   0.01436,   0.02113,   0.02904,
   0.03798,   0.04787,   0.05860,   0.07008,   0.08221,   0.09489,   0.10802,
   0.12151,   0.13525,   0.14917,   0.16316,   0.17717,   0.19110,   0.20490,
   0.21851,   0.23188,   0.24496,   0.25772,   0.27012,   0.28213,   0.29374,
   0.30493,   0.31568,   0.32599,   0.33586,   0.34527,   0.35424,   0.36276,
   0.37084,   0.37849,   0.38570,   0.39251,   0.39890,   0.40491,   0.41053,
   0.41580,   0.42071,   0.42530,   0.42958,   0.43356,   0.43727,   0.44073,
   0.44394,   0.44694,   0.44974,   0.45235,   0.45479,   0.45708,   0.45923,
   0.46126,   0.46317,   0.46498,   0.46669,   0.46832,   0.46987,   0.47135,
   0.47277,   0.47413,   0.47544,   0.47670,   0.47792,   0.47910,   0.48024,
   0.48135,   0.48243,   0.48349,   0.48452,   0.48554,   0.48654,   0.48752,
   0.48849,   0.48945,   0.49040,   0.49134,   0.49228,   0.49321,   0.49414,
   0.49506,   0.49598,   0.49690,   0.49781,   0.49873,   0.49964,   0.50055,
   0.50147,   0.50238,   0.50330,   0.50421,   0.50513,   0.50606,   0.50698,
   0.50791,   0.50885,   0.50979,   0.51074,   0.51170,   0.51267,   0.51365,
   0.51465,   0.51567,   0.51670,   0.51776,   0.51884,   0.51995,   0.52110,
   0.52228,   0.52349,   0.52475,   0.52606,   0.52742,   0.52884,   0.53032,
   0.53187,   0.53350,   0.53522,   0.53702,   0.53893,   0.54096,   0.54311,
   0.54540,   0.54784,   0.55045,   0.55325,   0.55625,   0.55947,   0.56292,
   0.56663,   0.57061,   0.57489,   0.57948,   0.58439,   0.58966,   0.59528,
   0.60129,   0.60769,   0.61449,   0.62171,   0.62935,   0.63743,   0.64595,
   0.65492,   0.66433,   0.67420,   0.68451,   0.69526,   0.70645,   0.71805,
   0.73007,   0.74247,   0.75522,   0.76830,   0.78167,   0.79528,   0.80908,
   0.82302,   0.83702,   0.85102,   0.86493,   0.87868,   0.89216,   0.90529,
   0.91798,   0.93011,   0.94159,   0.95232,   0.96220,   0.97114,   0.97905,
   0.98583,   0.99139,   0.99565,   0.99854,   1.00000},
  //---------  1.6 GeV
  {0.00020,   0.00179,   0.00493,   0.00957,   0.01561,   0.02296,   0.03153,
   0.04121,   0.05189,   0.06345,   0.07580,   0.08882,   0.10238,   0.11639,
   0.13073,   0.14529,   0.15997,   0.17468,   0.18933,   0.20385,   0.21816,
   0.23219,   0.24591,   0.25925,   0.27218,   0.28468,   0.29672,   0.30828,
   0.31935,   0.32992,   0.33999,   0.34957,   0.35865,   0.36724,   0.37535,
   0.38300,   0.39018,   0.39693,   0.40324,   0.40914,   0.41465,   0.41978,
   0.42455,   0.42899,   0.43310,   0.43692,   0.44046,   0.44374,   0.44679,
   0.44961,   0.45224,   0.45469,   0.45697,   0.45911,   0.46111,   0.46299,
   0.46476,   0.46644,   0.46803,   0.46954,   0.47098,   0.47236,   0.47368,
   0.47495,   0.47617,   0.47735,   0.47849,   0.47959,   0.48066,   0.48171,
   0.48272,   0.48371,   0.48468,   0.48563,   0.48657,   0.48749,   0.48840,
   0.48930,   0.49019,   0.49107,   0.49195,   0.49282,   0.49368,   0.49455,
   0.49541,   0.49626,   0.49712,   0.49797,   0.49883,   0.49968,   0.50054,
   0.50139,   0.50224,   0.50310,   0.50395,   0.50481,   0.50567,   0.50654,
   0.50740,   0.50827,   0.50915,   0.51003,   0.51092,   0.51182,   0.51273,
   0.51365,   0.51458,   0.51554,   0.51651,   0.51750,   0.51851,   0.51955,
   0.52063,   0.52173,   0.52287,   0.52405,   0.52527,   0.52654,   0.52786,
   0.52924,   0.53068,   0.53219,   0.53378,   0.53546,   0.53723,   0.53911,
   0.54111,   0.54325,   0.54553,   0.54797,   0.55060,   0.55343,   0.55647,
   0.55975,   0.56329,   0.56711,   0.57123,   0.57566,   0.58043,   0.58556,
   0.59107,   0.59697,   0.60328,   0.61003,   0.61721,   0.62485,   0.63297,
   0.64156,   0.65064,   0.66021,   0.67029,   0.68086,   0.69193,   0.70349,
   0.71553,   0.72802,   0.74096,   0.75430,   0.76801,   0.78205,   0.79636,
   0.81087,   0.82552,   0.84023,   0.85492,   0.86948,   0.88382,   0.89782,
   0.91139,   0.92440,   0.93675,   0.94831,   0.95899,   0.96867,   0.97724,
   0.98459,   0.99063,   0.99527,   0.99841,   1.00000},
  //---------  1.7 GeV
  {0.00022,   0.00193,   0.00532,   0.01032,   0.01683,   0.02474,   0.03395,
   0.04433,   0.05578,   0.06815,   0.08133,   0.09520,   0.10962,   0.12446,
   0.13961,   0.15494,   0.17034,   0.18572,   0.20096,   0.21600,   0.23076,
   0.24517,   0.25917,   0.27272,   0.28578,   0.29832,   0.31033,   0.32180,
   0.33271,   0.34306,   0.35286,   0.36212,   0.37084,   0.37904,   0.38673,
   0.39393,   0.40066,   0.40693,   0.41276,   0.41818,   0.42321,   0.42787,
   0.43218,   0.43617,   0.43985,   0.44324,   0.44638,   0.44928,   0.45196,
   0.45445,   0.45675,   0.45889,   0.46089,   0.46276,   0.46452,   0.46617,
   0.46773,   0.46922,   0.47063,   0.47198,   0.47327,   0.47451,   0.47570,
   0.47685,   0.47796,   0.47904,   0.48008,   0.48109,   0.48208,   0.48304,
   0.48398,   0.48490,   0.48580,   0.48668,   0.48755,   0.48840,   0.48925,
   0.49008,   0.49091,   0.49173,   0.49254,   0.49335,   0.49416,   0.49496,
   0.49576,   0.49656,   0.49735,   0.49815,   0.49894,   0.49973,   0.50052,
   0.50131,   0.50211,   0.50290,   0.50370,   0.50449,   0.50529,   0.50609,
   0.50690,   0.50771,   0.50852,   0.50934,   0.51017,   0.51100,   0.51185,
   0.51270,   0.51357,   0.51446,   0.51536,   0.51627,   0.51721,   0.51817,
   0.51916,   0.52017,   0.52122,   0.52229,   0.52340,   0.52455,   0.52575,
   0.52698,   0.52827,   0.52962,   0.53103,   0.53252,   0.53408,   0.53573,
   0.53749,   0.53936,   0.54136,   0.54350,   0.54581,   0.54829,   0.55097,
   0.55387,   0.55700,   0.56040,   0.56408,   0.56806,   0.57237,   0.57703,
   0.58206,   0.58748,   0.59332,   0.59959,   0.60631,   0.61351,   0.62120,
   0.62940,   0.63812,   0.64737,   0.65717,   0.66753,   0.67844,   0.68990,
   0.70191,   0.71446,   0.72751,   0.74106,   0.75506,   0.76947,   0.78423,
   0.79927,   0.81452,   0.82989,   0.84529,   0.86062,   0.87577,   0.89060,
   0.90502,   0.91888,   0.93207,   0.94444,   0.95588,   0.96627,   0.97548,
   0.98339,   0.98990,   0.99489,   0.99828,   1.00000},
  //---------  1.8 GeV
  {0.00023,   0.00207,   0.00570,   0.01104,   0.01800,   0.02645,   0.03628,
   0.04735,   0.05953,   0.07268,   0.08666,   0.10134,   0.11657,   0.13221,
   0.14812,   0.16418,   0.18027,   0.19626,   0.21207,   0.22759,   0.24274,
   0.25747,   0.27172,   0.28543,   0.29858,   0.31114,   0.32309,   0.33443,
   0.34515,   0.35526,   0.36477,   0.37369,   0.38204,   0.38984,   0.39710,
   0.40386,   0.41014,   0.41595,   0.42133,   0.42629,   0.43087,   0.43509,
   0.43897,   0.44254,   0.44582,   0.44884,   0.45161,   0.45417,   0.45653,
   0.45871,   0.46073,   0.46261,   0.46436,   0.46600,   0.46755,   0.46901,
   0.47039,   0.47171,   0.47297,   0.47418,   0.47534,   0.47646,   0.47755,
   0.47860,   0.47961,   0.48060,   0.48156,   0.48250,   0.48341,   0.48431,
   0.48518,   0.48603,   0.48687,   0.48769,   0.48850,   0.48929,   0.49008,
   0.49086,   0.49162,   0.49238,   0.49314,   0.49389,   0.49463,   0.49537,
   0.49611,   0.49684,   0.49757,   0.49830,   0.49903,   0.49976,   0.50049,
   0.50122,   0.50195,   0.50268,   0.50341,   0.50414,   0.50488,   0.50562,
   0.50637,   0.50711,   0.50787,   0.50863,   0.50940,   0.51017,   0.51096,
   0.51175,   0.51256,   0.51338,   0.51422,   0.51507,   0.51595,   0.51684,
   0.51775,   0.51869,   0.51965,   0.52064,   0.52166,   0.52270,   0.52379,
   0.52491,   0.52607,   0.52728,   0.52854,   0.52986,   0.53125,   0.53270,
   0.53425,   0.53589,   0.53764,   0.53952,   0.54154,   0.54372,   0.54608,
   0.54864,   0.55141,   0.55443,   0.55771,   0.56128,   0.56516,   0.56937,
   0.57395,   0.57892,   0.58429,   0.59011,   0.59638,   0.60314,   0.61040,
   0.61820,   0.62655,   0.63547,   0.64498,   0.65509,   0.66581,   0.67715,
   0.68910,   0.70165,   0.71480,   0.72852,   0.74276,   0.75749,   0.77265,
   0.78817,   0.80397,   0.81997,   0.83605,   0.85211,   0.86803,   0.88367,
   0.89889,   0.91357,   0.92756,   0.94071,   0.95289,   0.96395,   0.97378,
   0.98223,   0.98919,   0.99453,   0.99816,   1.00000},
  //---------  1.9 GeV
  {0.00025,   0.00220,   0.00606,   0.01174,   0.01913,   0.02810,   0.03852,
   0.05025,   0.06314,   0.07703,   0.09179,   0.10724,   0.12324,   0.13964,
   0.15628,   0.17304,   0.18976,   0.20634,   0.22266,   0.23863,   0.25416,
   0.26918,   0.28364,   0.29749,   0.31069,   0.32324,   0.33511,   0.34630,
   0.35682,   0.36668,   0.37589,   0.38447,   0.39245,   0.39985,   0.40671,
   0.41304,   0.41888,   0.42426,   0.42920,   0.43374,   0.43790,   0.44171,
   0.44519,   0.44839,   0.45131,   0.45398,   0.45643,   0.45868,   0.46075,
   0.46266,   0.46443,   0.46608,   0.46762,   0.46906,   0.47042,   0.47171,
   0.47294,   0.47411,   0.47524,   0.47632,   0.47737,   0.47839,   0.47937,
   0.48033,   0.48126,   0.48217,   0.48306,   0.48392,   0.48476,   0.48559,
   0.48640,   0.48719,   0.48797,   0.48873,   0.48948,   0.49021,   0.49094,
   0.49166,   0.49236,   0.49306,   0.49376,   0.49445,   0.49513,   0.49581,
   0.49648,   0.49715,   0.49782,   0.49848,   0.49915,   0.49981,   0.50047,
   0.50113,   0.50180,   0.50246,   0.50313,   0.50380,   0.50448,   0.50515,
   0.50584,   0.50652,   0.50722,   0.50792,   0.50862,   0.50934,   0.51007,
   0.51080,   0.51155,   0.51232,   0.51309,   0.51388,   0.51469,   0.51552,
   0.51636,   0.51723,   0.51811,   0.51902,   0.51995,   0.52091,   0.52189,
   0.52291,   0.52396,   0.52504,   0.52617,   0.52734,   0.52857,   0.52986,
   0.53122,   0.53266,   0.53420,   0.53585,   0.53762,   0.53953,   0.54160,
   0.54385,   0.54630,   0.54897,   0.55189,   0.55508,   0.55857,   0.56238,
   0.56654,   0.57108,   0.57602,   0.58140,   0.58724,   0.59357,   0.60042,
   0.60783,   0.61581,   0.62439,   0.63360,   0.64345,   0.65397,   0.66516,
   0.67703,   0.68957,   0.70278,   0.71663,   0.73109,   0.74610,   0.76163,
   0.77760,   0.79392,   0.81049,   0.82721,   0.84396,   0.86061,   0.87700,
   0.89301,   0.90846,   0.92322,   0.93711,   0.95000,   0.96172,   0.97214,
   0.98112,   0.98851,   0.99419,   0.99805,   1.00000},
  //---------  2.0 GeV
  {0.00026,   0.00233,   0.00641,   0.01241,   0.02022,   0.02969,   0.04068,
   0.05304,   0.06661,   0.08122,   0.09672,   0.11292,   0.12968,   0.14681,
   0.16415,   0.18156,   0.19889,   0.21601,   0.23282,   0.24920,   0.26507,
   0.28035,   0.29500,   0.30896,   0.32220,   0.33472,   0.34649,   0.35753,
   0.36784,   0.37744,   0.38635,   0.39460,   0.40222,   0.40924,   0.41570,
   0.42162,   0.42705,   0.43201,   0.43655,   0.44069,   0.44446,   0.44789,
   0.45102,   0.45387,   0.45646,   0.45883,   0.46099,   0.46297,   0.46478,
   0.46646,   0.46800,   0.46944,   0.47079,   0.47205,   0.47325,   0.47439,
   0.47547,   0.47651,   0.47751,   0.47848,   0.47942,   0.48034,   0.48123,
   0.48210,   0.48294,   0.48377,   0.48458,   0.48537,   0.48614,   0.48690,
   0.48764,   0.48837,   0.48908,   0.48978,   0.49047,   0.49114,   0.49181,
   0.49246,   0.49311,   0.49375,   0.49438,   0.49501,   0.49562,   0.49624,
   0.49685,   0.49745,   0.49806,   0.49866,   0.49925,   0.49985,   0.50045,
   0.50104,   0.50164,   0.50224,   0.50284,   0.50345,   0.50406,   0.50467,
   0.50529,   0.50592,   0.50655,   0.50719,   0.50783,   0.50849,   0.50915,
   0.50983,   0.51052,   0.51122,   0.51193,   0.51266,   0.51340,   0.51415,
   0.51493,   0.51572,   0.51653,   0.51735,   0.51820,   0.51907,   0.51996,
   0.52087,   0.52182,   0.52278,   0.52379,   0.52483,   0.52591,   0.52705,
   0.52824,   0.52951,   0.53085,   0.53229,   0.53384,   0.53551,   0.53733,
   0.53931,   0.54147,   0.54383,   0.54643,   0.54927,   0.55240,   0.55584,
   0.55961,   0.56375,   0.56828,   0.57325,   0.57867,   0.58460,   0.59105,
   0.59807,   0.60569,   0.61394,   0.62285,   0.63245,   0.64276,   0.65379,
   0.66556,   0.67807,   0.69132,   0.70528,   0.71992,   0.73520,   0.75107,
   0.76745,   0.78425,   0.80138,   0.81871,   0.83611,   0.85346,   0.87059,
   0.88734,   0.90355,   0.91904,   0.93366,   0.94723,   0.95958,   0.97057,
   0.98004,   0.98785,   0.99385,   0.99793,   1.00000},
  //---------  2.2 GeV
  {0.00029,   0.00256,   0.00706,   0.01367,   0.02225,   0.03265,   0.04472,
   0.05826,   0.07311,   0.08907,   0.10596,   0.12357,   0.14172,   0.16020,
   0.17885,   0.19749,   0.21595,   0.23409,   0.25179,   0.26893,   0.28541,
   0.30116,   0.31613,   0.33026,   0.34354,   0.35596,   0.36752,   0.37823,
   0.38811,   0.39720,   0.40553,   0.41314,   0.42007,   0.42637,   0.43208,
   0.43725,   0.44192,   0.44614,   0.44994,   0.45337,   0.45645,   0.45923,
   0.46173,   0.46399,   0.46602,   0.46787,   0.46954,   0.47106,   0.47245,
   0.47373,   0.47491,   0.47600,   0.47703,   0.47799,   0.47890,   0.47977,
   0.48061,   0.48141,   0.48219,   0.48295,   0.48368,   0.48440,   0.48511,
   0.48579,   0.48647,   0.48713,   0.48778,   0.48841,   0.48903,   0.48964,
   0.49024,   0.49082,   0.49139,   0.49195,   0.49251,   0.49305,   0.49358,
   0.49410,   0.49462,   0.49513,   0.49563,   0.49612,   0.49661,   0.49710,
   0.49758,   0.49806,   0.49853,   0.49900,   0.49947,   0.49994,   0.50041,
   0.50088,   0.50135,   0.50182,   0.50229,   0.50277,   0.50325,   0.50373,
   0.50422,   0.50472,   0.50522,   0.50573,   0.50624,   0.50677,   0.50730,
   0.50784,   0.50839,   0.50895,   0.50953,   0.51011,   0.51071,   0.51131,
   0.51194,   0.51257,   0.51322,   0.51388,   0.51455,   0.51524,   0.51594,
   0.51666,   0.51740,   0.51816,   0.51894,   0.51974,   0.52057,   0.52144,
   0.52236,   0.52332,   0.52434,   0.52544,   0.52662,   0.52789,   0.52928,
   0.53081,   0.53248,   0.53432,   0.53636,   0.53861,   0.54112,   0.54389,
   0.54698,   0.55040,   0.55421,   0.55842,   0.56309,   0.56826,   0.57398,
   0.58027,   0.58720,   0.59481,   0.60314,   0.61223,   0.62211,   0.63282,
   0.64438,   0.65679,   0.67007,   0.68421,   0.69917,   0.71493,   0.73140,
   0.74853,   0.76622,   0.78436,   0.80282,   0.82145,   0.84010,   0.85858,
   0.87673,   0.89434,   0.91122,   0.92718,   0.94203,   0.95557,   0.96763,
   0.97804,   0.98662,   0.99323,   0.99772,   1.00000},
  //---------  2.4 GeV
  {0.00031,   0.00277,   0.00763,   0.01476,   0.02403,   0.03525,   0.04826,
   0.06285,   0.07882,   0.09597,   0.11407,   0.13291,   0.15228,   0.17196,
   0.19174,   0.21143,   0.23086,   0.24987,   0.26831,   0.28606,   0.30304,
   0.31915,   0.33434,   0.34858,   0.36184,   0.37412,   0.38542,   0.39579,
   0.40524,   0.41382,   0.42159,   0.42859,   0.43487,   0.44051,   0.44554,
   0.45004,   0.45404,   0.45761,   0.46078,   0.46361,   0.46612,   0.46836,
   0.47036,   0.47215,   0.47376,   0.47521,   0.47651,   0.47770,   0.47878,
   0.47978,   0.48070,   0.48156,   0.48236,   0.48311,   0.48383,   0.48451,
   0.48517,   0.48581,   0.48642,   0.48702,   0.48760,   0.48816,   0.48871,
   0.48925,   0.48978,   0.49029,   0.49079,   0.49128,   0.49176,   0.49223,
   0.49268,   0.49313,   0.49356,   0.49399,   0.49440,   0.49481,   0.49521,
   0.49560,   0.49599,   0.49637,   0.49675,   0.49712,   0.49749,   0.49785,
   0.49821,   0.49857,   0.49893,   0.49928,   0.49964,   0.49999,   0.50034,
   0.50070,   0.50105,   0.50141,   0.50176,   0.50212,   0.50248,   0.50285,
   0.50321,   0.50359,   0.50396,   0.50434,   0.50473,   0.50512,   0.50552,
   0.50593,   0.50635,   0.50677,   0.50721,   0.50765,   0.50811,   0.50857,
   0.50905,   0.50954,   0.51004,   0.51056,   0.51108,   0.51162,   0.51217,
   0.51274,   0.51332,   0.51391,   0.51453,   0.51516,   0.51582,   0.51650,
   0.51722,   0.51798,   0.51878,   0.51963,   0.52055,   0.52155,   0.52263,
   0.52382,   0.52513,   0.52657,   0.52818,   0.52997,   0.53197,   0.53421,
   0.53673,   0.53955,   0.54272,   0.54629,   0.55029,   0.55479,   0.55982,
   0.56546,   0.57174,   0.57874,   0.58650,   0.59509,   0.60454,   0.61490,
   0.62621,   0.63848,   0.65174,   0.66598,   0.68116,   0.69727,   0.71425,
   0.73200,   0.75044,   0.76945,   0.78888,   0.80857,   0.82835,   0.84803,
   0.86740,   0.88624,   0.90434,   0.92149,   0.93746,   0.95205,   0.96506,
   0.97628,   0.98555,   0.99268,   0.99754,   1.00000},
  //---------  2.6 GeV
  {0.00033,   0.00293,   0.00806,   0.01561,   0.02540,   0.03726,   0.05100,
   0.06641,   0.08326,   0.10133,   0.12039,   0.14019,   0.16051,   0.18110,
   0.20175,   0.22224,   0.24239,   0.26203,   0.28100,   0.29919,   0.31647,
   0.33279,   0.34807,   0.36229,   0.37543,   0.38749,   0.39849,   0.40848,
   0.41749,   0.42558,   0.43281,   0.43924,   0.44494,   0.44999,   0.45443,
   0.45834,   0.46178,   0.46481,   0.46748,   0.46982,   0.47190,   0.47374,
   0.47538,   0.47685,   0.47817,   0.47936,   0.48045,   0.48145,   0.48237,
   0.48322,   0.48402,   0.48477,   0.48548,   0.48616,   0.48681,   0.48743,
   0.48802,   0.48860,   0.48916,   0.48969,   0.49021,   0.49072,   0.49120,
   0.49167,   0.49213,   0.49257,   0.49299,   0.49340,   0.49379,   0.49417,
   0.49454,   0.49489,   0.49523,   0.49556,   0.49588,   0.49619,   0.49649,
   0.49678,   0.49707,   0.49736,   0.49764,   0.49791,   0.49818,   0.49845,
   0.49872,   0.49899,   0.49925,   0.49952,   0.49978,   0.50005,   0.50031,
   0.50058,   0.50084,   0.50111,   0.50137,   0.50164,   0.50191,   0.50218,
   0.50245,   0.50273,   0.50300,   0.50329,   0.50358,   0.50387,   0.50417,
   0.50448,   0.50480,   0.50513,   0.50547,   0.50582,   0.50619,   0.50657,
   0.50696,   0.50737,   0.50779,   0.50823,   0.50869,   0.50916,   0.50964,
   0.51015,   0.51067,   0.51120,   0.51176,   0.51234,   0.51293,   0.51355,
   0.51420,   0.51488,   0.51559,   0.51634,   0.51714,   0.51799,   0.51891,
   0.51991,   0.52100,   0.52219,   0.52351,   0.52498,   0.52662,   0.52846,
   0.53053,   0.53288,   0.53554,   0.53857,   0.54201,   0.54592,   0.55037,
   0.55541,   0.56111,   0.56754,   0.57477,   0.58286,   0.59187,   0.60185,
   0.61286,   0.62492,   0.63805,   0.65227,   0.66755,   0.68386,   0.70115,
   0.71933,   0.73830,   0.75794,   0.77809,   0.79859,   0.81924,   0.83983,
   0.86014,   0.87994,   0.89900,   0.91707,   0.93392,   0.94933,   0.96306,
   0.97493,   0.98472,   0.99226,   0.99740,   1.00000},
  //---------  2.8 GeV
  {0.00034,   0.00303,   0.00833,   0.01613,   0.02625,   0.03851,   0.05271,
   0.06863,   0.08604,   0.10471,   0.12437,   0.14478,   0.16569,   0.18686,
   0.20804,   0.22903,   0.24961,   0.26960,   0.28886,   0.30726,   0.32467,
   0.34103,   0.35628,   0.37040,   0.38336,   0.39518,   0.40588,   0.41552,
   0.42413,   0.43179,   0.43857,   0.44454,   0.44977,   0.45435,   0.45834,
   0.46181,   0.46484,   0.46748,   0.46978,   0.47181,   0.47360,   0.47519,
   0.47662,   0.47791,   0.47908,   0.48016,   0.48117,   0.48211,   0.48299,
   0.48383,   0.48463,   0.48540,   0.48613,   0.48684,   0.48753,   0.48819,
   0.48883,   0.48944,   0.49004,   0.49061,   0.49117,   0.49170,   0.49221,
   0.49269,   0.49316,   0.49361,   0.49403,   0.49443,   0.49481,   0.49518,
   0.49552,   0.49584,   0.49615,   0.49644,   0.49672,   0.49698,   0.49724,
   0.49748,   0.49772,   0.49795,   0.49817,   0.49839,   0.49861,   0.49882,
   0.49903,   0.49924,   0.49945,   0.49966,   0.49987,   0.50008,   0.50029,
   0.50049,   0.50070,   0.50091,   0.50112,   0.50133,   0.50154,   0.50176,
   0.50197,   0.50219,   0.50241,   0.50264,   0.50288,   0.50313,   0.50338,
   0.50364,   0.50392,   0.50421,   0.50452,   0.50485,   0.50519,   0.50555,
   0.50593,   0.50633,   0.50676,   0.50720,   0.50767,   0.50816,   0.50867,
   0.50920,   0.50975,   0.51032,   0.51092,   0.51154,   0.51217,   0.51283,
   0.51352,   0.51423,   0.51496,   0.51573,   0.51653,   0.51737,   0.51826,
   0.51920,   0.52020,   0.52128,   0.52246,   0.52375,   0.52517,   0.52676,
   0.52855,   0.53058,   0.53289,   0.53552,   0.53855,   0.54202,   0.54601,
   0.55058,   0.55582,   0.56178,   0.56856,   0.57622,   0.58484,   0.59447,
   0.60517,   0.61699,   0.62995,   0.64406,   0.65931,   0.67567,   0.69308,
   0.71147,   0.73073,   0.75073,   0.77131,   0.79230,   0.81348,   0.83465,
   0.85556,   0.87597,   0.89563,   0.91430,   0.93171,   0.94763,   0.96183,
   0.97409,   0.98421,   0.99201,   0.99731,   1.00000},
  //---------  3.0 GeV
  {0.00034,   0.00306,   0.00843,   0.01631,   0.02656,   0.03898,   0.05337,
   0.06951,   0.08717,   0.10608,   0.12601,   0.14669,   0.16785,   0.18926,
   0.21066,   0.23183,   0.25256,   0.27267,   0.29199,   0.31041,   0.32780,
   0.34409,   0.35923,   0.37318,   0.38595,   0.39753,   0.40798,   0.41733,
   0.42564,   0.43299,   0.43945,   0.44510,   0.45003,   0.45430,   0.45801,
   0.46122,   0.46401,   0.46643,   0.46856,   0.47043,   0.47209,   0.47358,
   0.47494,   0.47618,   0.47734,   0.47842,   0.47945,   0.48043,   0.48137,
   0.48227,   0.48315,   0.48400,   0.48483,   0.48563,   0.48641,   0.48717,
   0.48791,   0.48862,   0.48930,   0.48997,   0.49061,   0.49122,   0.49181,
   0.49237,   0.49290,   0.49341,   0.49389,   0.49435,   0.49477,   0.49518,
   0.49556,   0.49591,   0.49625,   0.49656,   0.49686,   0.49713,   0.49740,
   0.49764,   0.49788,   0.49811,   0.49832,   0.49854,   0.49874,   0.49894,
   0.49914,   0.49933,   0.49953,   0.49972,   0.49991,   0.50010,   0.50029,
   0.50048,   0.50067,   0.50086,   0.50106,   0.50125,   0.50145,   0.50165,
   0.50186,   0.50207,   0.50229,   0.50251,   0.50275,   0.50300,   0.50326,
   0.50354,   0.50383,   0.50414,   0.50448,   0.50483,   0.50521,   0.50562,
   0.50605,   0.50650,   0.50698,   0.50749,   0.50802,   0.50858,   0.50917,
   0.50978,   0.51042,   0.51109,   0.51177,   0.51249,   0.51322,   0.51398,
   0.51476,   0.51556,   0.51639,   0.51724,   0.51812,   0.51902,   0.51996,
   0.52094,   0.52197,   0.52305,   0.52421,   0.52545,   0.52681,   0.52830,
   0.52996,   0.53183,   0.53396,   0.53638,   0.53917,   0.54238,   0.54609,
   0.55036,   0.55528,   0.56093,   0.56739,   0.57474,   0.58306,   0.59240,
   0.60285,   0.61443,   0.62720,   0.64115,   0.65628,   0.67257,   0.68996,
   0.70837,   0.72769,   0.74780,   0.76852,   0.78969,   0.81109,   0.83250,
   0.85366,   0.87434,   0.89426,   0.91318,   0.93083,   0.94697,   0.96136,
   0.97378,   0.98403,   0.99191,   0.99728,   1.00000},
  //---------  3.4 GeV
  {0.00032,   0.00286,   0.00789,   0.01528,   0.02491,   0.03660,   0.05017,
   0.06540,   0.08209,   0.09999,   0.11884,   0.13841,   0.15844,   0.17869,
   0.19893,   0.21893,   0.23851,   0.25748,   0.27569,   0.29302,   0.30936,
   0.32465,   0.33885,   0.35192,   0.36386,   0.37470,   0.38447,   0.39322,
   0.40101,   0.40792,   0.41402,   0.41939,   0.42412,   0.42828,   0.43194,
   0.43518,   0.43807,   0.44066,   0.44302,   0.44517,   0.44717,   0.44904,
   0.45082,   0.45252,   0.45417,   0.45576,   0.45732,   0.45885,   0.46035,
   0.46183,   0.46328,   0.46472,   0.46613,   0.46752,   0.46889,   0.47024,
   0.47156,   0.47285,   0.47413,   0.47537,   0.47660,   0.47779,   0.47896,
   0.48010,   0.48121,   0.48228,   0.48333,   0.48435,   0.48533,   0.48628,
   0.48720,   0.48809,   0.48894,   0.48976,   0.49055,   0.49131,   0.49204,
   0.49275,   0.49343,   0.49409,   0.49473,   0.49535,   0.49595,   0.49654,
   0.49712,   0.49769,   0.49825,   0.49880,   0.49935,   0.49990,   0.50045,
   0.50100,   0.50155,   0.50210,   0.50266,   0.50323,   0.50381,   0.50440,
   0.50500,   0.50562,   0.50626,   0.50692,   0.50760,   0.50831,   0.50904,
   0.50980,   0.51059,   0.51141,   0.51226,   0.51315,   0.51407,   0.51502,
   0.51600,   0.51702,   0.51807,   0.51915,   0.52026,   0.52139,   0.52256,
   0.52376,   0.52498,   0.52622,   0.52750,   0.52879,   0.53012,   0.53146,
   0.53283,   0.53422,   0.53563,   0.53707,   0.53852,   0.54000,   0.54150,
   0.54303,   0.54459,   0.54619,   0.54783,   0.54953,   0.55131,   0.55318,
   0.55518,   0.55733,   0.55968,   0.56228,   0.56516,   0.56841,   0.57207,
   0.57623,   0.58095,   0.58632,   0.59242,   0.59933,   0.60712,   0.61587,
   0.62564,   0.63648,   0.64842,   0.66149,   0.67569,   0.69098,   0.70732,
   0.72465,   0.74286,   0.76183,   0.78140,   0.80140,   0.82163,   0.84188,
   0.86191,   0.88148,   0.90034,   0.91823,   0.93492,   0.95016,   0.96372,
   0.97541,   0.98504,   0.99243,   0.99746,   1.00000},
  //---------  3.8 GeV
  {0.00028,   0.00255,   0.00702,   0.01360,   0.02217,   0.03257,   0.04464,
   0.05819,   0.07303,   0.08892,   0.10565,   0.12298,   0.14070,   0.15857,
   0.17639,   0.19396,   0.21111,   0.22768,   0.24354,   0.25858,   0.27272,
   0.28590,   0.29809,   0.30927,   0.31945,   0.32865,   0.33692,   0.34432,
   0.35090,   0.35674,   0.36192,   0.36650,   0.37057,   0.37420,   0.37746,
   0.38041,   0.38312,   0.38564,   0.38801,   0.39028,   0.39246,   0.39460,
   0.39671,   0.39880,   0.40089,   0.40298,   0.40507,   0.40718,   0.40929,
   0.41141,   0.41355,   0.41569,   0.41783,   0.41998,   0.42213,   0.42429,
   0.42644,   0.42860,   0.43077,   0.43293,   0.43509,   0.43726,   0.43943,
   0.44160,   0.44377,   0.44594,   0.44811,   0.45028,   0.45245,   0.45462,
   0.45679,   0.45895,   0.46112,   0.46329,   0.46547,   0.46764,   0.46983,
   0.47201,   0.47421,   0.47642,   0.47863,   0.48086,   0.48310,   0.48534,
   0.48760,   0.48987,   0.49215,   0.49444,   0.49673,   0.49902,   0.50132,
   0.50361,   0.50590,   0.50819,   0.51047,   0.51274,   0.51499,   0.51724,
   0.51948,   0.52171,   0.52392,   0.52613,   0.52832,   0.53051,   0.53270,
   0.53487,   0.53705,   0.53922,   0.54139,   0.54355,   0.54572,   0.54789,
   0.55006,   0.55223,   0.55440,   0.55657,   0.55874,   0.56091,   0.56308,
   0.56525,   0.56741,   0.56957,   0.57174,   0.57390,   0.57605,   0.57821,
   0.58036,   0.58251,   0.58465,   0.58679,   0.58893,   0.59105,   0.59316,
   0.59527,   0.59736,   0.59945,   0.60154,   0.60363,   0.60574,   0.60787,
   0.61006,   0.61233,   0.61470,   0.61722,   0.61993,   0.62288,   0.62614,
   0.62977,   0.63384,   0.63842,   0.64359,   0.64943,   0.65601,   0.66341,
   0.67168,   0.68088,   0.69106,   0.70223,   0.71442,   0.72759,   0.74173,
   0.75677,   0.77262,   0.78919,   0.80634,   0.82391,   0.84172,   0.85959,
   0.87730,   0.89464,   0.91137,   0.92726,   0.94209,   0.95564,   0.96772,
   0.97812,   0.98669,   0.99327,   0.99774,   1.00000},
  //---------  4.2 GeV
  {0.00029,   0.00260,   0.00715,   0.01383,   0.02251,   0.03304,   0.04523,
   0.05889,   0.07382,   0.08978,   0.10655,   0.12388,   0.14156,   0.15935,
   0.17704,   0.19443,   0.21134,   0.22763,   0.24315,   0.25779,   0.27148,
   0.28416,   0.29581,   0.30640,   0.31596,   0.32453,   0.33214,   0.33885,
   0.34475,   0.34990,   0.35439,   0.35830,   0.36171,   0.36471,   0.36737,
   0.36975,   0.37193,   0.37395,   0.37587,   0.37772,   0.37954,   0.38135,
   0.38318,   0.38503,   0.38691,   0.38884,   0.39081,   0.39283,   0.39489,
   0.39698,   0.39911,   0.40127,   0.40345,   0.40565,   0.40787,   0.41011,
   0.41235,   0.41460,   0.41686,   0.41912,   0.42138,   0.42365,   0.42591,
   0.42818,   0.43045,   0.43272,   0.43501,   0.43730,   0.43960,   0.44192,
   0.44427,   0.44664,   0.44905,   0.45149,   0.45398,   0.45652,   0.45912,
   0.46178,   0.46450,   0.46729,   0.47016,   0.47309,   0.47608,   0.47915,
   0.48227,   0.48544,   0.48867,   0.49193,   0.49521,   0.49851,   0.50182,
   0.50513,   0.50841,   0.51167,   0.51489,   0.51807,   0.52119,   0.52425,
   0.52725,   0.53018,   0.53304,   0.53583,   0.53856,   0.54122,   0.54382,
   0.54636,   0.54885,   0.55129,   0.55370,   0.55607,   0.55842,   0.56074,
   0.56304,   0.56533,   0.56762,   0.56989,   0.57216,   0.57443,   0.57669,
   0.57896,   0.58122,   0.58348,   0.58574,   0.58799,   0.59023,   0.59247,
   0.59469,   0.59689,   0.59907,   0.60123,   0.60336,   0.60545,   0.60751,
   0.60953,   0.61150,   0.61343,   0.61531,   0.61716,   0.61899,   0.62080,
   0.62262,   0.62447,   0.62639,   0.62841,   0.63059,   0.63297,   0.63563,
   0.63863,   0.64204,   0.64595,   0.65044,   0.65559,   0.66148,   0.66820,
   0.67580,   0.68436,   0.69393,   0.70452,   0.71616,   0.72884,   0.74253,
   0.75717,   0.77268,   0.78896,   0.80587,   0.82326,   0.84095,   0.85874,
   0.87641,   0.89375,   0.91052,   0.92648,   0.94140,   0.95506,   0.96725,
   0.97778,   0.98646,   0.99315,   0.99769,   1.00000},
  //---------  4.6 GeV
  {0.00029,   0.00262,   0.00720,   0.01392,   0.02265,   0.03322,   0.04546,
   0.05917,   0.07414,   0.09015,   0.10696,   0.12434,   0.14205,   0.15987,
   0.17759,   0.19500,   0.21192,   0.22821,   0.24372,   0.25835,   0.27202,
   0.28466,   0.29626,   0.30680,   0.31630,   0.32478,   0.33230,   0.33892,
   0.34470,   0.34973,   0.35408,   0.35785,   0.36112,   0.36397,   0.36647,
   0.36869,   0.37071,   0.37258,   0.37435,   0.37606,   0.37775,   0.37945,
   0.38117,   0.38294,   0.38476,   0.38665,   0.38860,   0.39062,   0.39271,
   0.39486,   0.39707,   0.39933,   0.40164,   0.40399,   0.40637,   0.40878,
   0.41121,   0.41366,   0.41611,   0.41856,   0.42100,   0.42344,   0.42586,
   0.42827,   0.43065,   0.43302,   0.43537,   0.43771,   0.44003,   0.44235,
   0.44467,   0.44700,   0.44935,   0.45172,   0.45413,   0.45658,   0.45909,
   0.46167,   0.46432,   0.46705,   0.46986,   0.47275,   0.47573,   0.47879,
   0.48193,   0.48514,   0.48841,   0.49173,   0.49508,   0.49846,   0.50184,
   0.50522,   0.50857,   0.51189,   0.51516,   0.51837,   0.52151,   0.52457,
   0.52755,   0.53045,   0.53326,   0.53599,   0.53864,   0.54121,   0.54372,
   0.54618,   0.54859,   0.55096,   0.55331,   0.55563,   0.55795,   0.56027,
   0.56260,   0.56493,   0.56728,   0.56965,   0.57204,   0.57444,   0.57687,
   0.57930,   0.58175,   0.58420,   0.58665,   0.58909,   0.59152,   0.59393,
   0.59631,   0.59866,   0.60097,   0.60324,   0.60544,   0.60760,   0.60968,
   0.61170,   0.61366,   0.61555,   0.61737,   0.61914,   0.62086,   0.62255,
   0.62424,   0.62595,   0.62772,   0.62959,   0.63161,   0.63384,   0.63634,
   0.63918,   0.64245,   0.64622,   0.65058,   0.65561,   0.66139,   0.66800,
   0.67552,   0.68400,   0.69350,   0.70404,   0.71564,   0.72828,   0.74195,
   0.75658,   0.77209,   0.78837,   0.80530,   0.82271,   0.84042,   0.85824,
   0.87596,   0.89334,   0.91015,   0.92615,   0.94112,   0.95484,   0.96707,
   0.97765,   0.98637,   0.99310,   0.99768,   1.00000},
  //---------  5.0 GeV
  {0.00029,   0.00261,   0.00718,   0.01388,   0.02258,   0.03311,   0.04530,
   0.05895,   0.07385,   0.08979,   0.10652,   0.12382,   0.14145,   0.15918,
   0.17680,   0.19413,   0.21097,   0.22717,   0.24260,   0.25715,   0.27074,
   0.28332,   0.29485,   0.30532,   0.31476,   0.32318,   0.33064,   0.33720,
   0.34292,   0.34789,   0.35218,   0.35589,   0.35909,   0.36187,   0.36429,
   0.36645,   0.36839,   0.37018,   0.37187,   0.37351,   0.37512,   0.37675,
   0.37842,   0.38015,   0.38194,   0.38381,   0.38577,   0.38782,   0.38996,
   0.39218,   0.39449,   0.39687,   0.39933,   0.40185,   0.40442,   0.40704,
   0.40970,   0.41237,   0.41507,   0.41776,   0.42045,   0.42312,   0.42577,
   0.42839,   0.43097,   0.43351,   0.43600,   0.43846,   0.44087,   0.44325,
   0.44561,   0.44795,   0.45028,   0.45261,   0.45497,   0.45736,   0.45979,
   0.46229,   0.46485,   0.46749,   0.47022,   0.47304,   0.47595,   0.47896,
   0.48205,   0.48522,   0.48846,   0.49176,   0.49510,   0.49847,   0.50184,
   0.50521,   0.50854,   0.51184,   0.51508,   0.51825,   0.52135,   0.52435,
   0.52726,   0.53008,   0.53281,   0.53546,   0.53802,   0.54051,   0.54295,
   0.54534,   0.54769,   0.55003,   0.55236,   0.55470,   0.55705,   0.55943,
   0.56185,   0.56430,   0.56680,   0.56934,   0.57192,   0.57454,   0.57718,
   0.57986,   0.58254,   0.58524,   0.58793,   0.59061,   0.59326,   0.59588,
   0.59845,   0.60097,   0.60343,   0.60582,   0.60812,   0.61035,   0.61248,
   0.61453,   0.61649,   0.61836,   0.62016,   0.62188,   0.62355,   0.62518,
   0.62680,   0.62843,   0.63012,   0.63191,   0.63386,   0.63601,   0.63844,
   0.64121,   0.64441,   0.64812,   0.65241,   0.65738,   0.66310,   0.66966,
   0.67712,   0.68554,   0.69497,   0.70545,   0.71698,   0.72955,   0.74315,
   0.75770,   0.77313,   0.78933,   0.80617,   0.82349,   0.84112,   0.85885,
   0.87648,   0.89378,   0.91051,   0.92644,   0.94135,   0.95500,   0.96718,
   0.97772,   0.98641,   0.99311,   0.99768,   1.00000}
 };


// Table of Cumulative pp Scattering Probabilities
// To be used for generation as a function of std::cos(theta cm)
// Coulomb effects are NOT suppressed
// -- including pp Coulomb-nuclear interference
// NOTE: Assumes angle range to be generated is 0-180 degrees
//       even for IDENTICAL particles.  This allows tracking of
//       well-defined GEANT4 particles and generation of secondary
// Range of validity of tables: 10 - 1200 MeV
// Results are extracted from RA Arndt"s PSA of 1998
// CM Angle range: 0.5 - 179.5 degrees in 1 degree steps
// Appended at end: cm momentum (GeV/c), Lab Energy (GeV), max 
// dSigma/domega-CM (mb/sr), total cross section 

 const G4float G4LEpp::SigCoul[NENERGYC][NANGLE] = {
   //------------  0.01 GeV
  {0.47617,   0.49374,   0.49750,   0.49885,   0.49948,   0.49982,   0.50002,
   0.50015,   0.50023,   0.50029,   0.50033,   0.50037,   0.50039,   0.50041,
   0.50043,   0.50044,   0.50046,   0.50047,   0.50048,   0.50049,   0.50049,
   0.50050,   0.50051,   0.50052,   0.50053,   0.50054,   0.50054,   0.50055,
   0.50056,   0.50057,   0.50058,   0.50059,   0.50060,   0.50061,   0.50062,
   0.50063,   0.50064,   0.50065,   0.50066,   0.50067,   0.50069,   0.50070,
   0.50071,   0.50072,   0.50074,   0.50075,   0.50076,   0.50078,   0.50079,
   0.50080,   0.50082,   0.50083,   0.50085,   0.50086,   0.50088,   0.50089,
   0.50091,   0.50093,   0.50094,   0.50096,   0.50098,   0.50099,   0.50101,
   0.50103,   0.50104,   0.50106,   0.50108,   0.50110,   0.50111,   0.50113,
   0.50115,   0.50117,   0.50119,   0.50120,   0.50122,   0.50124,   0.50126,
   0.50128,   0.50130,   0.50132,   0.50134,   0.50136,   0.50137,   0.50139,
   0.50141,   0.50143,   0.50145,   0.50147,   0.50149,   0.50151,   0.50153,
   0.50155,   0.50157,   0.50159,   0.50161,   0.50163,   0.50164,   0.50166,
   0.50168,   0.50170,   0.50172,   0.50174,   0.50176,   0.50178,   0.50180,
   0.50181,   0.50183,   0.50185,   0.50187,   0.50189,   0.50190,   0.50192,
   0.50194,   0.50196,   0.50198,   0.50199,   0.50201,   0.50203,   0.50204,
   0.50206,   0.50208,   0.50209,   0.50211,   0.50212,   0.50214,   0.50216,
   0.50217,   0.50219,   0.50220,   0.50221,   0.50223,   0.50224,   0.50226,
   0.50227,   0.50228,   0.50230,   0.50231,   0.50232,   0.50233,   0.50234,
   0.50236,   0.50237,   0.50238,   0.50239,   0.50240,   0.50241,   0.50242,
   0.50243,   0.50244,   0.50245,   0.50246,   0.50247,   0.50247,   0.50248,
   0.50249,   0.50250,   0.50251,   0.50252,   0.50252,   0.50253,   0.50254,
   0.50255,   0.50256,   0.50257,   0.50259,   0.50261,   0.50263,   0.50265,
   0.50268,   0.50273,   0.50279,   0.50287,   0.50300,   0.50320,   0.50354,
   0.50416,   0.50552,   0.50927,   0.52679,   1.00000},
   //---------  0.02 GeV
  {0.47546,   0.49296,   0.49670,   0.49803,   0.49865,   0.49897,   0.49917,
   0.49929,   0.49937,   0.49943,   0.49947,   0.49950,   0.49952,   0.49954,
   0.49956,   0.49958,   0.49959,   0.49960,   0.49962,   0.49963,   0.49964,
   0.49965,   0.49967,   0.49968,   0.49969,   0.49971,   0.49972,   0.49974,
   0.49975,   0.49977,   0.49979,   0.49980,   0.49982,   0.49984,   0.49986,
   0.49988,   0.49990,   0.49992,   0.49994,   0.49996,   0.49998,   0.50001,
   0.50003,   0.50005,   0.50008,   0.50010,   0.50013,   0.50015,   0.50018,
   0.50020,   0.50023,   0.50026,   0.50029,   0.50031,   0.50034,   0.50037,
   0.50040,   0.50043,   0.50046,   0.50049,   0.50052,   0.50055,   0.50058,
   0.50062,   0.50065,   0.50068,   0.50071,   0.50075,   0.50078,   0.50081,
   0.50085,   0.50088,   0.50091,   0.50095,   0.50098,   0.50102,   0.50105,
   0.50108,   0.50112,   0.50115,   0.50119,   0.50122,   0.50126,   0.50129,
   0.50133,   0.50137,   0.50140,   0.50144,   0.50147,   0.50151,   0.50154,
   0.50158,   0.50161,   0.50165,   0.50168,   0.50172,   0.50176,   0.50179,
   0.50183,   0.50186,   0.50190,   0.50193,   0.50196,   0.50200,   0.50203,
   0.50207,   0.50210,   0.50214,   0.50217,   0.50220,   0.50224,   0.50227,
   0.50230,   0.50233,   0.50237,   0.50240,   0.50243,   0.50246,   0.50249,
   0.50252,   0.50255,   0.50258,   0.50261,   0.50264,   0.50267,   0.50270,
   0.50273,   0.50276,   0.50278,   0.50281,   0.50284,   0.50286,   0.50289,
   0.50291,   0.50294,   0.50296,   0.50299,   0.50301,   0.50303,   0.50305,
   0.50308,   0.50310,   0.50312,   0.50314,   0.50316,   0.50318,   0.50319,
   0.50321,   0.50323,   0.50325,   0.50326,   0.50328,   0.50329,   0.50331,
   0.50332,   0.50334,   0.50335,   0.50336,   0.50337,   0.50339,   0.50340,
   0.50341,   0.50342,   0.50344,   0.50345,   0.50347,   0.50349,   0.50352,
   0.50355,   0.50359,   0.50365,   0.50373,   0.50385,   0.50404,   0.50437,
   0.50498,   0.50632,   0.51004,   0.52751,   1.00000},
   //---------  0.04 GeV
   {0.47428,   0.49167,   0.49535,   0.49665,   0.49724,   0.49755,   0.49773,
   0.49784,   0.49791,   0.49796,   0.49800,   0.49802,   0.49805,   0.49807,
   0.49809,   0.49810,   0.49812,   0.49814,   0.49815,   0.49817,   0.49819,
   0.49821,   0.49823,   0.49826,   0.49828,   0.49830,   0.49833,   0.49836,
   0.49838,   0.49841,   0.49844,   0.49847,   0.49850,   0.49854,   0.49857,
   0.49861,   0.49864,   0.49868,   0.49872,   0.49876,   0.49880,   0.49884,
   0.49888,   0.49892,   0.49897,   0.49901,   0.49906,   0.49910,   0.49915,
   0.49920,   0.49925,   0.49929,   0.49934,   0.49940,   0.49945,   0.49950,
   0.49955,   0.49960,   0.49966,   0.49971,   0.49977,   0.49982,   0.49988,
   0.49993,   0.49999,   0.50005,   0.50010,   0.50016,   0.50022,   0.50028,
   0.50034,   0.50040,   0.50046,   0.50052,   0.50058,   0.50064,   0.50070,
   0.50076,   0.50082,   0.50088,   0.50094,   0.50101,   0.50107,   0.50113,
   0.50119,   0.50125,   0.50132,   0.50138,   0.50144,   0.50150,   0.50157,
   0.50163,   0.50169,   0.50175,   0.50182,   0.50188,   0.50194,   0.50200,
   0.50206,   0.50213,   0.50219,   0.50225,   0.50231,   0.50237,   0.50243,
   0.50249,   0.50255,   0.50261,   0.50267,   0.50273,   0.50279,   0.50285,
   0.50290,   0.50296,   0.50302,   0.50308,   0.50313,   0.50319,   0.50324,
   0.50330,   0.50335,   0.50340,   0.50346,   0.50351,   0.50356,   0.50361,
   0.50366,   0.50371,   0.50376,   0.50381,   0.50386,   0.50390,   0.50395,
   0.50400,   0.50404,   0.50408,   0.50413,   0.50417,   0.50421,   0.50425,
   0.50429,   0.50433,   0.50436,   0.50440,   0.50444,   0.50447,   0.50450,
   0.50453,   0.50457,   0.50460,   0.50462,   0.50465,   0.50468,   0.50470,
   0.50473,   0.50475,   0.50477,   0.50480,   0.50482,   0.50483,   0.50485,
   0.50487,   0.50489,   0.50490,   0.50492,   0.50494,   0.50496,   0.50498,
   0.50501,   0.50505,   0.50510,   0.50517,   0.50528,   0.50546,   0.50577,
   0.50636,   0.50765,   0.51133,   0.52867,   1.00000}, 
   //---------  0.07 GeV
  {0.47246,   0.48968,   0.49329,   0.49454,   0.49510,   0.49538,   0.49554,
   0.49564,   0.49570,   0.49574,   0.49577,   0.49580,   0.49582,   0.49585,
   0.49587,   0.49589,   0.49591,   0.49594,   0.49597,   0.49600,   0.49603,
   0.49606,   0.49610,   0.49613,   0.49617,   0.49622,   0.49626,   0.49630,
   0.49635,   0.49640,   0.49645,   0.49651,   0.49656,   0.49662,   0.49668,
   0.49674,   0.49680,   0.49686,   0.49693,   0.49699,   0.49706,   0.49713,
   0.49720,   0.49727,   0.49735,   0.49742,   0.49750,   0.49757,   0.49765,
   0.49773,   0.49781,   0.49789,   0.49798,   0.49806,   0.49815,   0.49823,
   0.49832,   0.49841,   0.49850,   0.49858,   0.49868,   0.49877,   0.49886,
   0.49895,   0.49904,   0.49914,   0.49923,   0.49933,   0.49942,   0.49952,
   0.49961,   0.49971,   0.49981,   0.49990,   0.50000,   0.50010,   0.50020,
   0.50030,   0.50040,   0.50050,   0.50060,   0.50070,   0.50080,   0.50090,
   0.50100,   0.50110,   0.50120,   0.50130,   0.50140,   0.50150,   0.50160,
   0.50170,   0.50180,   0.50190,   0.50200,   0.50210,   0.50220,   0.50230,
   0.50240,   0.50250,   0.50260,   0.50270,   0.50280,   0.50290,   0.50299,
   0.50309,   0.50319,   0.50329,   0.50338,   0.50348,   0.50358,   0.50367,
   0.50377,   0.50386,   0.50395,   0.50405,   0.50414,   0.50423,   0.50432,
   0.50441,   0.50450,   0.50459,   0.50468,   0.50476,   0.50485,   0.50494,
   0.50502,   0.50510,   0.50518,   0.50526,   0.50534,   0.50542,   0.50550,
   0.50558,   0.50565,   0.50572,   0.50580,   0.50587,   0.50594,   0.50600,
   0.50607,   0.50614,   0.50620,   0.50626,   0.50632,   0.50638,   0.50644,
   0.50649,   0.50654,   0.50660,   0.50664,   0.50669,   0.50674,   0.50678,
   0.50682,   0.50686,   0.50690,   0.50694,   0.50697,   0.50700,   0.50703,
   0.50706,   0.50708,   0.50711,   0.50713,   0.50715,   0.50717,   0.50720,
   0.50722,   0.50726,   0.50730,   0.50736,   0.50746,   0.50762,   0.50790,
   0.50846,   0.50971,   0.51330,   0.53049,   1.00000},
   //---------  0.1 GeV
  {0.47009,   0.48715,   0.49068,   0.49189,   0.49242,   0.49269,   0.49283,
   0.49292,   0.49298,   0.49302,   0.49305,   0.49308,   0.49311,   0.49314,
   0.49317,   0.49321,   0.49324,   0.49328,   0.49333,   0.49337,   0.49342,
   0.49347,   0.49353,   0.49359,   0.49365,   0.49371,   0.49378,   0.49385,
   0.49392,   0.49399,   0.49407,   0.49415,   0.49424,   0.49432,   0.49441,
   0.49450,   0.49459,   0.49469,   0.49479,   0.49489,   0.49499,   0.49509,
   0.49520,   0.49531,   0.49542,   0.49553,   0.49564,   0.49576,   0.49587,
   0.49599,   0.49611,   0.49623,   0.49635,   0.49648,   0.49660,   0.49673,
   0.49686,   0.49699,   0.49712,   0.49725,   0.49738,   0.49752,   0.49765,
   0.49779,   0.49792,   0.49806,   0.49820,   0.49833,   0.49847,   0.49861,
   0.49875,   0.49889,   0.49904,   0.49918,   0.49932,   0.49946,   0.49961,
   0.49975,   0.49989,   0.50004,   0.50018,   0.50033,   0.50047,   0.50062,
   0.50076,   0.50091,   0.50105,   0.50120,   0.50135,   0.50149,   0.50164,
   0.50178,   0.50193,   0.50207,   0.50222,   0.50237,   0.50251,   0.50266,
   0.50280,   0.50294,   0.50309,   0.50323,   0.50338,   0.50352,   0.50366,
   0.50381,   0.50395,   0.50409,   0.50423,   0.50437,   0.50451,   0.50465,
   0.50479,   0.50492,   0.50506,   0.50520,   0.50533,   0.50547,   0.50560,
   0.50573,   0.50586,   0.50599,   0.50612,   0.50625,   0.50638,   0.50650,
   0.50663,   0.50675,   0.50687,   0.50699,   0.50711,   0.50723,   0.50734,
   0.50746,   0.50757,   0.50768,   0.50778,   0.50789,   0.50799,   0.50810,
   0.50820,   0.50829,   0.50839,   0.50848,   0.50857,   0.50866,   0.50875,
   0.50883,   0.50891,   0.50899,   0.50906,   0.50914,   0.50921,   0.50927,
   0.50934,   0.50940,   0.50946,   0.50951,   0.50956,   0.50961,   0.50966,
   0.50970,   0.50974,   0.50977,   0.50981,   0.50984,   0.50987,   0.50990,
   0.50993,   0.50996,   0.51000,   0.51006,   0.51015,   0.51030,   0.51056,
   0.51109,   0.51230,   0.51583,   0.53285,   1.00000},
   //---------  0.12 GeV
  {0.46810,   0.48504,   0.48853,   0.48972,   0.49023,   0.49049,   0.49063,
   0.49072,   0.49078,   0.49082,   0.49086,   0.49089,   0.49093,   0.49097,
   0.49101,   0.49105,   0.49110,   0.49115,   0.49120,   0.49126,   0.49132,
   0.49139,   0.49146,   0.49154,   0.49161,   0.49170,   0.49178,   0.49187,
   0.49196,   0.49206,   0.49216,   0.49226,   0.49237,   0.49247,   0.49259,
   0.49270,   0.49282,   0.49294,   0.49306,   0.49319,   0.49331,   0.49345,
   0.49358,   0.49371,   0.49385,   0.49399,   0.49414,   0.49428,   0.49443,
   0.49457,   0.49473,   0.49488,   0.49503,   0.49519,   0.49534,   0.49550,
   0.49566,   0.49583,   0.49599,   0.49615,   0.49632,   0.49649,   0.49666,
   0.49683,   0.49700,   0.49717,   0.49734,   0.49752,   0.49769,   0.49787,
   0.49804,   0.49822,   0.49840,   0.49858,   0.49875,   0.49893,   0.49911,
   0.49929,   0.49948,   0.49966,   0.49984,   0.50002,   0.50020,   0.50039,
   0.50057,   0.50075,   0.50093,   0.50112,   0.50130,   0.50149,   0.50167,
   0.50185,   0.50204,   0.50222,   0.50240,   0.50258,   0.50277,   0.50295,
   0.50313,   0.50331,   0.50350,   0.50368,   0.50386,   0.50404,   0.50422,
   0.50440,   0.50457,   0.50475,   0.50493,   0.50510,   0.50528,   0.50545,
   0.50563,   0.50580,   0.50597,   0.50614,   0.50631,   0.50648,   0.50665,
   0.50682,   0.50698,   0.50714,   0.50731,   0.50747,   0.50763,   0.50778,
   0.50794,   0.50809,   0.50824,   0.50840,   0.50854,   0.50869,   0.50884,
   0.50898,   0.50912,   0.50926,   0.50939,   0.50952,   0.50966,   0.50978,
   0.50991,   0.51003,   0.51015,   0.51027,   0.51038,   0.51050,   0.51060,
   0.51071,   0.51081,   0.51091,   0.51101,   0.51110,   0.51119,   0.51127,
   0.51136,   0.51143,   0.51151,   0.51158,   0.51165,   0.51171,   0.51177,
   0.51182,   0.51187,   0.51192,   0.51196,   0.51200,   0.51204,   0.51208,
   0.51211,   0.51215,   0.51219,   0.51225,   0.51234,   0.51248,   0.51274,
   0.51325,   0.51444,   0.51792,   0.53482,   1.00000},
   //---------  0.14 GeV
  {0.46571,   0.48253,   0.48598,   0.48715,   0.48765,   0.48790,   0.48804,
   0.48812,   0.48818,   0.48823,   0.48827,   0.48831,   0.48836,   0.48841,
   0.48846,   0.48851,   0.48857,   0.48864,   0.48871,   0.48878,   0.48886,
   0.48895,   0.48904,   0.48913,   0.48923,   0.48933,   0.48943,   0.48955,
   0.48966,   0.48978,   0.48990,   0.49003,   0.49016,   0.49029,   0.49043,
   0.49057,   0.49072,   0.49087,   0.49102,   0.49117,   0.49133,   0.49149,
   0.49166,   0.49182,   0.49199,   0.49217,   0.49234,   0.49252,   0.49270,
   0.49288,   0.49307,   0.49326,   0.49345,   0.49364,   0.49383,   0.49403,
   0.49423,   0.49443,   0.49463,   0.49483,   0.49504,   0.49525,   0.49546,
   0.49567,   0.49588,   0.49609,   0.49631,   0.49652,   0.49674,   0.49696,
   0.49718,   0.49740,   0.49762,   0.49784,   0.49806,   0.49829,   0.49851,
   0.49874,   0.49896,   0.49919,   0.49942,   0.49965,   0.49987,   0.50010,
   0.50033,   0.50056,   0.50079,   0.50102,   0.50125,   0.50148,   0.50171,
   0.50194,   0.50217,   0.50240,   0.50263,   0.50285,   0.50308,   0.50331,
   0.50354,   0.50377,   0.50399,   0.50422,   0.50444,   0.50467,   0.50489,
   0.50512,   0.50534,   0.50556,   0.50578,   0.50600,   0.50622,   0.50643,
   0.50665,   0.50686,   0.50708,   0.50729,   0.50750,   0.50771,   0.50792,
   0.50812,   0.50832,   0.50853,   0.50873,   0.50893,   0.50912,   0.50932,
   0.50951,   0.50970,   0.50989,   0.51007,   0.51026,   0.51044,   0.51061,
   0.51079,   0.51096,   0.51113,   0.51130,   0.51146,   0.51162,   0.51178,
   0.51194,   0.51209,   0.51224,   0.51238,   0.51252,   0.51266,   0.51280,
   0.51293,   0.51305,   0.51318,   0.51330,   0.51341,   0.51352,   0.51363,
   0.51373,   0.51383,   0.51392,   0.51401,   0.51409,   0.51417,   0.51425,
   0.51432,   0.51438,   0.51444,   0.51450,   0.51455,   0.51460,   0.51464,
   0.51468,   0.51473,   0.51477,   0.51483,   0.51492,   0.51506,   0.51531,
   0.51581,   0.51698,   0.52042,   0.53720,   1.00000},
   //---------  0.18 GeV
  {0.45978,   0.47631,   0.47968,   0.48082,   0.48130,   0.48154,   0.48168,
   0.48177,   0.48184,   0.48191,   0.48197,   0.48203,   0.48209,   0.48217,
   0.48224,   0.48233,   0.48242,   0.48252,   0.48262,   0.48273,   0.48285,
   0.48298,   0.48311,   0.48324,   0.48339,   0.48354,   0.48369,   0.48385,
   0.48402,   0.48419,   0.48437,   0.48455,   0.48474,   0.48493,   0.48513,
   0.48534,   0.48555,   0.48576,   0.48598,   0.48620,   0.48643,   0.48666,
   0.48690,   0.48714,   0.48738,   0.48763,   0.48789,   0.48814,   0.48840,
   0.48867,   0.48894,   0.48921,   0.48949,   0.48977,   0.49005,   0.49034,
   0.49063,   0.49092,   0.49122,   0.49151,   0.49182,   0.49212,   0.49243,
   0.49274,   0.49305,   0.49337,   0.49369,   0.49401,   0.49433,   0.49465,
   0.49498,   0.49531,   0.49564,   0.49597,   0.49631,   0.49664,   0.49698,
   0.49732,   0.49766,   0.49800,   0.49835,   0.49869,   0.49903,   0.49938,
   0.49972,   0.50007,   0.50042,   0.50076,   0.50111,   0.50146,   0.50181,
   0.50215,   0.50250,   0.50285,   0.50319,   0.50354,   0.50388,   0.50423,
   0.50457,   0.50492,   0.50526,   0.50560,   0.50594,   0.50627,   0.50661,
   0.50694,   0.50728,   0.50761,   0.50794,   0.50826,   0.50859,   0.50891,
   0.50923,   0.50955,   0.50987,   0.51018,   0.51049,   0.51080,   0.51110,
   0.51140,   0.51170,   0.51200,   0.51229,   0.51258,   0.51287,   0.51315,
   0.51343,   0.51371,   0.51398,   0.51425,   0.51451,   0.51477,   0.51503,
   0.51529,   0.51553,   0.51578,   0.51602,   0.51626,   0.51649,   0.51672,
   0.51694,   0.51716,   0.51737,   0.51758,   0.51778,   0.51798,   0.51818,
   0.51837,   0.51855,   0.51873,   0.51890,   0.51907,   0.51923,   0.51938,
   0.51953,   0.51967,   0.51981,   0.51994,   0.52007,   0.52018,   0.52029,
   0.52040,   0.52050,   0.52059,   0.52067,   0.52075,   0.52082,   0.52089,
   0.52095,   0.52101,   0.52107,   0.52114,   0.52124,   0.52137,   0.52162,
   0.52210,   0.52323,   0.52660,   0.54309,   1.00000},
   //---------  0.22 GeV
  {0.45250,   0.46873,   0.47203,   0.47313,   0.47360,   0.47385,   0.47399,
   0.47409,   0.47418,   0.47426,   0.47434,   0.47443,   0.47453,   0.47463,
   0.47474,   0.47486,   0.47499,   0.47513,   0.47527,   0.47543,   0.47559,
   0.47576,   0.47594,   0.47613,   0.47632,   0.47653,   0.47674,   0.47696,
   0.47719,   0.47742,   0.47766,   0.47791,   0.47817,   0.47843,   0.47870,
   0.47897,   0.47926,   0.47955,   0.47984,   0.48015,   0.48046,   0.48077,
   0.48109,   0.48142,   0.48176,   0.48210,   0.48244,   0.48280,   0.48316,
   0.48352,   0.48389,   0.48426,   0.48464,   0.48503,   0.48542,   0.48582,
   0.48622,   0.48662,   0.48704,   0.48745,   0.48787,   0.48830,   0.48873,
   0.48916,   0.48960,   0.49004,   0.49048,   0.49093,   0.49138,   0.49184,
   0.49230,   0.49276,   0.49323,   0.49370,   0.49417,   0.49464,   0.49512,
   0.49559,   0.49607,   0.49655,   0.49704,   0.49752,   0.49801,   0.49850,
   0.49898,   0.49947,   0.49996,   0.50045,   0.50095,   0.50144,   0.50193,
   0.50242,   0.50291,   0.50340,   0.50389,   0.50438,   0.50486,   0.50535,
   0.50583,   0.50632,   0.50680,   0.50728,   0.50776,   0.50823,   0.50871,
   0.50918,   0.50965,   0.51011,   0.51057,   0.51103,   0.51149,   0.51194,
   0.51239,   0.51284,   0.51328,   0.51371,   0.51415,   0.51458,   0.51500,
   0.51542,   0.51584,   0.51625,   0.51665,   0.51706,   0.51745,   0.51784,
   0.51823,   0.51861,   0.51898,   0.51935,   0.51972,   0.52008,   0.52043,
   0.52077,   0.52111,   0.52145,   0.52178,   0.52210,   0.52242,   0.52273,
   0.52303,   0.52333,   0.52362,   0.52390,   0.52418,   0.52444,   0.52471,
   0.52496,   0.52521,   0.52545,   0.52569,   0.52591,   0.52613,   0.52634,
   0.52655,   0.52674,   0.52693,   0.52711,   0.52728,   0.52745,   0.52760,
   0.52775,   0.52788,   0.52801,   0.52813,   0.52824,   0.52835,   0.52844,
   0.52853,   0.52861,   0.52869,   0.52878,   0.52888,   0.52903,   0.52927,
   0.52974,   0.53085,   0.53413,   0.55032,   1.00000},
   //---------  0.26 GeV
  {0.44429,   0.46019,   0.46342,   0.46450,   0.46497,   0.46522,   0.46537,
   0.46550,   0.46560,   0.46571,   0.46582,   0.46594,   0.46607,   0.46621,
   0.46635,   0.46651,   0.46669,   0.46687,   0.46706,   0.46727,   0.46748,
   0.46771,   0.46794,   0.46819,   0.46844,   0.46871,   0.46899,   0.46927,
   0.46957,   0.46987,   0.47019,   0.47051,   0.47085,   0.47119,   0.47154,
   0.47190,   0.47227,   0.47265,   0.47304,   0.47343,   0.47384,   0.47425,
   0.47467,   0.47510,   0.47554,   0.47598,   0.47644,   0.47690,   0.47737,
   0.47784,   0.47833,   0.47882,   0.47932,   0.47983,   0.48034,   0.48086,
   0.48139,   0.48192,   0.48246,   0.48301,   0.48356,   0.48412,   0.48468,
   0.48525,   0.48583,   0.48641,   0.48700,   0.48759,   0.48818,   0.48878,
   0.48939,   0.49000,   0.49061,   0.49123,   0.49184,   0.49247,   0.49309,
   0.49372,   0.49435,   0.49499,   0.49562,   0.49626,   0.49690,   0.49754,
   0.49819,   0.49883,   0.49947,   0.50012,   0.50076,   0.50141,   0.50206,
   0.50270,   0.50335,   0.50399,   0.50464,   0.50528,   0.50592,   0.50656,
   0.50720,   0.50783,   0.50847,   0.50910,   0.50973,   0.51035,   0.51098,
   0.51160,   0.51221,   0.51282,   0.51343,   0.51404,   0.51464,   0.51523,
   0.51582,   0.51641,   0.51699,   0.51757,   0.51814,   0.51870,   0.51926,
   0.51981,   0.52036,   0.52090,   0.52143,   0.52196,   0.52248,   0.52299,
   0.52350,   0.52400,   0.52449,   0.52498,   0.52545,   0.52592,   0.52638,
   0.52684,   0.52728,   0.52772,   0.52815,   0.52857,   0.52898,   0.52939,
   0.52978,   0.53017,   0.53055,   0.53092,   0.53128,   0.53163,   0.53197,
   0.53231,   0.53263,   0.53295,   0.53325,   0.53355,   0.53383,   0.53411,
   0.53438,   0.53463,   0.53488,   0.53511,   0.53534,   0.53555,   0.53576,
   0.53595,   0.53613,   0.53631,   0.53647,   0.53662,   0.53675,   0.53688,
   0.53700,   0.53711,   0.53722,   0.53733,   0.53745,   0.53760,   0.53785,
   0.53832,   0.53940,   0.54262,   0.55849,   1.00000},
   //---------  0.28 GeV
  {0.43989,   0.45563,   0.45882,   0.45990,   0.46037,   0.46062,   0.46079,
   0.46092,   0.46104,   0.46116,   0.46129,   0.46143,   0.46157,   0.46173,
   0.46190,   0.46208,   0.46228,   0.46249,   0.46271,   0.46294,   0.46318,
   0.46344,   0.46370,   0.46398,   0.46427,   0.46457,   0.46489,   0.46521,
   0.46554,   0.46589,   0.46624,   0.46661,   0.46699,   0.46737,   0.46777,
   0.46818,   0.46860,   0.46902,   0.46946,   0.46991,   0.47036,   0.47083,
   0.47130,   0.47179,   0.47228,   0.47278,   0.47330,   0.47382,   0.47435,
   0.47489,   0.47543,   0.47599,   0.47655,   0.47712,   0.47770,   0.47829,
   0.47888,   0.47949,   0.48010,   0.48071,   0.48134,   0.48197,   0.48260,
   0.48324,   0.48389,   0.48455,   0.48521,   0.48587,   0.48654,   0.48722,
   0.48790,   0.48858,   0.48927,   0.48996,   0.49066,   0.49136,   0.49206,
   0.49277,   0.49348,   0.49419,   0.49490,   0.49562,   0.49634,   0.49706,
   0.49778,   0.49850,   0.49922,   0.49995,   0.50067,   0.50140,   0.50212,
   0.50285,   0.50357,   0.50429,   0.50501,   0.50574,   0.50646,   0.50717,
   0.50789,   0.50860,   0.50931,   0.51002,   0.51073,   0.51143,   0.51213,
   0.51283,   0.51352,   0.51421,   0.51489,   0.51557,   0.51625,   0.51692,
   0.51759,   0.51825,   0.51890,   0.51955,   0.52019,   0.52083,   0.52146,
   0.52208,   0.52270,   0.52331,   0.52391,   0.52450,   0.52509,   0.52567,
   0.52624,   0.52681,   0.52736,   0.52791,   0.52845,   0.52898,   0.52950,
   0.53001,   0.53051,   0.53100,   0.53149,   0.53196,   0.53243,   0.53289,
   0.53333,   0.53377,   0.53420,   0.53461,   0.53502,   0.53542,   0.53581,
   0.53618,   0.53655,   0.53690,   0.53725,   0.53758,   0.53791,   0.53822,
   0.53852,   0.53881,   0.53909,   0.53936,   0.53961,   0.53985,   0.54009,
   0.54031,   0.54051,   0.54071,   0.54089,   0.54106,   0.54122,   0.54137,
   0.54150,   0.54163,   0.54175,   0.54187,   0.54200,   0.54217,   0.54242,
   0.54290,   0.54397,   0.54715,   0.56286,   1.00000},
   //---------  0.30 GeV
  {0.43539,   0.45097,   0.45413,   0.45520,   0.45567,   0.45593,   0.45611,
   0.45625,   0.45639,   0.45653,   0.45667,   0.45683,   0.45699,   0.45717,
   0.45737,   0.45757,   0.45779,   0.45803,   0.45828,   0.45854,   0.45881,
   0.45910,   0.45940,   0.45971,   0.46004,   0.46038,   0.46073,   0.46109,
   0.46147,   0.46185,   0.46225,   0.46266,   0.46308,   0.46352,   0.46396,
   0.46442,   0.46489,   0.46537,   0.46586,   0.46636,   0.46687,   0.46739,
   0.46792,   0.46846,   0.46902,   0.46958,   0.47015,   0.47073,   0.47133,
   0.47193,   0.47254,   0.47316,   0.47379,   0.47443,   0.47508,   0.47573,
   0.47640,   0.47707,   0.47775,   0.47844,   0.47913,   0.47984,   0.48054,
   0.48126,   0.48198,   0.48271,   0.48344,   0.48418,   0.48493,   0.48568,
   0.48644,   0.48720,   0.48796,   0.48873,   0.48950,   0.49028,   0.49105,
   0.49184,   0.49262,   0.49341,   0.49420,   0.49499,   0.49579,   0.49658,
   0.49738,   0.49818,   0.49898,   0.49978,   0.50058,   0.50138,   0.50218,
   0.50298,   0.50378,   0.50458,   0.50538,   0.50618,   0.50698,   0.50777,
   0.50856,   0.50935,   0.51014,   0.51093,   0.51171,   0.51249,   0.51326,
   0.51404,   0.51481,   0.51557,   0.51633,   0.51708,   0.51783,   0.51858,
   0.51932,   0.52005,   0.52078,   0.52150,   0.52222,   0.52293,   0.52363,
   0.52433,   0.52501,   0.52569,   0.52637,   0.52703,   0.52769,   0.52833,
   0.52897,   0.52960,   0.53022,   0.53083,   0.53144,   0.53203,   0.53261,
   0.53319,   0.53375,   0.53430,   0.53484,   0.53538,   0.53590,   0.53641,
   0.53691,   0.53740,   0.53788,   0.53835,   0.53880,   0.53925,   0.53968,
   0.54010,   0.54051,   0.54091,   0.54130,   0.54167,   0.54204,   0.54239,
   0.54273,   0.54305,   0.54337,   0.54367,   0.54395,   0.54423,   0.54449,
   0.54474,   0.54497,   0.54519,   0.54540,   0.54559,   0.54577,   0.54594,
   0.54609,   0.54624,   0.54638,   0.54651,   0.54666,   0.54683,   0.54709,
   0.54757,   0.54863,   0.55179,   0.56733,   1.00000},
   //---------  0.34 GeV
  {0.42589,   0.44111,   0.44420,   0.44526,   0.44574,   0.44602,   0.44622,
   0.44640,   0.44657,   0.44674,   0.44693,   0.44713,   0.44734,   0.44757,
   0.44782,   0.44808,   0.44837,   0.44866,   0.44897,   0.44930,   0.44965,
   0.45001,   0.45039,   0.45078,   0.45119,   0.45161,   0.45205,   0.45250,
   0.45296,   0.45345,   0.45394,   0.45445,   0.45498,   0.45551,   0.45607,
   0.45663,   0.45721,   0.45780,   0.45841,   0.45902,   0.45965,   0.46030,
   0.46095,   0.46162,   0.46230,   0.46299,   0.46370,   0.46441,   0.46514,
   0.46588,   0.46663,   0.46739,   0.46816,   0.46894,   0.46973,   0.47053,
   0.47134,   0.47216,   0.47299,   0.47382,   0.47466,   0.47552,   0.47638,
   0.47724,   0.47811,   0.47899,   0.47988,   0.48077,   0.48167,   0.48257,
   0.48348,   0.48440,   0.48531,   0.48623,   0.48716,   0.48809,   0.48902,
   0.48996,   0.49090,   0.49184,   0.49279,   0.49373,   0.49468,   0.49563,
   0.49658,   0.49753,   0.49849,   0.49944,   0.50040,   0.50135,   0.50231,
   0.50326,   0.50422,   0.50517,   0.50612,   0.50707,   0.50802,   0.50897,
   0.50992,   0.51086,   0.51181,   0.51274,   0.51368,   0.51461,   0.51554,
   0.51647,   0.51739,   0.51831,   0.51922,   0.52013,   0.52103,   0.52193,
   0.52282,   0.52371,   0.52459,   0.52546,   0.52633,   0.52719,   0.52804,
   0.52888,   0.52972,   0.53055,   0.53136,   0.53217,   0.53297,   0.53376,
   0.53454,   0.53532,   0.53608,   0.53682,   0.53756,   0.53829,   0.53901,
   0.53971,   0.54040,   0.54108,   0.54175,   0.54241,   0.54305,   0.54368,
   0.54430,   0.54490,   0.54550,   0.54607,   0.54664,   0.54719,   0.54773,
   0.54825,   0.54876,   0.54926,   0.54974,   0.55021,   0.55066,   0.55110,
   0.55152,   0.55193,   0.55232,   0.55269,   0.55306,   0.55340,   0.55373,
   0.55404,   0.55434,   0.55462,   0.55488,   0.55513,   0.55536,   0.55558,
   0.55578,   0.55596,   0.55614,   0.55631,   0.55648,   0.55668,   0.55696,
   0.55744,   0.55850,   0.56159,   0.57677,   1.00000},
   //---------  0.42 GeV
  {0.40579,   0.42028,   0.42324,   0.42428,   0.42479,   0.42512,   0.42538,
   0.42564,   0.42589,   0.42617,   0.42646,   0.42677,   0.42711,   0.42747,
   0.42785,   0.42826,   0.42869,   0.42914,   0.42962,   0.43012,   0.43064,
   0.43119,   0.43175,   0.43234,   0.43294,   0.43357,   0.43422,   0.43489,
   0.43558,   0.43628,   0.43701,   0.43776,   0.43852,   0.43930,   0.44010,
   0.44092,   0.44175,   0.44261,   0.44348,   0.44436,   0.44526,   0.44618,
   0.44712,   0.44806,   0.44903,   0.45001,   0.45100,   0.45200,   0.45302,
   0.45406,   0.45510,   0.45616,   0.45722,   0.45830,   0.45939,   0.46049,
   0.46160,   0.46272,   0.46385,   0.46499,   0.46613,   0.46728,   0.46844,
   0.46961,   0.47078,   0.47196,   0.47314,   0.47433,   0.47552,   0.47672,
   0.47793,   0.47913,   0.48034,   0.48156,   0.48278,   0.48400,   0.48522,
   0.48645,   0.48768,   0.48891,   0.49014,   0.49137,   0.49261,   0.49385,
   0.49509,   0.49633,   0.49757,   0.49881,   0.50005,   0.50129,   0.50253,
   0.50377,   0.50501,   0.50625,   0.50749,   0.50873,   0.50997,   0.51120,
   0.51244,   0.51367,   0.51490,   0.51613,   0.51736,   0.51858,   0.51980,
   0.52102,   0.52223,   0.52344,   0.52465,   0.52585,   0.52705,   0.52825,
   0.52944,   0.53062,   0.53180,   0.53297,   0.53414,   0.53530,   0.53645,
   0.53759,   0.53873,   0.53986,   0.54097,   0.54208,   0.54318,   0.54427,
   0.54535,   0.54642,   0.54748,   0.54852,   0.54955,   0.55057,   0.55158,
   0.55257,   0.55355,   0.55451,   0.55546,   0.55640,   0.55731,   0.55822,
   0.55910,   0.55997,   0.56082,   0.56166,   0.56248,   0.56328,   0.56406,
   0.56482,   0.56557,   0.56629,   0.56700,   0.56769,   0.56836,   0.56900,
   0.56963,   0.57024,   0.57083,   0.57139,   0.57193,   0.57246,   0.57296,
   0.57343,   0.57389,   0.57432,   0.57472,   0.57511,   0.57547,   0.57581,
   0.57612,   0.57641,   0.57668,   0.57694,   0.57719,   0.57746,   0.57779,
   0.57829,   0.57933,   0.58229,   0.59675,   1.00000},
   //---------  0.52 GeV
  {0.38031,   0.39387,   0.39666,   0.39769,   0.39825,   0.39867,   0.39905,
   0.39944,   0.39985,   0.40030,   0.40078,   0.40130,   0.40186,   0.40245,
   0.40309,   0.40375,   0.40446,   0.40520,   0.40598,   0.40678,   0.40762,
   0.40849,   0.40939,   0.41032,   0.41128,   0.41227,   0.41328,   0.41432,
   0.41539,   0.41647,   0.41759,   0.41872,   0.41988,   0.42106,   0.42226,
   0.42348,   0.42472,   0.42598,   0.42725,   0.42855,   0.42986,   0.43118,
   0.43252,   0.43387,   0.43524,   0.43662,   0.43801,   0.43941,   0.44082,
   0.44224,   0.44367,   0.44511,   0.44655,   0.44800,   0.44946,   0.45091,
   0.45238,   0.45385,   0.45532,   0.45679,   0.45826,   0.45974,   0.46122,
   0.46270,   0.46418,   0.46566,   0.46715,   0.46863,   0.47011,   0.47159,
   0.47308,   0.47456,   0.47604,   0.47752,   0.47901,   0.48049,   0.48197,
   0.48345,   0.48493,   0.48641,   0.48789,   0.48937,   0.49085,   0.49233,
   0.49381,   0.49529,   0.49677,   0.49825,   0.49973,   0.50121,   0.50269,
   0.50417,   0.50565,   0.50712,   0.50860,   0.51008,   0.51156,   0.51304,
   0.51452,   0.51600,   0.51748,   0.51897,   0.52045,   0.52193,   0.52341,
   0.52489,   0.52637,   0.52786,   0.52934,   0.53082,   0.53231,   0.53379,
   0.53527,   0.53675,   0.53823,   0.53972,   0.54120,   0.54267,   0.54415,
   0.54563,   0.54710,   0.54857,   0.55004,   0.55150,   0.55296,   0.55441,
   0.55586,   0.55731,   0.55874,   0.56017,   0.56159,   0.56300,   0.56440,
   0.56580,   0.56717,   0.56854,   0.56990,   0.57124,   0.57256,   0.57387,
   0.57516,   0.57644,   0.57770,   0.57894,   0.58016,   0.58136,   0.58254,
   0.58369,   0.58483,   0.58594,   0.58703,   0.58809,   0.58913,   0.59015,
   0.59113,   0.59209,   0.59302,   0.59392,   0.59479,   0.59563,   0.59644,
   0.59721,   0.59796,   0.59866,   0.59933,   0.59996,   0.60056,   0.60112,
   0.60164,   0.60212,   0.60257,   0.60298,   0.60337,   0.60375,   0.60416,
   0.60472,   0.60575,   0.60854,   0.62207,   1.00000},
   //---------  0.62 GeV
  {0.35864,   0.37149,   0.37423,   0.37533,   0.37603,   0.37662,   0.37721,
   0.37784,   0.37851,   0.37925,   0.38006,   0.38092,   0.38185,   0.38283,
   0.38388,   0.38498,   0.38614,   0.38735,   0.38861,   0.38992,   0.39127,
   0.39266,   0.39410,   0.39557,   0.39708,   0.39862,   0.40020,   0.40180,
   0.40343,   0.40509,   0.40677,   0.40848,   0.41020,   0.41194,   0.41370,
   0.41547,   0.41726,   0.41905,   0.42086,   0.42267,   0.42449,   0.42631,
   0.42814,   0.42996,   0.43179,   0.43360,   0.43542,   0.43723,   0.43903,
   0.44082,   0.44260,   0.44437,   0.44612,   0.44786,   0.44959,   0.45130,
   0.45300,   0.45468,   0.45634,   0.45799,   0.45962,   0.46123,   0.46283,
   0.46441,   0.46597,   0.46752,   0.46905,   0.47056,   0.47206,   0.47354,
   0.47502,   0.47647,   0.47792,   0.47935,   0.48077,   0.48218,   0.48358,
   0.48497,   0.48635,   0.48772,   0.48908,   0.49044,   0.49179,   0.49314,
   0.49448,   0.49581,   0.49715,   0.49848,   0.49981,   0.50114,   0.50247,
   0.50380,   0.50513,   0.50646,   0.50780,   0.50914,   0.51049,   0.51184,
   0.51320,   0.51456,   0.51593,   0.51731,   0.51870,   0.52010,   0.52151,
   0.52293,   0.52436,   0.52581,   0.52726,   0.52874,   0.53022,   0.53172,
   0.53323,   0.53476,   0.53631,   0.53787,   0.53945,   0.54105,   0.54266,
   0.54429,   0.54594,   0.54760,   0.54928,   0.55098,   0.55269,   0.55442,
   0.55616,   0.55791,   0.55968,   0.56146,   0.56325,   0.56505,   0.56686,
   0.56867,   0.57049,   0.57232,   0.57414,   0.57596,   0.57779,   0.57961,
   0.58142,   0.58322,   0.58502,   0.58681,   0.58858,   0.59034,   0.59208,
   0.59380,   0.59550,   0.59719,   0.59884,   0.60048,   0.60208,   0.60365,
   0.60520,   0.60671,   0.60818,   0.60962,   0.61101,   0.61236,   0.61367,
   0.61493,   0.61614,   0.61730,   0.61840,   0.61945,   0.62043,   0.62136,
   0.62222,   0.62302,   0.62376,   0.62444,   0.62507,   0.62566,   0.62625,
   0.62694,   0.62805,   0.63078,   0.64360,   1.00000},
   //---------  0.70 GeV
  {0.34350,   0.35601,   0.35884,   0.36012,   0.36104,   0.36190,   0.36278,
   0.36374,   0.36477,   0.36590,   0.36712,   0.36842,   0.36981,   0.37128,
   0.37283,   0.37446,   0.37616,   0.37792,   0.37975,   0.38163,   0.38356,
   0.38554,   0.38757,   0.38963,   0.39173,   0.39386,   0.39602,   0.39821,
   0.40041,   0.40264,   0.40488,   0.40712,   0.40938,   0.41165,   0.41391,
   0.41618,   0.41844,   0.42069,   0.42294,   0.42518,   0.42740,   0.42960,
   0.43179,   0.43395,   0.43609,   0.43821,   0.44030,   0.44236,   0.44438,
   0.44638,   0.44834,   0.45027,   0.45216,   0.45401,   0.45583,   0.45761,
   0.45936,   0.46106,   0.46273,   0.46437,   0.46597,   0.46753,   0.46905,
   0.47055,   0.47201,   0.47343,   0.47483,   0.47620,   0.47753,   0.47884,
   0.48013,   0.48138,   0.48262,   0.48383,   0.48501,   0.48618,   0.48733,
   0.48846,   0.48957,   0.49067,   0.49175,   0.49282,   0.49388,   0.49493,
   0.49597,   0.49700,   0.49803,   0.49905,   0.50007,   0.50109,   0.50211,
   0.50313,   0.50415,   0.50518,   0.50621,   0.50725,   0.50830,   0.50936,
   0.51043,   0.51151,   0.51261,   0.51372,   0.51485,   0.51600,   0.51717,
   0.51836,   0.51957,   0.52080,   0.52206,   0.52334,   0.52465,   0.52599,
   0.52735,   0.52875,   0.53018,   0.53164,   0.53313,   0.53466,   0.53622,
   0.53782,   0.53945,   0.54112,   0.54283,   0.54457,   0.54635,   0.54817,
   0.55002,   0.55192,   0.55384,   0.55580,   0.55780,   0.55983,   0.56188,
   0.56397,   0.56609,   0.56823,   0.57039,   0.57258,   0.57478,   0.57701,
   0.57924,   0.58149,   0.58374,   0.58601,   0.58827,   0.59054,   0.59280,
   0.59506,   0.59731,   0.59954,   0.60177,   0.60397,   0.60616,   0.60832,
   0.61045,   0.61255,   0.61461,   0.61664,   0.61862,   0.62055,   0.62243,
   0.62426,   0.62602,   0.62772,   0.62935,   0.63090,   0.63237,   0.63376,
   0.63507,   0.63628,   0.63741,   0.63844,   0.63940,   0.64028,   0.64114,
   0.64206,   0.64334,   0.64616,   0.65865,   1.00000},
   //---------  0.80 GeV
  {0.32580,   0.33801,   0.34101,   0.34257,   0.34382,   0.34504,   0.34633,
   0.34774,   0.34926,   0.35090,   0.35267,   0.35456,   0.35656,   0.35868,
   0.36089,   0.36319,   0.36558,   0.36806,   0.37060,   0.37320,   0.37587,
   0.37858,   0.38133,   0.38413,   0.38695,   0.38979,   0.39265,   0.39553,
   0.39841,   0.40129,   0.40417,   0.40704,   0.40990,   0.41274,   0.41556,
   0.41836,   0.42112,   0.42386,   0.42656,   0.42921,   0.43183,   0.43440,
   0.43692,   0.43939,   0.44181,   0.44417,   0.44648,   0.44873,   0.45092,
   0.45305,   0.45512,   0.45714,   0.45909,   0.46098,   0.46281,   0.46459,
   0.46631,   0.46797,   0.46958,   0.47113,   0.47263,   0.47408,   0.47548,
   0.47683,   0.47813,   0.47940,   0.48062,   0.48180,   0.48294,   0.48404,
   0.48511,   0.48614,   0.48715,   0.48812,   0.48906,   0.48998,   0.49088,
   0.49175,   0.49260,   0.49343,   0.49424,   0.49504,   0.49582,   0.49659,
   0.49735,   0.49809,   0.49884,   0.49957,   0.50030,   0.50104,   0.50177,
   0.50250,   0.50324,   0.50398,   0.50473,   0.50548,   0.50625,   0.50703,
   0.50783,   0.50864,   0.50947,   0.51032,   0.51119,   0.51209,   0.51301,
   0.51395,   0.51492,   0.51593,   0.51696,   0.51803,   0.51913,   0.52027,
   0.52145,   0.52267,   0.52394,   0.52524,   0.52659,   0.52799,   0.52944,
   0.53094,   0.53249,   0.53410,   0.53576,   0.53748,   0.53926,   0.54109,
   0.54298,   0.54493,   0.54695,   0.54902,   0.55115,   0.55334,   0.55559,
   0.55790,   0.56026,   0.56268,   0.56515,   0.56767,   0.57024,   0.57285,
   0.57551,   0.57821,   0.58094,   0.58371,   0.58651,   0.58933,   0.59217,
   0.59503,   0.59790,   0.60078,   0.60366,   0.60654,   0.60941,   0.61228,
   0.61512,   0.61794,   0.62073,   0.62349,   0.62620,   0.62886,   0.63147,
   0.63401,   0.63648,   0.63887,   0.64118,   0.64339,   0.64550,   0.64750,
   0.64939,   0.65116,   0.65281,   0.65433,   0.65573,   0.65703,   0.65825,
   0.65949,   0.66105,   0.66405,   0.67623,   1.00000},
   //---------  0.90 GeV
  {0.31155,   0.32353,   0.32669,   0.32849,   0.33003,   0.33159,   0.33326,
   0.33508,   0.33705,   0.33917,   0.34145,   0.34387,   0.34643,   0.34912,
   0.35192,   0.35483,   0.35783,   0.36093,   0.36409,   0.36732,   0.37061,
   0.37394,   0.37730,   0.38069,   0.38410,   0.38752,   0.39094,   0.39436,
   0.39777,   0.40115,   0.40452,   0.40785,   0.41115,   0.41441,   0.41762,
   0.42078,   0.42389,   0.42693,   0.42992,   0.43284,   0.43568,   0.43846,
   0.44116,   0.44379,   0.44634,   0.44881,   0.45120,   0.45351,   0.45574,
   0.45790,   0.45997,   0.46197,   0.46389,   0.46574,   0.46751,   0.46922,
   0.47085,   0.47242,   0.47392,   0.47537,   0.47675,   0.47807,   0.47935,
   0.48056,   0.48173,   0.48285,   0.48393,   0.48497,   0.48596,   0.48691,
   0.48783,   0.48872,   0.48957,   0.49039,   0.49119,   0.49196,   0.49270,
   0.49343,   0.49413,   0.49481,   0.49548,   0.49613,   0.49677,   0.49739,
   0.49801,   0.49861,   0.49921,   0.49981,   0.50040,   0.50099,   0.50158,
   0.50217,   0.50277,   0.50337,   0.50397,   0.50459,   0.50521,   0.50585,
   0.50650,   0.50717,   0.50785,   0.50855,   0.50928,   0.51002,   0.51079,
   0.51159,   0.51241,   0.51326,   0.51415,   0.51507,   0.51602,   0.51701,
   0.51805,   0.51912,   0.52025,   0.52141,   0.52263,   0.52390,   0.52523,
   0.52661,   0.52805,   0.52956,   0.53113,   0.53276,   0.53447,   0.53624,
   0.53809,   0.54001,   0.54201,   0.54408,   0.54623,   0.54847,   0.55078,
   0.55317,   0.55564,   0.55819,   0.56081,   0.56352,   0.56629,   0.56914,
   0.57206,   0.57504,   0.57809,   0.58120,   0.58436,   0.58757,   0.59083,
   0.59412,   0.59746,   0.60082,   0.60421,   0.60762,   0.61103,   0.61445,
   0.61787,   0.62128,   0.62467,   0.62804,   0.63137,   0.63465,   0.63788,
   0.64105,   0.64414,   0.64715,   0.65006,   0.65286,   0.65554,   0.65810,
   0.66052,   0.66280,   0.66493,   0.66689,   0.66871,   0.67038,   0.67194,
   0.67348,   0.67529,   0.67844,   0.69039,   1.00000},
   //---------  1.00 GeV
  {0.30023,   0.31202,   0.31534,   0.31738,   0.31921,   0.32110,   0.32315,
   0.32537,   0.32778,   0.33037,   0.33315,   0.33609,   0.33919,   0.34243,
   0.34579,   0.34927,   0.35285,   0.35652,   0.36025,   0.36404,   0.36788,
   0.37175,   0.37564,   0.37954,   0.38344,   0.38733,   0.39120,   0.39504,
   0.39885,   0.40262,   0.40634,   0.41000,   0.41361,   0.41714,   0.42061,
   0.42400,   0.42730,   0.43053,   0.43366,   0.43671,   0.43966,   0.44251,
   0.44527,   0.44793,   0.45050,   0.45296,   0.45534,   0.45761,   0.45979,
   0.46188,   0.46388,   0.46579,   0.46762,   0.46936,   0.47103,   0.47261,
   0.47413,   0.47558,   0.47696,   0.47827,   0.47953,   0.48073,   0.48187,
   0.48296,   0.48401,   0.48501,   0.48596,   0.48688,   0.48776,   0.48860,
   0.48941,   0.49018,   0.49093,   0.49165,   0.49235,   0.49302,   0.49368,
   0.49431,   0.49492,   0.49552,   0.49611,   0.49668,   0.49724,   0.49779,
   0.49833,   0.49886,   0.49939,   0.49991,   0.50043,   0.50095,   0.50147,
   0.50199,   0.50252,   0.50305,   0.50358,   0.50412,   0.50467,   0.50523,
   0.50580,   0.50639,   0.50698,   0.50760,   0.50823,   0.50888,   0.50956,
   0.51025,   0.51098,   0.51172,   0.51250,   0.51331,   0.51415,   0.51503,
   0.51594,   0.51690,   0.51790,   0.51894,   0.52004,   0.52118,   0.52238,
   0.52364,   0.52495,   0.52633,   0.52778,   0.52929,   0.53088,   0.53255,
   0.53429,   0.53612,   0.53803,   0.54003,   0.54211,   0.54430,   0.54657,
   0.54894,   0.55141,   0.55397,   0.55663,   0.55939,   0.56225,   0.56520,
   0.56824,   0.57138,   0.57460,   0.57791,   0.58130,   0.58476,   0.58830,
   0.59190,   0.59556,   0.59928,   0.60305,   0.60686,   0.61070,   0.61458,
   0.61847,   0.62237,   0.62627,   0.63015,   0.63402,   0.63786,   0.64165,
   0.64539,   0.64905,   0.65263,   0.65611,   0.65948,   0.66271,   0.66581,
   0.66875,   0.67153,   0.67412,   0.67653,   0.67875,   0.68080,   0.68269,
   0.68452,   0.68656,   0.68987,   0.70164,   1.00000},
   //---------  1.10 GeV
  {0.29087,   0.30256,   0.30604,   0.30832,   0.31045,   0.31269,   0.31511,
   0.31775,   0.32061,   0.32369,   0.32697,   0.33044,   0.33407,   0.33786,
   0.34179,   0.34582,   0.34996,   0.35417,   0.35844,   0.36276,   0.36710,
   0.37145,   0.37581,   0.38015,   0.38447,   0.38876,   0.39300,   0.39718,
   0.40131,   0.40536,   0.40934,   0.41323,   0.41704,   0.42075,   0.42437,
   0.42788,   0.43129,   0.43459,   0.43778,   0.44085,   0.44381,   0.44666,
   0.44939,   0.45200,   0.45451,   0.45690,   0.45919,   0.46136,   0.46344,
   0.46541,   0.46729,   0.46907,   0.47076,   0.47237,   0.47390,   0.47536,
   0.47674,   0.47805,   0.47929,   0.48048,   0.48161,   0.48268,   0.48370,
   0.48468,   0.48561,   0.48649,   0.48734,   0.48816,   0.48894,   0.48969,
   0.49041,   0.49110,   0.49177,   0.49242,   0.49304,   0.49365,   0.49424,
   0.49481,   0.49537,   0.49591,   0.49644,   0.49697,   0.49748,   0.49799,
   0.49849,   0.49898,   0.49947,   0.49996,   0.50044,   0.50092,   0.50141,
   0.50189,   0.50238,   0.50287,   0.50336,   0.50386,   0.50437,   0.50488,
   0.50540,   0.50594,   0.50648,   0.50704,   0.50761,   0.50820,   0.50881,
   0.50943,   0.51008,   0.51075,   0.51144,   0.51216,   0.51291,   0.51369,
   0.51450,   0.51535,   0.51624,   0.51717,   0.51815,   0.51917,   0.52024,
   0.52137,   0.52255,   0.52380,   0.52511,   0.52649,   0.52794,   0.52947,
   0.53108,   0.53278,   0.53456,   0.53644,   0.53841,   0.54048,   0.54266,
   0.54494,   0.54734,   0.54984,   0.55246,   0.55519,   0.55803,   0.56100,
   0.56407,   0.56726,   0.57056,   0.57396,   0.57748,   0.58109,   0.58480,
   0.58861,   0.59251,   0.59648,   0.60054,   0.60466,   0.60885,   0.61309,
   0.61737,   0.62169,   0.62603,   0.63039,   0.63474,   0.63909,   0.64340,
   0.64767,   0.65188,   0.65602,   0.66005,   0.66398,   0.66777,   0.67140,
   0.67487,   0.67815,   0.68123,   0.68409,   0.68673,   0.68915,   0.69139,
   0.69351,   0.69580,   0.69928,   0.71094,   1.00000},
   //---------  1.20 GeV
  {0.28281,   0.29444,   0.29810,   0.30065,   0.30308,   0.30567,   0.30849,
   0.31156,   0.31489,   0.31846,   0.32226,   0.32626,   0.33044,   0.33479,
   0.33927,   0.34386,   0.34853,   0.35328,   0.35807,   0.36288,   0.36769,
   0.37250,   0.37728,   0.38202,   0.38670,   0.39132,   0.39587,   0.40032,
   0.40469,   0.40896,   0.41312,   0.41717,   0.42110,   0.42491,   0.42860,
   0.43216,   0.43559,   0.43889,   0.44206,   0.44510,   0.44800,   0.45077,
   0.45342,   0.45593,   0.45833,   0.46060,   0.46275,   0.46479,   0.46673,
   0.46856,   0.47029,   0.47192,   0.47347,   0.47494,   0.47632,   0.47763,
   0.47887,   0.48005,   0.48117,   0.48223,   0.48323,   0.48419,   0.48510,
   0.48597,   0.48680,   0.48760,   0.48835,   0.48908,   0.48978,   0.49046,
   0.49110,   0.49173,   0.49234,   0.49292,   0.49349,   0.49405,   0.49459,
   0.49512,   0.49564,   0.49615,   0.49665,   0.49714,   0.49762,   0.49810,
   0.49857,   0.49904,   0.49951,   0.49997,   0.50044,   0.50090,   0.50136,
   0.50182,   0.50229,   0.50275,   0.50322,   0.50370,   0.50417,   0.50466,
   0.50515,   0.50565,   0.50616,   0.50668,   0.50721,   0.50775,   0.50830,
   0.50887,   0.50946,   0.51007,   0.51069,   0.51134,   0.51201,   0.51271,
   0.51344,   0.51420,   0.51499,   0.51582,   0.51669,   0.51760,   0.51856,
   0.51957,   0.52063,   0.52174,   0.52292,   0.52416,   0.52547,   0.52686,
   0.52832,   0.52987,   0.53151,   0.53324,   0.53507,   0.53700,   0.53904,
   0.54120,   0.54347,   0.54586,   0.54838,   0.55102,   0.55379,   0.55670,
   0.55973,   0.56290,   0.56620,   0.56963,   0.57319,   0.57688,   0.58069,
   0.58462,   0.58867,   0.59283,   0.59710,   0.60147,   0.60593,   0.61047,
   0.61509,   0.61977,   0.62451,   0.62929,   0.63410,   0.63891,   0.64372,
   0.64851,   0.65326,   0.65793,   0.66252,   0.66700,   0.67134,   0.67553,
   0.67953,   0.68333,   0.68690,   0.69022,   0.69330,   0.69612,   0.69871,
   0.70114,   0.70368,   0.70735,   0.71894,   1.00000}
 };

 // CM momentum (GeV/c)
 const G4float G4LEpp::PcmCoul[NENERGYC] = {
   0.685E-01, 0.969E-01, 0.137, 0.181, 0.217, 0.237, 0.256,
   0.291, 0.321, 0.349, 0.362, 0.375, 0.399, 0.444,
   0.494, 0.539, 0.573, 0.613, 0.650, 0.685, 0.718, 0.750
 };

 // Lab energy (GeV)
 const G4float G4LEpp::ElabCoul[NENERGYC] = {
     0.100E-01, 0.200E-01, 0.400E-01, 0.700E-01, 0.100, 0.120, 0.140,
     0.180, 0.220, 0.260, 0.280, 0.300, 0.340, 0.420,
     0.520, 0.620, 0.700, 0.800, 0.900, 1.00, 1.10, 1.20
 };
 
 // Max dSigma/domega-CM (mb/sr)
 const G4float G4LEpp::dSigmaxCoul[NENERGYC] = {
   0.145E+09, 0.368E+08, 0.950E+07, 0.324E+07, 0.166E+07, 0.118E+07, 0.893E+06,
   0.570E+06, 0.401E+06, 0.302E+06, 0.266E+06, 0.237E+06, 0.193E+06, 0.138E+06,
   0.994E+05, 0.767E+05, 0.645E+05, 0.536E+05, 0.458E+05, 0.399E+05, 0.353E+05,
   0.316E+05
 };

 // Total cross section
 const G4float G4LEpp::SigtotCoul[NENERGYC] = {
   0.146E+06, 0.371E+05, 0.958E+04, 0.328E+04, 0.169E+04, 0.121E+04,  918.,
   593.,  424.,  325.,  290.,  261.,  217.,  163.,
   125.,  102.,  89.8,  78.8,  70.3,  63.6,  58.0,  53.5
 };
