/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TABLE_TABLEIO_HDF_HH
#define TABLE_TABLEIO_HDF_HH

#include "tableIO.hh"
#include "H5Cpp.h"
#include <vector>

#ifndef H5_NO_NAMESPACE
namespace H5 {
    class CompType;
    class DataSet;
}
#define H5SPACE H5
#else
#define H5SPACE
#endif

namespace table {

    class Table;

    /**  The tableIO_hdf class supplies methods for reading and writing
      *	 hdf5 files.
      */
    class tableIO_hdf : public tableIO {
    public:
	/**  Default constructor.
	  *  \brief default constructor.
	  */
	tableIO_hdf(void);

	/**  Virtual destructor.
	  *  \brief Destructor.
	  */
	virtual ~tableIO_hdf(void);

	/**  Lay out the data plan.
	  */
	void plan_data(const Table& tab);

	/**  Get the data fields from an open dataset. Build table columns
	  *  or verify that the table is identical.
	  */
	void read_data_struct(Table& tab, const H5SPACE::DataSet& dataset);

	/**  Read a table from the specified file and table name.
	  *  \brief Read a table.
	  *  \param path File path string.
	  *  \param name Table name string.
	  */
	void readTable(Table& tabl, const std::string& path, 
		       const std::string& name);

	/**  Write a table to the specified file and table name.
	  *  \brief Write a table.
	  *  \param path File path string.
	  *  \param name Table name string.
	  */
	void writeTable(const Table& tabl, const std::string& path, 
			const std::string& name);

    private:
	struct layout {
	    std::string _name;
	    int         _type;
	    size_t      _length;
	    size_t      _offset;
	};
	typedef std::vector<layout> layout_vect;
	typedef layout_vect::const_iterator layout_iter;

	layout_vect _plan;
	size_t      _plan_size;

	/**  Define dataset for this table.
	 */
	H5SPACE::CompType* _dataType;
    };

}  // namespace table
#endif // !defined(TABLE_TABLEIO_HDF_HH)
