/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef SEG_IO_XSIL_HH
#define SEG_IO_XSIL_HH

#include "seg_iobase.hh"

/**  The seg_ioxsil class reads and writes segments to/from an S6 format 
  *  xsil file.
  *  \brief Segment list xml I/O.
  *  \author John Zweizig
  *  \version 1.0; last modified July 27, 2011
  */
class seg_ioxsil : public seg_iobase {
public:

    /**  Default constructor for a segment reader.
      *  \brief Default constructor
      */ 
    seg_ioxsil(void);

    /**  Destructor for an xsil segment reader.
      *  \brief Destructor
      */ 
    ~seg_ioxsil(void);

    /**  Read the specified segment(s) from the input file. The input file
      *  format is inferred from the file name extension. The segments 
      *  specified with \c name and \c version are read in from the file.
      *  If \c name is empty, all segment names are read in. If \c version
      *  is empty, all versions are read in. If the input file does not
      *  specify the segment name or version, the requested name and version
      *  are used. All segment names are prefixed with the specified 
      *  prefix string.
      *  \brief read segments from a file.
      *  \param file    Input file name.
      *  \param select  Segment name to be read in.
      *  \param format  File format (ascii files only - see read_txt).
      */
    void read_seg(const std::string& file, const segID& select, 
		  const std::string& format="");

    /**  Write selected segments from the specified map to an xsil file.
      *  \brief Write selected segments.
      *  \param smap   Segment map containing segment list(s) to be written.
      *  \param select Segment type(s) to be written.
      *  \param format Format information (not used)
      *  \param file   Xml file name
      */
    void write_seg(const seg_map& smap, const segID& select,
		   const std::string& format, const std::string& file);

private:
};

#endif // !defined(SEG_IO_XSIL_HH)
