//
//    Framecmp compares the data portion of two frames.
//
#include "Dacc.hh"
#include "framecpp/FrameH.hh"
#include "framecpp/FrVect.hh"
#include "framecpp/FrRawData.hh"
#include "framecpp/FrAdcData.hh"
#include "framecpp/OFrameStream.hh"
#include <string>
#include <iostream>
#include <fstream>

using namespace std;
using FrameCPP::FrameH;
using FrameCPP::FrAdcData;
using FrameCPP::FrRawData;
using FrameCPP::FrProcData;
using FrameCPP::FrVect;

//======================================  Frame comparison main function
int
main(int argc, const char* argv[]) {
    Dacc In1;
    In1.setTOCMode(false);
    In1.addFile(argv[argc-2]);

    bool file_1_OK = In1.synch() == 0;
    if (!file_1_OK) {
        cerr << "framecmp: Unable to open file 1" << endl;
        return 1;
    }

    FrameCPP::Common::FrameBuffer<std::filebuf> fb(ios::out);
    if (!fb.open(argv[argc-1], ios::out)) return -1;
    FrameCPP::OFrameStream mWriter(&fb);

    while (file_1_OK) {
        frameh_pointer mFrame(In1.getFrame());

        //------------------------------  Compress vectors
        frrawdata_pointer raw(mFrame->GetRawData());
	if (raw) {
	    FrRawData::firstAdc_iterator adcIter=raw->RefFirstAdc().begin();
	    for ( ; adcIter != raw->RefFirstAdc().end() ; adcIter++ ) {
	        fradcdata_pointer ap(*adcIter);
		ap->RefData().front()->Compress(FrVect::GZIP, 2);
	    }
	}

	for (FrameH::const_procData_iterator 
	       i=mFrame->RefProcData().begin() ;
	     i != mFrame->RefProcData().end() ; i++) {
	    (*i)->RefData().front()->Compress(FrVect::GZIP, 2);
	}

        //------------------------------  Write the data
#ifndef FCPP_SHARED_PTRS
	mWriter.WriteFrame(*mFrame);
#else
	mWriter.WriteFrame(mFrame);
#endif
        //------------------------------  Go On to the next frame.
	file_1_OK = In1.nextFrame() == 0;
    }
    return 0;
}
