/* -*- mode: c++; c-basic-offset: 3; -*- */
//
//    Trigger result class implementation.
//
#include "TrigRslt.hh"
#include "TrigRaw.hh"
#include "TrigProc.hh"
#include "Interval.hh"

using namespace trig;
using namespace std;

//======================================  Data constructor
TrigRslt::TrigRslt(const std::string& ID, const std::string& SubID, 
		   index_type nData, const param_type *DList) 
   : TrigBase(ID, SubID)
{
   mResult.clear();
   if (nData > 0 && DList) {
      mResult.assign(DList, DList+nData);
   } else if (nData) {
      mResult.resize(nData, param_type(0));
   }
}

//======================================  Destructor
TrigRslt::~TrigRslt(void) {
}
