/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "TrigBase.hh"
#include "TrigProc.hh"
#include "TrigRaw.hh"
#include <cstring>

using namespace trig;

//======================================  Default Constructor
TrigBase::TrigBase(void) 
  : mCreatorDB(0), mTime(0), mDuration(0), mPriority(p_info),
    mDisposition(d_metaDB), mSize(0.0), mSignificance(0.0), mFrequency(0.0),
    mBandwidth(0.0), mPeakTime(0), mAvgTime(0), mTimeSigma(0), mFreqPeak(0),
    mFreqAvg(0), mFreqSigma(0), mNoisePower(0), mSignalPower(0),
    mPixelCount(0), mConfidence(0)
{}

//======================================  Data Constructor
TrigBase::TrigBase(const std::string& ID, const std::string& SubID, 
		   const Time& When, const Interval& dTime, double Size,
		   double Significance, double Freq, const std::string& ifo) 
    : mCreatorDB(0), mName(ID), mSubID(SubID), mIfo(ifo), mTime(When),
      mDuration(dTime), mPriority(p_info), mDisposition(d_metaDB), mSize(Size),
      mSignificance(Significance), mFrequency(Freq), mBandwidth(0.0),
      mPeakTime(0), mAvgTime(0), mTimeSigma(0), mFreqPeak(0), mFreqAvg(0),
      mFreqSigma(0), mNoisePower(0), mSignalPower(0), mPixelCount(0),
      mConfidence(0)
{}

//======================================  Clone a TrigBase instance.
TrigBase*
TrigBase::clone(void) const {
    return new TrigBase(*this);
}

//======================================  Mutaters
void 
TrigBase::setAvgOffset(Interval dT) {
    mAvgTime = dT;
}

void 
TrigBase::setAvgTime(const Time& t) {
    mAvgTime = t - mTime;
}

void
TrigBase::setBandwidth(double bw) {
    mBandwidth = bw;
}

void 
TrigBase::setConfidence(double cl) {
    mConfidence = cl;
}

void 
TrigBase::setDisposition(int disp) {
    mDisposition = disp;
}

void 
TrigBase::setDuration(Interval dT) {
    mDuration = dT;
}

void
TrigBase::setFrequency(double f0) {
    mFrequency = f0;
}

void 
TrigBase::setFreqAvg(double f) {
    mFreqAvg = f;
}

void 
TrigBase::setFreqPeak(double f) {
    mFreqPeak = f;
}

void 
TrigBase::setFreqSigma(double s) {
    mFreqSigma = s;
}

void 
TrigBase::setID(const std::string& id, const std::string& subid) {
    mName  = id;
    mSubID = subid;
}

void 
TrigBase::setIfos(const char* IFO) {
    mIfo = IFO;
}

void 
TrigBase::setIntensity(double Mag) {
    mSize = Mag;
}

void 
TrigBase::setNoisePower(double np) {
    mNoisePower = np;
}

void 
TrigBase::setPeakOffset(Interval dT) {
    mPeakTime = dT;
}

void 
TrigBase::setPeakTime(const Time& t) {
    mPeakTime = t - mTime;
}

void 
TrigBase::setPixelCount(int N) {
    mPixelCount = N;
}

void 
TrigBase::setPriority(TrigPrio prio) {
    mPriority = prio;
}

void 
TrigBase::setProcess(const char* procID) {
    mProcess = procID;
}

void 
TrigBase::setSignalPower(double sp) {
    mSignalPower = sp;
}

void 
TrigBase::setSignificance(double sigma) {
    mSignificance = sigma;
}

void 
TrigBase::setTime(const Time& T0) {
    mTime = T0;
}


void 
TrigBase::setTimeSigma(Interval s) {
    mTimeSigma = s;
}

bool 
TrigBase::operator==(const TrigBase& x) const {
    return (mProcess == x.mProcess && 
	    mName == x.mName && 
	    mSubID == x.mSubID && 
	    mTime == x.mTime && 
	    mIfo == x.mIfo);
}
