/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "SBTrigger.hh"
#include <stdexcept>
#include <cstring>

using namespace trig;
using namespace std;

//======================================  Constructors
SBTrigger::SBTrigger(void) {
}

//======================================  Base data constructor.
SBTrigger::SBTrigger(const std::string& srch, const std::string& chan,
	  const Time& start, Interval dt, double freq, double bw, 
	  double sig)
    : TrigBase(srch.c_str(), chan.c_str(), start, dt, 1.0, sig, freq)
{
    snr(sig);      // snr goes to significance and signal, noise.
    bandwidth(bw);
}

//======================================  Destructor
SBTrigger::~SBTrigger(void) {
}

//====================================== Undefined most significant tile methods
double 
SBTrigger::chisq(void) const {
    return 0;
}

double 
SBTrigger::chisq_dof(void) const {
    return 0;
}

double 
SBTrigger::ms_bandwidth(void) const {
    throw logic_error("Undefined function SBTrigger::ms_bandwidth()");
}

double 
SBTrigger::ms_confidence(void) const {
    throw logic_error("Undefined function SBTrigger::ms_confidence()");
}

double
SBTrigger::ms_fhigh(void) const {
    throw logic_error("Undefined function SBTrigger::ms_fhigh()");
}

double 
SBTrigger::ms_flow(void) const {
    throw logic_error("Undefined function SBTrigger::ms_flow()");
}

//====================================== Get parameter name
string 
SBTrigger::param_name(int i) const {
    return par_name[i];
}

//====================================== Get parameter name
double
SBTrigger::param_value(int i) const {
    return par_value[i];
}

double 
SBTrigger::peak_frequency_error(void) const {
    throw logic_error("Undefined function SBTrigger::peak_frequency_error()");
}

double 
SBTrigger::peak_strain(void) const {
    throw logic_error("Undefined function SBTrigger::peak_strain()");
}

double 
SBTrigger::peak_strain_error(void) const {
    throw logic_error("Undefined function SBTrigger::peak_strain_error()");
}

Interval 
SBTrigger::peak_time_error(void) const {
    throw logic_error("Undefined function SBTrigger::peak_time_error()");
}

double 
SBTrigger::snr(void) const {
    double signal = getSignalPower();
    if (signal < 0) return 0;
    double noise  = getNoisePower();
    if (noise <= 0) noise = 1.0;
    return sqrt(signal/noise);
}

double 
SBTrigger::tfvolume(void) const {
    throw logic_error("Undefined function SBTrigger::tfvolume()");
}

Interval 
SBTrigger::time_lag(void) const {
    throw logic_error("Undefined function SBTrigger::time_lag()");
}

void 
SBTrigger::amplitude(double a) {
    setIntensity(a);
}

void 
SBTrigger::bandwidth(double bw) {
    setBandwidth(bw);
}

void 
SBTrigger::central_freq(double f0) {
    setFrequency(f0);
}

//======================================  Set channel name
void 
SBTrigger::channel(const std::string& c) {
    setID(search(), c);
}
void 
SBTrigger::confidence(double a) {
    setConfidence(a);
}
void 
SBTrigger::duration(Interval dt) {
    setDuration(dt);
}

void
SBTrigger::hrss(double h) {
    setSignalPower(h*h);
}

//======================================  Set the ifo ID string
void  
SBTrigger::ifo(const std::string& i) {
    setIfos(i.c_str());
}

void  
SBTrigger::ms_bandwidth(double bw) {
    throw logic_error("Undefined function SBTrigger::ms_bandwidth()");
}
void  
SBTrigger::ms_confidence(double c) {
    throw logic_error("Undefined function SBTrigger::ms_confidence()");
}

void  
SBTrigger::ms_duration(Interval dt) {
    peak_duration = dt;
}

void  
SBTrigger::ms_fhigh(double f) {
    throw logic_error("Undefined function SBTrigger::ms_fhigh()");
}

void  
SBTrigger::ms_flow(double f) {
    throw logic_error("Undefined function SBTrigger::ms_flow()");
}

void  
SBTrigger::ms_start(const Time& t) {
    peak_start = t;
}

void  
SBTrigger::peak_frequency(double a) {
    return setFreqPeak(a);
}

void  
SBTrigger::peak_frequency_error(double a) {
}

void  
SBTrigger::peak_strain(double a) {
}

void  
SBTrigger::peak_strain_error(double a) {
}

//======================================  Set the peak time offset
void 
SBTrigger::peak_time(const Time& t) {
    setPeakTime(t);
}

void 
SBTrigger::peak_time_error(Interval dt) {
}

//======================================  Set the search name
void 
SBTrigger::search(const std::string& s) {
    setID(s, channel());
}

void 
SBTrigger::snr(double a) {
    if (!getNoisePower()) setNoisePower(1.0);
    setSignalPower(a*a*getNoisePower());
}

//======================================  Set the start time
void 
SBTrigger::start_time(const Time& t) {
    setTime(t);
}

void 
SBTrigger::tfvolume(double a) {
}

void 
SBTrigger::time_lag(Interval tl) {
}

//======================================  Set the frequency band
void
SBTrigger::set_frequency_band(double flo, double fhi) {
    double bw = fhi - flo;
    if (bw < 0) {
	bw = 0;
	setFrequency(flo);
    } else {
	setFrequency(0.5 * (flo + fhi));
    }
    bandwidth(bw);
}

//======================================  Set a parameter
void 
SBTrigger::set_param(int i, const std::string& name, double value) {
    size_t lParam = par_name.size();
    if (lParam <= i) {
	par_name.resize(i+1);
	par_value.resize(i+1);
    }
    par_name[i]  = name;
    par_value[i] = value;
}

//======================================  Set single burst times
void 
SBTrigger::set_time(const Time& start, const Time& stop) {
    setTime(start);
    setDuration(stop-start);
}

//======================================  Set most significant pixel times
void 
SBTrigger::set_ms_time(const Time& start, const Time& stop) {
    peak_duration = stop - start;
    peak_start = start; 
}
