/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "Bartlett.hh"
#include "Blackman.hh"
#include "FlatTop.hh"
#include "Hamming.hh"
#include "Hanning.hh"
#include "Kaiser.hh"
#include "Uniform.hh"
#include "Welch.hh"
#include <string>
#include <cctype>
#include <memory>
#include <stdexcept>

static void
lc_str(std::string& s) {
   size_t N = s.size();
   for (size_t i=0; i<N; ++i) s[i] = tolower(s[i]);
}

using namespace std;

window_api*
window_factory(const std::string& name, size_t N) {
   //-----------------------------------  Force lower case
   string tname = name;
   lc_str(tname);
   if (tname == "bartlett") {
      return new Bartlett(N);
   }
   else if (tname == "blackman") {
      return new Blackman(N);
   }
   else if (tname == "flattop") {
      return new FlatTop(N);
   }
   else if (tname == "hamming") {
      return new Hamming(N);
   }
   else if (tname == "hanning" ||
	    tname == "hann") {
      return new Hanning(N);
   }
   else if (tname == "uniform" ||
	    tname == "rectangle" ||
	    tname == "square") {
      return new Uniform(N);
   }
   else if (tname == "welch") {
      return new Welch(N);
   }
   else {
      throw runtime_error("window_factory: Unrecognized window type");
   }
}

window_api*
window_factory_1(const std::string& name, size_t N, double par) {
   //-----------------------------------  Force lower case
   string tname = name;
   lc_str(tname);
   if (tname == "kaiser") {
      return new Kaiser(N, par);
   }
   else if (tname == "tukey") {
      return new Kaiser(N, par);
   }
   else {
      throw runtime_error("window_factory: Unrecognized window type");
   }
}
