/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "Kaiser.hh"
#include <cmath>

using namespace std;

//======================================  Constructor
Kaiser::Kaiser(double alpha, int N)
  : mAlpha(alpha)
{
    mI0AlphaPi = bessel0(mAlpha * M_PI);
    if (N) setWindow(N);
}

//======================================  Destructor
Kaiser::~Kaiser(void) {
}

//======================================  Clone a window
Kaiser*
Kaiser::clone(void) const {
    return new Kaiser(*this);
}

//======================================  Kaiser window function.
double 
Kaiser::WinFc(double arg) {
    double arg1 = arg - 1.0;
    return bessel0(M_PI * mAlpha * sqrt(1.0 - arg1*arg1)) / mI0AlphaPi;
}

//======================================  Modified zeroth order bessel function
double 
Kaiser::bessel0(double x) {
    const double eps=1e-8;     // required accuracy
    double y=x/2.0;
    double sum=1.0;
    double de = 1.0;
    double sde = 1.0;
    for (int i=1 ; i<25 && sum*eps < sde ; i++) {
        de *= y/double(i);
	sde = de*de;
	sum += sde;
    }
    return sum;
}
