/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TRIGTABLE_HH
#define TRIGTABLE_HH

#include "ProcTable.hh"

namespace trig {
    class Segment;
    class TrigBase;

    /**  The TrigTable class is a meta-database interface producing an xsil 
      *  meta database table.
      */
    class TrigTable : public xsil::MetaTable {
    public:
	/**  Construct a trigger table. The alphaPID parameter determines the 
	  *  format of the process id entries. if #alphaPID=true#, the process
	  *  ID is specified as a process table row id, e.g.
	  *  #process:Process_id:0#. If #alphaPID=false#, an external 26-byte 
	  *  process key is specified that must be compressed into a 13-byte 
	  *  BCD field.
	  */
	TrigTable(bool alphaPID=false);

	/**  Write out the trigger table if any data remain, and delete the 
	  *  table and cache variables.
	  */
	~TrigTable(void);
	void addRow(const TrigBase& t);
	void check(const char* title) const;
    private:
	DBTypes::integer_4 start_time;
	DBTypes::integer_4 start_time_ns;
	DBTypes::integer_4 priority;
	DBTypes::integer_4 disposition;
	DBTypes::varchar   name;
	DBTypes::varchar   subtype;
	DBTypes::character ifo;
	DBTypes::character event_id;
	DBTypes::real_4    duration;
	DBTypes::real_4    size;
	DBTypes::real_4    significance;
	DBTypes::real_4    frequency;
	DBTypes::real_4    bandwid;
	DBTypes::real_4    peak_time;
	DBTypes::real_4    avg_time;
	DBTypes::real_4    time_sigma;
	DBTypes::real_4    freq_peak;
	DBTypes::real_4    freq_avg;
	DBTypes::real_4    freq_sigma;
	DBTypes::real_4    noise_power;
	DBTypes::real_4    signal_power;
	DBTypes::integer_4 pixel_count;
	DBTypes::real_4    confidence;

	//------------------------------  UCVecs and their data vectors
	int proc_id_length;
	unsigned char processID[nProcessKeyBytes];
	xsil::UCVec process_id;

	//----------------------------------  Alternative process ID
	bool altPID;
	DBTypes::character PIDstr;
    };

    /**  The SegTable class is a meta-database interface producing an xsil 
      *  meta database table.
      */
    class SegTable : public xsil::MetaTable {
    public:
	/**  Construct a segment table. The alphaPID parameter determines the 
	  *  format of the process id entries. if #alphaPID=true#, the process 
	  *  ID is specified as a process table row id, e.g.
	  *  #process:Process_id:0#. If #alphaPID=false#, an external 26-byte 
	  *  process key is specified that must be compressed into a 13-byte 
	  *  BCD field.
	  */
	SegTable(bool alphaPID=false);
	~SegTable(void);
	void addRow(const Segment& t);
	void check(const char* title) const;
    private:
	DBTypes::varchar   group;
	DBTypes::integer_4 version;
	DBTypes::integer_4 start_time;
	DBTypes::integer_4 start_time_ns;
	DBTypes::integer_4 end_time;
	DBTypes::integer_4 end_time_ns;

	//------------------------------  UCVec and its data vectors.
	int proc_id_length;
	unsigned char processID[nProcessKeyBytes];
	xsil::UCVec process_id;

	//------------------------------  Alternative process ID
	bool altPID;
	DBTypes::character PIDstr;
    };
}

#endif // TRIGTABLE_HH

