/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TRIG_SBTABLE_HH
#define TRIG_SBTABLE_HH

#include "ProcTable.hh"

namespace trig {
    class Segment;
    class TrigBase;

    /**  The TrigTable class is a meta-database interface producing an xsil 
      *  meta database table.
      */
    class SBTable : public xsil::MetaTable {
    public:
	/**  Construct a sngl_burst trigger table. The alphaPID parameter 
	  *  determines the format of the process id entries. if 
	  *  \c alphaPID=true, the process ID is specified as a process 
	  *  table row id, \e e.g. \c process:Process_id:0#. If 
	  *  \c alphaPID=false, an external 26-byte process key is specified
	  *  that must be compressed into a 13-byte radix60 field.
	  *  \brief SBTable constructor.
	  *  \param alphaPID If true, Specify process by ptocess table row.
	  */
	SBTable(bool alphaPID=false);

	/**  Write out the trigger table if any data remain, and delete the 
	  *  table and cache variables.
	  */
	~SBTable(void);

	/**  Add the specified trigger as a row in the table.
	  *  \brief Add a row
	  *  \param t Trigger to be added.
	  */
	void addRow(const TrigBase& t);

	/**  Check table contents are valid.
	  *  \param title Table title.
	  */
	void check(const char* title) const;
    private:
	DBTypes::lstring   ifo;
	DBTypes::integer_4 peak_time;
	DBTypes::integer_4 peak_time_ns;
	DBTypes::integer_4 start_time;
	DBTypes::integer_4 start_time_ns;
	DBTypes::real_4    duration;
	DBTypes::lstring   search;
	DBTypes::real_4    central_freq;
	DBTypes::real_4    peak_freq;
	DBTypes::lstring   channel;
	DBTypes::real_4    amplitude;
	DBTypes::real_4    snr;
	DBTypes::real_4    ms_duration;
	//DBTypes::real_8    q_peak;
	DBTypes::real_4    confidence;
	DBTypes::real_8    chisq;
	DBTypes::real_8    chisq_dof;
	DBTypes::real_4    bandwidth;
	DBTypes::character event_id;

	//----------------------------------  Process ID key values
	bool altPID;
	DBTypes::character PIDstr;
	xsil::UCVec process_id;
    };
}

#endif // TRIG_SBTABLE_HH

