/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "SBTable.hh"
#include "SBTrigger.hh"
#include <fstream>
#include <cstdlib>
#include <cmath>

using namespace xsil;
using namespace std;
using namespace trig;

//======================================  Define the trigger table.
SBTable::SBTable(bool alphaPID) 
    : MetaTable("sngl_burst"), altPID(alphaPID), process_id(nProcessKeyBytes)
{
    defineColumn("ifo",           &ifo);
    defineColumn("peak_time",     &peak_time);
    defineColumn("peak_time_ns",  &peak_time_ns);
    defineColumn("start_time",    &start_time);
    defineColumn("start_time_ns", &start_time_ns);
    defineColumn("duration",      &duration);
    defineColumn("search",        &search);
    defineColumn("central_freq",  &central_freq);
    defineColumn("peak_frequency",  &peak_freq);
    defineColumn("channel",       &channel);
    defineColumn("amplitude",     &amplitude);
    defineColumn("snr",           &snr);
    defineColumn("ms_duration",   &ms_duration);
    //defineColumn("q_peak     ",   &q_peak);
    defineColumn("confidence",    &confidence);
    defineColumn("chisq",         &chisq);
    defineColumn("chisq_dof",     &chisq_dof);
    defineColumn("bandwidth",     &bandwidth);
    defineColumn("event_id",      this);
    if (altPID) defineColumn("process_id", &PIDstr, true);
    else        defineColumn("process_id", &process_id);
}

//======================================  Delete the trigger table
SBTable::~SBTable(void) {
    MetaTable::clear();
}

//======================================  Fill the trigger table.
void
SBTable::addRow(const trig::TrigBase& tb) {
    const SBTrigger& t(reinterpret_cast<const SBTrigger&>(tb));
    ifo           = t.ifo();
    peak_time     = t.peak_time().getS();
    peak_time_ns  = t.peak_time().getN();
    start_time    = t.start_time().getS();
    start_time_ns = t.start_time().getN();
    duration      = t.duration();
    search        = t.search();
    central_freq  = t.central_freq();
    peak_freq     = t.peak_frequency();
    channel       = t.channel();
    amplitude     = t.amplitude();
    snr           = t.snr();
    confidence    = t.confidence();
    chisq         = t.chisq();
    chisq_dof     = t.chisq_dof();
    bandwidth     = t.bandwidth();
    ms_duration   = t.ms_duration();
    //q           = 2 * sqrt(M_PI) * central_freq / ms_duration;
    PIDstr        = t.getProcess();
    if (!altPID) {
	ProcTable::packKey(nProcessKeyBytes, PIDstr.c_str(), process_id.pData);
    }
    putRow();
}

//======================================  Check that the pointers are OK
void
SBTable::check(const char* title) const {
    MetaTable::check(title, sizeof(SBTable));
}
