// this class contains all the decimation and
// iir filters required for a single channel
#ifndef Chan_filtset_HH
#define Chan_filtset_HH
#include <string>

class DecimateBy2;

class Chan_filtset {

public:

  // default constructor
  Chan_filtset ( );

  // initialize the bandpass filters
  int fill_filters_for_channel ( char* channame,
				 int srate,
				 IIRfilter_bank* f_bank );

  // reset the decimation filters
  void reset(void);

  // run the filter set

  int run_filters ( TSeries ts,
		    int* pcolumn_count,
		    float* output, 
		    int make_file );

  int get_filter_name( int filter_index, char* pfilter_name );
  int get_filter_srate( int filter_index, int* psrate );

  // destructor
  ~Chan_filtset ( );

  // number of IIR filters to be applied to the data
  int no_of_iirfilt;
  // sampling rate in the initial raw data
  int raw_data_sampling_rate;
  // name of the data channel
  std::string channel_name;

  // holders for decimation filters
  DecimateBy2* decimator;

private:

  // if YES, this is the first time we're running raw data through the
  // decimation filters, if NO, then we've done it before. This variable
  // used by the software to decide whether to initialize arrays for
  // decimated timeseries or not. Also used to decide whether to 
  // free arrays for decimated timeseries.
  int first_filter_run;

  // array showing the number of decimation stages between successive
  // filters.
  int* decstage;

  // array to store base 2 logs of sampling rates
  int* logbuf;

  // array of sampling rates used for each of the filters
  int* sampling_rate;

  // number of IIR filters in file
  int overall_no_of_iirfilt;

  // timeseries holders for decimated data
  TSeries** decimated_data;

  // holders for IIR filters
  IIRfilter_instance* f_ins;

};

#endif // Chan_filtset_HH
