// 
//  Function LLOLHO_Overlap:  Helper function for StochMon.  Calculates
//  overlap reduction function when running on power spectra from
//  different sites.
//  version: TBA (9/10/2004)
//  author: Marc J. Cenac (mjcenac@loyno.edu)
//
////////////////////////////////////////////////////////////////////////////

#ifndef LLOLHO_Overlap_HH
#define LLOLHO_Overlap_HH

#include "FSpectrum.hh"
#include <fstream>
#include <iostream>

/** This function reads in an empty array (gamma[]) and fills it with
    the appropriate numbers for the overlap reduction function between
    the Hanford and Livingston sites. 

    *Note: The overlap reduction function equals one (1) for
     correlations between LHO 2km & LHO 4km
**/


void LLOLHO_Overlap(float *gammaPtr, int nsteps, double f_step, double low_freq);


#endif  // LLOLHO_Overlap_HH
