//
//  Function Integrand:  Helper function for SenseMonitor.  Reads an 
//  FSpectrum "psd" and copies [f^{7/3}*psd(f)]^{-1} into a second 
//  FSpectrum "out".
//   version: n/a ($Date: 2005-01-31 09:22:24 -0800 (Mon, 31 Jan 2005) $;
//                 $Id: Integrand.hh 3277 2005-01-31 17:22:24Z john.whelan $)
//   authors: Marc J. Cenac (mjcenac@loyno.edu)
//            Kevin C. Schlaufman (kcs149@psu.edu)
//
///////////////////////////////////////////////////////////////////////////
#ifndef Integrand_HH
#define Integrand_HH

#ifndef __CINT__
#include "FSpectrum.hh"
#include <fstream>
#include <iostream>
#endif  //------ !def(__CINT__)

// This segment of code assumes that the FSpectrum object has already been
// PSDed and calibrated.  This function inverts the FSpectrum and divides
// by f^(6) and a reference PSD.

/** Helper function for SenseMonitor.  
  * Assigns to out the FSpectrum for $(f^{6} \times (psd_1 * psd_2))^{-1}$.
  * @memo Computes integrand for range estimate integral.
  * @param out Output power spectrum.
  * @param psd_1 first input power spectrum.
  * @param psd_2 second input power spectrum.
  * @param secPerStride #of seconds per stride
  */ 
void integrand(FSpectrum& out, FSpectrum& psd_1, FSpectrum& psd_2, double secPerStride, FSpectrum& gammaValue);

#endif     //  Integrand_HH
