/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef RAYLEIGHGUI_HH
#define RAYLEIGHGUI_HH
#include "TGFrame.h"
#include "TGMenu.h"
#include "TGButton.h"
#include "TGLabel.h"
#include "TGNumberEntry.h"
#include "TGTextView.h"

#include "ligogui/TLGChannelBox.hh"

/**
 *  Rayleigh Monitor GUI, version 6.2 
 *    author: Patrick J. Sutton (psutton@gravity.phys.psu.edu)
 *      date: Oct 27, 2003  
 *
 *  GUI front-end for RayleighMonitor.  Borrows very heavily from 
 *  $ROOTSYS/test/guitest.cxx (Author: Fons Rademakers 07/03/98) and 
 *  /home/dmt/src/dmt/cvs/gds/GUI/ligogui/chntreetest.cc (Author: Daniel Sigg).
 */

//#define MAX_NUM_CHANNELS 10
//---------- Number of channel selection boxes in GUI window.  
//           Since 99.99% of the time people use the -fast option, which 
//           will bug out if more than one channel is entered, I'll set 
//           this to one for now.
#define MAX_NUM_CHANNELS 1

//---------- Include RayleighConfig object
#include "RayleighConfig.hh"

enum ETestCommandIdentifiers {
   M_FILE_OPEN,
   M_FILE_SAVE,
   M_FILE_SAVEAS,
   M_FILE_PRINT,
   M_FILE_PRINTSETUP,
   M_FILE_EXIT,

   M_HELP_CONTENTS,
   M_HELP_SEARCH,
   M_HELP_ABOUT,

   B_CONFIGURE_MONITOR,
   B_OTHER_OPTIONS,
   B_RUN_MONITOR,
   B_PAUSE_MONITOR,
   B_EXIT_MONITOR,

   B_CONFIG_SET,
   B_CONFIG_RETRIEVE,
   B_CONFIG_HELP,
   B_CONFIG_CLOSE,
   
   B_CONFIGHELP_CLOSE
};


/* 
const char *filetypes[] = { "All files",     "*",
                            "ROOT files",    "*.root",
                            "ROOT macros",   "*.C",
                            0,               0 };
 */


class MainDialog : public TGMainFrame {

private:
    TGMenuBar         *fMenuBar;
//  TGPopupMenu       *fMenuFile;
    TGPopupMenu       *fMenuHelp;
    TGPopupMenu       *fCascadeMenu, *fCascade1Menu, *fCascade2Menu;
    TGLayoutHints     *fMenuBarLayout, *fMenuBarItemLayout, *fMenuBarHelpLayout;
    TGVerticalFrame   *fF1;
    TGHorizontalFrame *fF2;
    TGLayoutHints     *fL1;
    TGLayoutHints     *fL2;
    TGPictureButton   *fPictureButton;
    TGTextButton      *fConfigButton;
//  TGTextButton      *fOptionsButton;
    TGTextButton      *fRunButton;
    TGTextButton      *fPauseButton;
    TGTextButton      *fExitButton;

    bool	      pause, exit;

public:
    MainDialog(const TGWindow *p, UInt_t w, UInt_t h);
    virtual ~MainDialog();

    virtual void CloseWindow();
    virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t);

    bool IsPauseRequested();
    bool IsExitRequested();

};



class ConfigDialog : public TGTransientFrame {

private:
    TGVerticalFrame      *fF1;
    TGVerticalFrame      *fF2;
    TGHorizontalFrame    *fF[3];
    TGLayoutHints        *fL1a;
    TGLayoutHints        *fL2;
    TGLayoutHints        *fL3;
    TGLabel              *fLabel[3];
    TGLabel              *fChnLabel;
    TGNumberEntry        *fNumericEntries[3];
    TGButton             *fSetButton;
    TGButton             *fGetButton;
    TGButton             *fHelpButton;
    TGButton             *fExitButton;
    TGCompositeFrame	 *fChnData[MAX_NUM_CHANNELS]; 
  ligogui::TLGChannelCombobox	 *fChn[MAX_NUM_CHANNELS];
    TGNumberEntry        *fLowFrequency[MAX_NUM_CHANNELS];
    TGNumberEntry        *fHighFrequency[MAX_NUM_CHANNELS];
    TGCheckButton        *fChnCheck[MAX_NUM_CHANNELS];
    TGCompositeFrame	 *fTextFrame;
    TGLayoutHints	 *fL1b;

    static const char *const	numlabel[3];
    static const Double_t	numinit[3];

    double 		Stride;
    int 		N;
    int 		MaxStride;
    int 		number_of_channels;
    char		**channel_names;

  ligogui::ChannelEntry *chanNames;
    int chanTotal;
 
public:
   ConfigDialog(const TGWindow *p, const TGWindow *main);
   virtual ~ConfigDialog();
   virtual void CloseWindow();

   void SetParameters();
   void GetParameters();
   virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t);

};



class MessageDisplay : public TGTransientFrame {

private:
    TGVerticalFrame      *fF1;
    TGLayoutHints        *fL1;
    TGTextView           *fHelpView;
    TGTextButton    	 *fCloseButton;

public:
   MessageDisplay(const TGWindow *p, const TGWindow *main, const char* txt);
   virtual ~MessageDisplay();
   virtual void CloseWindow();

   virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t);

};

class AboutDialog : public TGTransientFrame {

private:
    TGVerticalFrame      *fF1;
    TGLayoutHints        *fL1;
    TGPictureButton	 *fPictureButton;
    TGTextButton    	 *fCloseButton;

public:
   AboutDialog(const TGWindow *p, const TGWindow *main);
   virtual ~AboutDialog();
   virtual void CloseWindow();

   virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t);

};

#endif     //  RAYLEIGHGUI_HH

