/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "RayleighGUI.hh"
#include "TSystem.h"
#include "DaccIn.hh"
#include "TApplication.h"

#include "FramePointerTypes.hh"
#include "framecpp/FrRawData.hh"
#include <cstdlib>

using namespace std;
using namespace ligogui;

using FrameCPP::FrRawData;
using ligogui::ChannelEntry;

//=======================================  env_str inline function
inline std::string
env_str(const std::string& name) {
   string ret;
   const char* env = getenv(name.c_str());
   if (env) ret = env;
   return ret;
}


//===========================================================================
//
//          Main Dialog class
//
//===========================================================================

//======================================  MainDialog constructor
MainDialog::MainDialog(const TGWindow* p, UInt_t w, UInt_t h)
 : TGMainFrame(p, w, h), pause(false), exit(false)
{
    //---------- Create the main window.  (A TGMainFrame is a top level window.)

    //---------- Create menubar and popup menus. The hint objects are used 
    //           to place and group the different menu widgets with respect 
    //           to each other.  (Some menus disabled.)
    fMenuBarLayout = new TGLayoutHints(kLHintsTop | kLHintsLeft | 
        kLHintsExpandX, 0, 0, 1, 1);
    fMenuBarItemLayout = new TGLayoutHints(kLHintsTop | kLHintsLeft, 
        0, 4, 0, 0);
    fMenuBarHelpLayout = new TGLayoutHints(kLHintsTop | kLHintsRight);

/*
    fMenuFile = new TGPopupMenu(fClient->GetRoot());
    fMenuFile->AddEntry("&Open...", M_FILE_OPEN);
    fMenuFile->AddEntry("&Save", M_FILE_SAVE);
    fMenuFile->AddEntry("S&ave as...", M_FILE_SAVEAS);
    fMenuFile->AddEntry("&Close", -1);
    fMenuFile->AddSeparator();
    fMenuFile->AddEntry("&Print", M_FILE_PRINT);
    fMenuFile->AddEntry("P&rint setup...", M_FILE_PRINTSETUP);
    fMenuFile->AddSeparator();
    fMenuFile->AddEntry("E&xit", M_FILE_EXIT);
    fMenuFile->DisableEntry(M_FILE_SAVEAS);
    fMenuFile->HideEntry(M_FILE_PRINT);
*/

    fMenuHelp = new TGPopupMenu(fClient->GetRoot());
    fMenuHelp->AddEntry("&Contents", M_HELP_CONTENTS);
    fMenuHelp->AddSeparator();
    fMenuHelp->AddEntry("&About", M_HELP_ABOUT);

    // Menu button messages are handled by the main frame (i.e. "this")
    // ProcessMessage() method.
//  fMenuFile->Associate(this);
    fMenuHelp->Associate(this);

    fMenuBar = new TGMenuBar(this, 1, 1, kHorizontalFrame);
//  fMenuBar->AddPopup("&File", fMenuFile, fMenuBarItemLayout);
    fMenuBar->AddPopup("&Help", fMenuHelp, fMenuBarHelpLayout);
    AddFrame(fMenuBar, fMenuBarLayout);

    //---------- Add horizontal frame.  Buttons, etc., will go in sub-frames 
    //           attached to this.  Size is irrelevant (I think).
    fF2 = new TGHorizontalFrame(this, 500, 500);
    AddFrame(fF2);

    //---------- Add configure, options, run, pause, and exit buttons 
    //           in vertical column at left.  Size will be changed later.
    fF1 = new TGVerticalFrame(fF2, 300, 200);
    fL1 = new TGLayoutHints(kLHintsTop | kLHintsLeft, 2, 2, 2, 2);
    fF2->AddFrame(fF1, fL1);

    fConfigButton = new TGTextButton(fF1, " Configure Monitor ", 
        B_CONFIGURE_MONITOR);
    fConfigButton->Associate(this);
    fF1->AddFrame(fConfigButton,fL1);

    fF1->Resize(fConfigButton->GetDefaultWidth()+40, GetDefaultHeight());
    fL1 = new TGLayoutHints(kLHintsTop | kLHintsExpandX, 2, 2, 3, 0);

//:TODO: Add in window for command-line options.
//  fOptionsButton = new TGTextButton(fF1, " Options ", B_OTHER_OPTIONS);
//  fOptionsButton->Associate(this);
//  fF1->AddFrame(fOptionsButton,fL1);

    fRunButton = new TGTextButton(fF1, " Run Monitor ", B_RUN_MONITOR);
    fRunButton->Associate(this);
    fF1->AddFrame(fRunButton,fL1);

//:TODO: Add in Pause button.
    fPauseButton = new TGTextButton(fF1, " Pause Monitor ", B_PAUSE_MONITOR);
    fPauseButton->Associate(this);
    fF1->AddFrame(fPauseButton,fL1);

    fExitButton = new TGTextButton(fF1, " Exit Monitor ", B_EXIT_MONITOR);
    fExitButton->Associate(this);
    fF1->AddFrame(fExitButton,fL1);

    //---------- Add picture at right (as large inert button)
    //---------- Look for documentation-type files in directory specified 
    //           in $DMTHTMLIN.  If not set, look for ~ops/pars directory
    //           at sites (/export/home/ops/pars).  Finally, check in local 
    //           directory.
    std::string file_name; 
    const char* htmldir = getenv("DMTHTMLIN");
    if (htmldir) {
      file_name = string(htmldir) + "/";
    } else {
      ifstream test("/export/home/ops/pars/splash.xpm");
      if (!test) {
	;  //----- file not found
      } else {
	file_name = "/export/home/ops/pars/";  //----- file found
      }
      test.close();
    }
    file_name += "splash.xpm";
    fL2 = new TGLayoutHints(kLHintsTop | kLHintsLeft, 2, 2, 2, 2);
    fPictureButton = new TGPictureButton(fF2,fClient->GetPicture(file_name.c_str()));
    fPictureButton->Associate(this);
    fF2->AddFrame(fPictureButton,fL2);
/*
    std::string file_name; 
    const char* htmldir = getenv("DMTHTMLIN");
    if (htmldir) {
      file_name = string(htmldir) + "/";
    }
    file_name += "splash.xpm";
    fL2 = new TGLayoutHints(kLHintsTop | kLHintsLeft, 2, 2, 2, 2);
    fPictureButton = new TGPictureButton(fF2,fClient->GetPicture(file_name.c_str()));
    fPictureButton->Associate(this);
    fF2->AddFrame(fPictureButton,fL2);
*/

    //---------- set layout 
    SetWindowName("RayleighMonitor");
    MapSubwindows();
    Resize(GetDefaultSize());
//  Resize(200, 150);
    MapWindow();
}


MainDialog::~MainDialog()
{
    //---------- Delete all created widgets.
    delete fMenuBarLayout;
    delete fMenuBarItemLayout;
    delete fMenuBarHelpLayout;
    delete fMenuBar;
//  delete fMenuFile;
    delete fMenuHelp;
    delete fF1;
    delete fF2;
    delete fL1;
    delete fL2;
    delete fPictureButton;
    delete fConfigButton;
//  delete fOptionsButton;
    delete fRunButton;
    delete fPauseButton;
    delete fExitButton;
}


void MainDialog::CloseWindow()
{
    // Got close message for this MainFrame.  Returns from the 
    // TApplication event loop without closing the window.  
    // This behaviour is set by the argument in TApplication::Run().

    gApplication->Terminate(0);
}


bool MainDialog::IsPauseRequested()           
{
    // Returns boolean stating if pause was requested in GUI.
    return true;
}


bool MainDialog::IsExitRequested()           
{
    // Returns boolean stating if exit was requested in GUI.
    return exit; 
}


Bool_t 
MainDialog::ProcessMessage(Long_t msg, Long_t parm1, Long_t)
{
    //---------- Handle messages send to the MainDialog object 
    //           (menu selection and button messages).
    switch (GET_MSG(msg)) {
      case kC_COMMAND:
        switch (GET_SUBMSG(msg)) {
          //---------- A button is pressed.
          case kCM_BUTTON:
            switch (parm1) {
              case B_CONFIGURE_MONITOR:
                new ConfigDialog(fClient->GetRoot(), this);
                break;
              case B_OTHER_OPTIONS:
                break;
              case B_RUN_MONITOR:
                gApplication->Terminate(0);  // pass execution back to monitor
                break;
              case B_PAUSE_MONITOR:
                new MessageDisplay(fClient->GetRoot(), this, "RayleighPause.txt");
                break;
              case B_EXIT_MONITOR:
                exit = true;          // bool passed to monitor calls finish()
                gApplication->Terminate(0);  // pass execution back to monitor
                break;
            }
            break;
          //---------- A menu is selected. 
          case kCM_MENU:
            switch (parm1) {
/*
              //---------- open file 
              //           (braces below are necessary; don't know why)
              case M_FILE_OPEN:
                {              
                  static TString dir(".");
                  TGFileInfo fi;
                  fi.fFileTypes = filetypes;
                  fi.fIniDir    = StrDup(dir);
                  new TGFileDialog(fClient->GetRoot(), this, kFDOpen, &fi);
                  printf("Open file: %s (dir: %s)\n", fi.fFilename, fi.fIniDir);
                  dir = fi.fIniDir;
                }
                break;
              //---------- save file
              case M_FILE_SAVE:
                printf("M_FILE_SAVE\n");
                break;
              //---------- print 
              case M_FILE_PRINT:
                printf("M_FILE_PRINT\n");
                printf("Hiding, select \"Print Setup...\" to enable again\n");
                fMenuFile->HideEntry(M_FILE_PRINT);
                break;
              //---------- print setup 
              case M_FILE_PRINTSETUP:
                printf("M_FILE_PRINTSETUP\n");
                printf("Enabling \"Print\"\n");
                fMenuFile->EnableEntry(M_FILE_PRINT);
                break;
              //---------- exit/run monitor
              case M_FILE_EXIT:
                CloseWindow();   // this also terminates theApp
                break;
*/
              //---------- help request: documentation         
              case M_HELP_CONTENTS:
                new MessageDisplay(fClient->GetRoot(), this, "RayleighHelp.txt");
                break;
              //---------- help request: about this version    
              case M_HELP_ABOUT:
                new AboutDialog(fClient->GetRoot(), this);
                break;
              default:
                break;
            }
          default:
            break;
        }
      default:
        break;
    }
    return kTRUE;
}

//===========================================================================
//
//          Configuration Dialog class
//
//===========================================================================

//====================================== RayleighMonitor Configuration Dialog


//---------- Set labels and defaults for Stride, N, MaxStride entry widgets
const char *const ConfigDialog::numlabel[3] = {
   "Stride (sec):",
   "Number of Averages:",
   "Maximum Number of Strides:",
};

const Double_t ConfigDialog::numinit[3] = { 1.0, 10, 9999999 };

/* For integer i from 0..4, (TGNumberFormat::EStyle) i evaluates to 
  0 kNESInteger  - zero decimal place
  1 kNESRealOne  - one decimal place
  2 kNESRealTwo  - etc.
  3 kNESRealThree 
  4 kNESRealFour 
  5 kNESReal     - arbitrary re*/


ConfigDialog::ConfigDialog(const TGWindow* p, const TGWindow* main)
 : TGTransientFrame(p, main, 10, 10, kHorizontalFrame)
{
    //---------- Build vertical array of 3 numerical-entry widgets
    fF1 = new TGVerticalFrame(this, 400, 300);
    fL1a = new TGLayoutHints(kLHintsTop | kLHintsLeft, 2, 2, 2, 2);
    AddFrame(fF1, fL1a);
    fL2 = new TGLayoutHints(kLHintsCenterY | kLHintsRight, 2, 2, 2, 2);
    for (int i = 0; i < 3; i++) {
      fF[i] = new TGHorizontalFrame(fF1, 200, 30);
      fF1->AddFrame(fF[i], fL2);
      if (i) {
        fNumericEntries[i] = new TGNumberEntry(fF[i], numinit[i], 12, i + 20,
                                               (TGNumberFormat::EStyle) 0);
      } else {
        fNumericEntries[i] = new TGNumberEntry(fF[i], numinit[i], 12, i + 20,
                                               (TGNumberFormat::EStyle) 5);
      }
      fNumericEntries[i]->Associate(this);
      fF[i]->AddFrame(fNumericEntries[i], fL2);
      fLabel[i] = new TGLabel(fF[i], numlabel[i]);
      fF[i]->AddFrame(fLabel[i], fL2);
    }

    //---------- Prepare list of channels according to site.
    //
    // This code taken from STEVE PENN's BicoMon Monitor, June 11 2002 version.
    //
    // Form string of channel names and rates for the channel selector widget
    // - Routine sets up a temporary DACC, extracts a frame, iterates through
    //     the channels, grabs the names and rates, puts them in a structure.
    //
    // - This must be done in the constructor so as not to interfere with
    //   the DACC created by EXEROOT.
    //
    // WARNING:  It's not clear to me that calling these Frame objects 
    // will be okay one the monitor is already running.  Test this.
    //
    //----------------------------------  Get an input file name.
    string infile = env_str("DMTINPUT");
    if (infile.empty()) {
       infile = env_str("LIGOSMPART");
       if (!infile.empty()) infile.insert(0, "/online/");
    }

    DaccIn tempDacc;
    tempDacc.setTOCMode(false);
    tempDacc.addFile(infile);
    tempDacc.nextFrame();
    frameh_pointer tempFrame(tempDacc.getFrame());
    if (!tempFrame) {
      cerr << "RayleighMonitor: Unable to read frame for dictionary" << endl;
      return;
    }

    //-----  Get the ADC raw data
    frrawdata_pointer raw(tempFrame->GetRawData());

    if (!raw) {
      cerr << "RayleighMonitor: No raw data in frame." << endl;
      return;
    }

//  ligogui::ChannelEntry *chanNames = new ligogui::ChannelEntry[2000];
//  int chanTotal = 0 ;
// ****************** Change this *************************************
// ****************** Use TOC - DaccApi????
    size_t chanAlloc = 2000;
    chanNames = new ChannelEntry[chanAlloc];
    chanTotal = 0 ;


    for (FrRawData::const_firstAdc_iterator i = raw->RefFirstAdc().begin() ;
        i != raw->RefFirstAdc().end() ; ++i)
    {
      string name = (*i)->GetName();
      double rate = (*i)->GetSampleRate();

      if (rate > 16) {
         chanNames[chanTotal].SetName(name.c_str());
         chanNames[chanTotal].SetRate(float(rate));
         chanTotal = chanTotal + 1;
      }
    }
    ChannelTree::SortChannelList(chanNames, chanTotal);
    // End of STEVE PENN's code.

    //---------- Add vertical set of channel-selection widgets 
    fTextFrame = new TGCompositeFrame(this, 300, 220, kVerticalFrame |
                 kSunkenFrame);
    fChnLabel = new TGLabel(fTextFrame,"Active      Channel                                      Low Freq.         High Freq. ");
    fTextFrame->AddFrame(fChnLabel);
    for (int i=0; i<MAX_NUM_CHANNELS; i++) { 
      fChnData[i] = new TGCompositeFrame(fTextFrame, 200, 20, kHorizontalFrame);
      fChn[i] = new TLGChannelCombobox (fChnData[i], 11, chanNames, chanTotal, 
					kTRUE, kChannelTreeShowRate, kTRUE);
      fChn[i]->SetPopupHeight(200);
      fChn[i]->Resize(200, 22);
      fChn[i]->Associate(this);
      fChnCheck[i] = new TGCheckButton(fChnData[i], 
                             new TGHotString("     "), -1);
//    fLowFrequency[i] = new TGNumberEntry(frame* , float default #, int width,
//                           int ???, (TGNumberFormat::EStyle) 1);
      fLowFrequency[i] = new TGNumberEntry(fChnData[i], 0.0, 10, 0,
                             (TGNumberFormat::EStyle) 0);
      fHighFrequency[i] = new TGNumberEntry(fChnData[i], 10000.0, 10, 0,
                             (TGNumberFormat::EStyle) 0);
    }
    fL1b = new TGLayoutHints (kLHintsCenterX | kLHintsTop, 2, 2, 5, 5);
    for (int i=0; i<MAX_NUM_CHANNELS; i++) {
      fChnData[i]->AddFrame(fChnCheck[i]);
      fChnData[i]->AddFrame(fChn[i]);
      fChnData[i]->AddFrame(fLowFrequency[i]);
      fChnData[i]->AddFrame(fHighFrequency[i]);
      fTextFrame->AddFrame(fChnData[i]);
    }
//  fTextFrame->Resize(fChnData[0]->GetDefaultWidth()+40,fTextFrame->GetDefaultHeight()+40);
    fF1->AddFrame(fTextFrame);

    //---------- Add "Set Parameters", "Retrieve Last Configuration", 
    //           and "Close Window" buttons at right.
    fF2 = new TGVerticalFrame(this, 200, 500);
    fL3 = new TGLayoutHints(kLHintsTop | kLHintsExpandX, 2, 2, 2, 2);
    AddFrame(fF2, fL3);
    fSetButton = new TGTextButton(fF2, " Set Parameters ", B_CONFIG_SET);
    fSetButton->Associate(this);
    fF2->AddFrame(fSetButton, fL3);
    fGetButton = new TGTextButton(fF2, " Retrieve Last Parameters ", B_CONFIG_RETRIEVE);
    fGetButton->Associate(this);
    fF2->AddFrame(fGetButton, fL3);
    fHelpButton = new TGTextButton(fF2, " Help ", B_CONFIG_HELP);
    fHelpButton->Associate(this);
    fF2->AddFrame(fHelpButton, fL3);
    fExitButton = new TGTextButton(fF2, " Close Window ", B_CONFIG_CLOSE);
    fExitButton->Associate(this);
    fF2->AddFrame(fExitButton, fL3);

    //-------------------- Don't screw with the rest of this:

    //---------- set dialog box title
    SetWindowName("RayleighMonitor Configuration");
    SetIconName("RayleighMonitor Configuration");
    //SetClassHints("NumberEntryDlg", "NumberEntryDlg");

    //---------- resize & move to center
    MapSubwindows();
    UInt_t width = GetDefaultWidth();
    UInt_t height = GetDefaultHeight();
    Resize(width, height);
    Int_t ax;
    Int_t ay;
    if (main) {
      Window_t wdum;
      gVirtualX->TranslateCoordinates(
                main->GetId(), GetParent()->GetId(),
                (Int_t)(((TGFrame *) main)->GetWidth() - fWidth) >> 1,
                (Int_t)(((TGFrame *) main)->GetHeight() - fHeight) >> 1, 
                ax, ay, wdum
      );
    } else {
      UInt_t root_w, root_h;
      gVirtualX->GetWindowSize(fClient->GetRoot()->GetId(), ax, ay,
                               root_w, root_h);
      ax = (Int_t)(root_w - fWidth) >> 1;
      ay = (Int_t)(root_h - fHeight) >> 1;
    }
    //:KLUDGE: +300 moves config window down screen so can grasp window bar.
    Move(ax, ay+300);
    SetWMPosition(ax, ay);

    //---------- make the message box non-resizable
    SetWMSize(width, height);
    SetWMSizeHints(width, height, width, height, 0, 0);
    SetMWMHints(kMWMDecorAll | kMWMDecorResizeH | kMWMDecorMaximize |
               kMWMDecorMinimize | kMWMDecorMenu,
               kMWMFuncAll | kMWMFuncResize | kMWMFuncMaximize |
               kMWMFuncMinimize, kMWMInputModeless);

    MapWindow();
    
    //---------- Must close dialog before execution returns to main window.
    fClient->WaitFor(this);
}

//======================================  ConfigDialog destructor.
ConfigDialog::~ConfigDialog()
{
    //---------- Be careful to delete contents of frames BEFORE 
    //           deleting the frames themselves!
    for (int i = 0; i < 3; i++) {
      delete fNumericEntries[i];
      delete fLabel[i];
      delete fF[i];
    }
    for (int i=0; i<MAX_NUM_CHANNELS; i++) {
      delete fChn[i];
      delete fChnCheck[i];
      delete fLowFrequency[i];
      delete fHighFrequency[i];
      delete fChnData[i];
    }
    delete fChnLabel;
    delete fTextFrame;
    delete fSetButton;
    delete fGetButton;
    delete fHelpButton;
    delete fExitButton;
    delete fF1;
    delete fF2;
    delete fL1a;
    delete fL2;
    delete fL3;
    delete fL1b;
}

//======================================  ConfigDialog set parameters.
void ConfigDialog::SetParameters()
{
    const char* chn;
    int rate=0;

    //---------- Read configuration parameters.
    Stride = fNumericEntries[0]->GetNumber();
    N = ((int) fNumericEntries[1]->GetNumber());
    MaxStride = ((int) fNumericEntries[2]->GetNumber());
    number_of_channels = 0;
    for (int i=0; i<MAX_NUM_CHANNELS; ++i) {
      if (fChnCheck[i]->GetState() == kButtonDown) number_of_channels++;
    }

/*
    //---------- Dump configuration parameters to screen.
    std::cout <<    "Stride = " << Stride << "  <br>" << std::endl;
    std::cout <<         "N = " << N << "  <br>" << std::endl;
    std::cout << "MaxStride = " << MaxStride << "  <br>" << std::endl;
    std::cout << "number_of_channels = " << number_of_channels;
    std::cout << "  <br>" << std::endl;
    std::cout << "Channels Selected:  " << std::endl;
    for (int i=0; i<MAX_NUM_CHANNELS; i++) { 
      if (fChnCheck[i]->GetState() == kButtonDown) {
        chn = fChn[i]->GetChannel();
        std::cout << (chn ? chn : "--none--");
        std::cout << " " << fLowFrequency[i]->GetNumber() << "  ";
        std::cout << fHighFrequency[i]->GetNumber() << std::endl;
      }
    }
*/

    //---------- Output parameters to a configuration file 
    //           TODO:  SHOULD MOVE THIS INTO RayleighConfig.hh; 
    //           GUI should not have to know internal details of 
    //           how RayleighConfig works.
    FILE *output;
    if ( (output=fopen("RMconfig.txt","w")) == NULL ) {
      std::cerr << "ERROR: Cannot write config file.  Exiting.<br>\n";
      exit(0);    // Monitor ends with segmentation fault (and core dump).
    }
    fprintf(output, "%f\n", Stride);
    fprintf(output, "%d\n", N);
    fprintf(output, "%d\n", MaxStride);
    fprintf(output, "%d\n", number_of_channels);
    for (int i=0; i<MAX_NUM_CHANNELS; i++) { 
      if (fChnCheck[i]->GetState() == kButtonDown) {
        chn = fChn[i]->GetChannel();
        for (int j=0; j<chanTotal; j++) {
          if ( !strcmp(chanNames[j].Name(),chn) ) rate = ((int) chanNames[j].Rate());
        }
        fprintf(output, "%s %d %f %f \n", chn, rate, 
               fLowFrequency[i]->GetNumber(), 
               fHighFrequency[i]->GetNumber());
      }
    }
    fclose(output);  
}


void ConfigDialog::GetParameters()
{
    //---------- Retrieve settings from current configuration file. 
    RayleighConfig* parameters;
    parameters = new RayleighConfig("RMconfig.txt"); 

    fNumericEntries[0]->SetNumber(parameters->Stride);
    fNumericEntries[1]->SetNumber(parameters->N);
    fNumericEntries[2]->SetNumber(parameters->MaxStride);
    //:TODO: Fix up this error procedure.
    if (parameters->number_of_channels > MAX_NUM_CHANNELS) 
      cout << "ERROR: Too many channels in RMconfig.txt\n";
    for (int j=0; j<parameters->number_of_channels; ++j) {
      fChnCheck[j]->SetState(kButtonDown);
      fChn[j]->SetChannel(parameters->channel_names[j]); 
      fLowFrequency[j]->SetNumber(parameters->f_lower[j]);
      fHighFrequency[j]->SetNumber(parameters->f_upper[j]);
    }
    for (int j=parameters->number_of_channels; j<MAX_NUM_CHANNELS; ++j) {
      fChnCheck[j]->SetState(kButtonUp);
    }
}

//======================================  ConfigDialog close window
void 
ConfigDialog::CloseWindow()
{
    delete this;
}


Bool_t 
ConfigDialog::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{
    switch (GET_MSG(msg)) {
      case kC_COMMAND:
        switch (GET_SUBMSG(msg)) {
          case kCM_BUTTON:
            switch (parm1) {
              //---------- set button
              case B_CONFIG_SET:
                SetParameters();
                break;
              //---------- retrieve button
              case B_CONFIG_RETRIEVE:
                GetParameters();
                break;
              //---------- help button
              case B_CONFIG_HELP:
                new MessageDisplay(fClient->GetRoot(), this, "RayleighConfigHelp.txt");
                break;
              //---------- exit button
              case B_CONFIG_CLOSE:
                CloseWindow();
                break;
            }
            break;
        }
        break;
    }
    return kTRUE;
}



//===========================================================================
//
//          About Dialog class
//
//===========================================================================

//======================================   AboutDialog: Source of Help > About 
AboutDialog::AboutDialog(const TGWindow * p, const TGWindow * main)
 : TGTransientFrame(p, main, 10, 10, kHorizontalFrame)
{
    //-------- Look for documentation-type files in directory specified 
    //         in $DMTHTMLIN instead of in local directory.
    std::string file_name; 
    const char* htmldir = getenv("DMTHTMLIN");
    if (htmldir) {
      file_name = string(htmldir) + "/";
    } else {
      ifstream test("/export/home/ops/pars/about.xpm");
      if (!test) {
	;  //----- file not found
      } else {
	file_name = "/export/home/ops/pars/";  //----- file found
      }
      test.close();
    }
    file_name += "about.xpm";

    //---------- Build window with inert picture button and close button
    fF1 = new TGVerticalFrame(this, 400, 300);
    fL1 = new TGLayoutHints (kLHintsCenterX | kLHintsTop, 2, 2, 2, 2);
//  fPictureButton = new TGPictureButton(fF1,fClient->GetPicture("about.xpm"));
    fPictureButton = new TGPictureButton(fF1,fClient->GetPicture(file_name.c_str()));
    fPictureButton->Associate(this);
    fF1->AddFrame(fPictureButton,fL1);
    fCloseButton = new TGTextButton(fF1, " Close Window ", 1);
    fCloseButton->Associate(this);
    fF1->AddFrame(fCloseButton, fL1);
    AddFrame(fF1, fL1);

    //-------------------- Don't screw with the rest of this:

    //---------- set dialog box title
    SetWindowName("RayleighMonitor: About"); 
    SetIconName("RayleighMonitor: About");  

    //---------- resize & move to center
    MapSubwindows();
    UInt_t width = GetDefaultWidth();
    UInt_t height = GetDefaultHeight();
    Resize(width, height);
    Int_t ax;
    Int_t ay;
    if (main) {
      Window_t wdum;
      gVirtualX->TranslateCoordinates(
                main->GetId(), GetParent()->GetId(),
                (Int_t)(((TGFrame *) main)->GetWidth() - fWidth) >> 1,
                (Int_t)(((TGFrame *) main)->GetHeight() - fHeight) >> 1,
                ax, ay, wdum
      );
    } else {
      UInt_t root_w, root_h;
      gVirtualX->GetWindowSize(fClient->GetRoot()->GetId(), ax, ay,
                               root_w, root_h);
      ax = (Int_t)(root_w - fWidth) >> 1;
      ay = (Int_t)(root_h - fHeight) >> 1;
    }
    //---------- position relative to the parent's window
    //:KLUDGE: +300 moves config window down screen so can grasp window bar.
    //Move(ax, ay+300);
    SetWMPosition(ax, ay);

    //---------- make the message box non-resizable
    SetWMSize(width, height);
    SetWMSizeHints(width, height, width, height, 0, 0);
    SetMWMHints(kMWMDecorAll | kMWMDecorResizeH | kMWMDecorMaximize |
               kMWMDecorMinimize | kMWMDecorMenu,
               kMWMFuncAll | kMWMFuncResize | kMWMFuncMaximize |
               kMWMFuncMinimize, kMWMInputModeless);

    MapWindow();
    fClient->WaitFor(this);

}

//======================================  About dialog destructor
AboutDialog::~AboutDialog()
{
    delete fF1;
    delete fL1;
    delete fPictureButton;
    delete fCloseButton;
}


void AboutDialog::CloseWindow() {
    delete this;
}


Bool_t AboutDialog::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{
    switch (GET_MSG(msg)) {
      case kC_COMMAND:
        switch (GET_SUBMSG(msg)) {
          case kCM_BUTTON:
            switch (parm1) {
              //---------- close window button
              case 1:
                CloseWindow();
                break;
              default:
                break;
            }
            break;
          default:
            break;
        }
        break;
      default:
        break;
    }
    return kTRUE;
}

//===========================================================================
//
//          Main Dialog clas:s Configuration Help Dialog source code
//
//===========================================================================

//========================= MessageDisplay constructor
MessageDisplay::MessageDisplay(const TGWindow *p, const TGWindow *main, 
    const char* textfile) : TGTransientFrame(p, main, 10, 10, kHorizontalFrame)
{
    //---------- Look for documentation-type files in directory specified 
    //           in $DMTHTMLIN instead of in local directory.
    std::string file_name; 
    const char* htmldir = getenv("DMTHTMLIN");
    if (htmldir) {
      file_name = string(htmldir) + "/";
    } else {
      std::string file_name_temp;
      file_name_temp = "/export/home/ops/pars/";
      file_name_temp += textfile;
      ifstream test(file_name_temp.c_str());
      if (!test) {
	;  //----- file not found
      } else {
	file_name = "/export/home/ops/pars/";  //----- file found
      }
      test.close();
    }
    file_name += textfile; 

    //---------- Display a configuration help message.
    fF1 = new TGVerticalFrame(this, 500, 400);
    fL1 = new TGLayoutHints (kLHintsCenterX | kLHintsTop, 2, 2, 2, 2);
    AddFrame(fF1,fL1);
    fHelpView = new TGTextView(fF1, 500, 400);
//  fHelpView->LoadBuffer(txt);
//  fHelpView->LoadFile(textfile);
    fHelpView->LoadFile(file_name.c_str());
    fHelpView->AdjustWidth();
    fF1->AddFrame(fHelpView,fL1);

    //---------- Add Close Window button.
    fCloseButton = new TGTextButton(fF1, " Close Window ", B_CONFIGHELP_CLOSE);
    fCloseButton->Associate(this);
    fF1->AddFrame(fCloseButton,fL1);

    MapSubwindows();

    Resize(GetDefaultSize());

    //---------- position relative to the parent's window
    Window_t wdum;
    int ax, ay;
    //---------- should cover lower-right quarter of parent window
    gVirtualX->TranslateCoordinates(main->GetId(), GetParent()->GetId(),
        0,
        (Int_t)(((TGFrame *) main)->GetHeight() - fHeight) >> 1,
        ax, ay, wdum);
    //:TODO: Fix positioning; this is all screwed up
    Move((((TGFrame *) main)->GetWidth() >> 1) + ax, 
         (((TGFrame *) main)->GetHeight() >> 1) + ay);
    SetWMPosition((((TGFrame *) main)->GetWidth() >> 1) + ax, 
         (((TGFrame *) main)->GetHeight() >> 1) + ay);

    MapWindow();
    fClient->WaitFor(this);
}


MessageDisplay::~MessageDisplay()
{
    delete fF1;
    delete fL1;
    delete fHelpView;
    delete fCloseButton;
}


void MessageDisplay::CloseWindow()
{
    delete this;
}


Bool_t 
MessageDisplay::ProcessMessage(Long_t msg, Long_t, Long_t)
{
    //---------- Process Close button.
    switch (GET_MSG(msg)) {
      case kC_COMMAND:
        switch (GET_SUBMSG(msg)) {
          case kCM_BUTTON:
            //---------- Only button is to close
            CloseWindow();
            break;
          default:
            break;
        }
        break;
      default:
        break;
    }
    return kTRUE;
}
