/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "PSLTool.hh"
#include "OperStateCondList.hh"
#include "SegAccountant.hh"

using namespace std;
using namespace trig;

//=======================================  Constructor
PSLTool::PSLTool(const std::string& name, const PSLChan* chan) 
  : mName(name), mChan(chan), mDebug(0), mAlarmEnable(false), 
    mTrigEnable(false)
{}

PSLTool::~PSLTool(void) {}

//=======================================  Send a trigger to TrigMgr
void 
PSLTool::sendTrigger(TrigClient& tc) {
}

//=======================================  Send a trigger to TrigMgr
void 
PSLTool::configSegment(SegAccountant& tc) {
}

//=======================================  Send a trigger to TrigMgr
void 
PSLTool::sendSegment(SegAccountant& tc) {
}

//=======================================  Set the alarm enable flag.
void 
PSLTool::setAlarmEnable(bool yorn) {
    mAlarmEnable = yorn;
}

//=======================================  Set the alarm enable flag.
void 
PSLTool::setComment(const string& c) {
    mComment = c;
}

//=======================================  Set the enable condition name.
void 
PSLTool::setDebug(int dbg) {
    mDebug = dbg;
}

//=======================================  Set the enable condition name.
void 
PSLTool::setEnableCond(const std::string& cond) {
    mEnableCond = cond;
}

//=======================================  Set the trigger enable flag.
void 
PSLTool::setTrigEnable(bool yorn) {
    mTrigEnable = yorn;
}

//=======================================  Test enable condition, if available.
bool 
PSLTool::testCondition(OperStateCondList& osc) const {
    if (mEnableCond.empty()) return true;
    return osc.satisfied(mEnableCond.c_str());
}
