/***************************************************************************
    File        : WhiteningFilter.h
    Description : implementes the class WhiteningFilter
 ---------------------------------------------------------------------------
    Begin       : Mon Sep 3 2001
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#include "WhiteningFilter.h"


// Method filter
//   Computes the whitening filter
//   based on the psd and the noise floor
//   which is calculated using the running median
bool
gwd::WhiteningFilter::ComputeFilter(const unsigned int fOrder,const unsigned int noOfFreq,const unsigned int rmWindow,
                                    Vector& signal,Vector& filter)
{ 
  // Sizes: signal has to be larger than two times
  // the number of frequencies used in the psd due
  // to the fft
  if (noOfFreq > 2*signal.size())
  {
    Singleton* single = Singleton::exemplar();
    single->AppendMessage("gwd::WhiteningFilter::ComputeFilter(): more frequencies in the psd than twice the input signal size");
    return false;
  }
  
  // Compute the power spectrum
  Vector psdData;
  PowerSpectrum psd;
  
  // The power spectrum
  const double overlap = 0.5; // overlap segments by 50%
  if (!psd.WelchPowerSpectrumDensity(noOfFreq+rmWindow,overlap,signal,psdData))
  {
    Singleton* single = Singleton::exemplar();
    single->AppendMessage("gwd::WhiteningFilter::ComputeFilter(): can't compute the psd");
    return false;
  }
  
  // Compute the Running median of the psd
  Vector rmData;
  gwd::RunningMedian rm;
  rm.ComputeMedians(rmWindow,psdData,rmData);
  // Compute the filter coefficients
  std::vector<Complex> fData(rmData.size());
  for (std::vector<Complex>::size_type nn = 0; nn < fData.size(); nn++)
  {
    fData[nn] = 1./sqrt(rmData[nn]);
    if (fabs(rmData[nn]) < gwd::epsilon)
    {
      Singleton* single = Singleton::exemplar();
      single->AppendMessage("gwd::WhiteningFilter::ComputeFilter(): running median of psd < epsilon, dividing by zero");
      return false;
    }
  }

    
  // Window Filter Desing
  WindowFilterDesign wfd;
  wfd.ComputeFilter(fOrder,fData,filter);

  return true;
} // filter()


