//#############################################################################
//#  IRIG-B signal decoder program    v0.0
//#  
//#  By:   Szabi Marka, 2001
//#
//#############################################################################


#include "IRIG-B.hh"

#ifndef __CINT__

#define PIDCVSHDR "$Header: https://redoubt.ligo-wa.caltech.edu/svn/gds/trunk/Monitors/IRIG-B/IRIG-B.cc 7438 2015-08-04 11:18:05Z john.zweizig@LIGO.ORG $"
#define PIDTITLE  "IRIG-B Timing Signal Check"
#include "ProcIdent.hh"
#include <iostream>
#include <fstream>
#include <sstream>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include "Time.hh"
#include "TSeries.hh"
#include "FSeries.hh"
#include "Dacc.hh"

#include "DVecType.hh"
#include <string.h>
#include <cstdlib>
#include "FixedLenTS.hh"


//-------------------------------------- 

EXECDAT(IrigB)
#endif               // !def(__CINT__)

std::string Ch;  // Name of input channel 
std::string WebDir;
std::string LogDir;
std::string COMM;
int  ct = 0, wc=0;
std::string trend   = "WrongCommandLineArgument";
bool Epics       = false;

static const Interval HalfSec(0.51);
int LeapSeconds      = 1;   // Do use GDS leapsecond correction (i.e., LeapSeconds>0)
int LeapSecondsCorr  = -15; // 13 leapseconds are already taken into account at the clock distribution system at LLO
//int UTC_Corr         = 6; // LLO has local time in the IRIG-B code prior to S5
int UTC_Corr         = 0; // LLO has UTC time in the IRIG-B code for S5

using namespace std;

inline void
env_to_str(std::string& s, const char* e, const char* def="") {
  const char* ev = getenv(e);
  if (ev) {
    s = ev;
  } else {
    s = def;
  }
}

IrigB::IrigB(int argc, const char *argv[])                     // IrigB  constructor
  : DatEnv(argc, argv),
    MonServer("IRIGB_Serv"),
    MaxFrame(999999999), 
    mTrendMinute("IRIGBMinuteTrend", Trend::kMinute, 720),
    mAlarm("IRIGB")
{
  std::string ChFile = "X";                      // Name of input file   

  env_to_str(WebDir, "DMTHTMLOUT");
  if (!WebDir.empty() && WebDir[WebDir.size()-1] != '/') WebDir += "/";
  WebDir += "index.html";

  env_to_str(LogDir, "HOME");
  if (!LogDir.empty() && LogDir[LogDir.size()-1] != '/') LogDir += "/";
  WebDir += "log/IRIGB.log";

  std::string LXO;
  env_to_str(LXO, "LIGOSITE", "LLO"); 
  if (LXO != "LLO" && LXO != "LHO") {
    cerr << LXO << " cannot be identified as LIGO site! " << endl 
	 << "Check the $LIGOSITE environmental variable" << endl;
    exit(0);
  }
#ifdef DEBUG_IRIGB
  cout << "LIGO Site identified : " << LXO << endl;
#endif

  Ch = "L1:CAL-PCALX_IRIGB_OUT_DQ";
  if (LXO == "LHO") {
    Ch = "H1:CAL-PCALX_IRIGB_OUT_DQ";
    LeapSecondsCorr  = 0; // Leapseconds are not taken into account in hardware at LHO, so no correction is necessary
    UTC_Corr         = 0; // LHO has UTC time in the IRIG-B code
  }

#ifdef DEBUG_IRIGB
  cout << "Usage: Irig-B \n"  
       << "        [optional -h provides this help \n"
       << "        [optional -e switch ON epics communication \n"
       << "        [optional -c <channel name>] \n" 
       << "        [optional -t <trend output channel name>] \n"
       << "        [optional -f (read from file) <filename> Don't forget the quotes!] \n" 
       << "        [optional -n N maximum number of frames to read]\n" 
       << "        [optional -w Web output directory] "
       << "        [optional -l Log output directory/file] "
       << endl;
#endif  
    for (int i=1 ; i<argc ; i++) {
        string argi = argv[i];
        if (argi == "-h") {
           cout << "Usage: Irig-B \n" 
		<< "        [optional -h provides this help \n"
                << "        [optional -e switch ON epics communication \n"
		<< "        [optional -c <channel name>] \n" 
		<< "        [optional -t <trend output channel name>] \n"
		<< "        [optional -f (read from file) <filename>] \n" 
		<< "        [optional -n N maximum number of frames to read]\n" 
		<< "        [optional -w Web output directory/file] " 
		<< "        [optional -l Log output directory/file] "
		<< endl;
	   exit(0);
	}
        if (argi == "-e") {
	  Epics = true;
#ifdef DEBUG_IRIGB
    cout << "Epics communication is ON! " << endl;
#endif
	}
        if (argi == "-c") {
	    Ch = argv[++i];
#ifdef DEBUG_IRIGB
    cout << "Channel loaded from command line : " << Ch << endl;
#endif
	}
        if (argi == "-t") {
	    trend = argv[++i];
#ifdef DEBUG_IRIGB
    cout << "Output trend channel loaded from command line : " << trend << endl;
#endif
	}
        if (argi == "-n") {
	    MaxFrame = strtol(argv[++i], 0, 0);
#ifdef DEBUG_IRIGB
    cout << "Maximum number of frames loaded from command line : " <<  MaxFrame << endl;
#endif
	} 
        if (argi == "-f") {
	    ChFile = argv[++i];
	    getDacc().close();
	    getDacc().addPath(ChFile);
#ifdef DEBUG_IRIGB
    cout << "Frames are loaded from : " << ChFile  << endl;
#endif
	}
        if (argi == "-w") {
	    WebDir = argv[++i];
#ifdef DEBUG_IRIGB
    cout << "Web output is going to : " << WebDir  << endl;
#endif
	} 
        if (argi == "-l") {
	    LogDir = argv[++i];

#ifdef DEBUG_IRIGB
    cout << "Log output is going to : " << LogDir  << endl;
#endif
	} 
    }
#ifdef DEBUG_IRIGB
    cout << "Irig-B channel watched : " << Ch << "\n\n===========================\n\n" << endl;
#endif
    getDacc().setStride(2.0);                                  // Set the time step to 1 seconds
    getDacc().addChannel(Ch);                                  // Add Irig-B Channel

    mTrendMinute.addChannel(trend.c_str());
    serveData(trend.c_str(), &(mTrendMinute.find(trend.c_str()).refAvgSeries()), "IRIGB Minute Trend");
    //mTrendMinute.writeIndex();


//S--------------------- Defining the alarms
    const char* badTiming="../monitor_reports/IRIG-B/";
    AlarmData al1("IRIGB", "Timing_Is_OFF", Interval(120), 7, 
		  "Timing is bad", "");
    al1.setWebFile(badTiming);
    al1.jamFlags(AlarmData::kReTrigger);
    mAlarm.defineAlarm(al1);

    const char* NoSignal="../monitor_reports/IRIG-B/";
    AlarmData al2("IRIGB", "IRIGB_SIGNAL_IS_NOT_PRESENT", Interval(120), 7, 
		  "No IRIGB signal", "");
    al2.setWebFile(NoSignal);
    al2.jamFlags(AlarmData::kReTrigger);
    mAlarm.defineAlarm(al2);

//E--------------------- Defining the alarms

    COMM = "tail -1560 ";
    COMM += LogDir;
    COMM += " | grep -v OK | nawk '{ print $0, \"<br>\"}' >> ";
    COMM += WebDir;

#ifdef DEBUG_IRIGB
    cout << COMM << endl;
#endif
}

IrigB::~IrigB() 
{
    cout << "IrigB is finished" << endl;
}

void IrigB::Attention(void) {
  MonServer::Attention();
}

void IrigB::ProcessData(void) {                                // Decodes the time

typedef short VecType;
char  I[205];

bool  b;
int   i=0,t=0,ii=0,l=0,h=0;
int   Err=0;
int   secs=0,mins=0,hours=0,days=0;
int   sec=0,min=0,hour=0,day=0;
char  UTCtime[64];
char  da[4],ho[2],mi[2],se[2];
time_t TS;
struct tm *gmt;

float TDiff;

    ct++;
    //system("date -u");
    TSeries* tx = getDacc().refData(Ch);
	 
    tx->Convert(DVecType<VecType>::getDataType());
    VecType* g = reinterpret_cast<VecType*>(tx->refData());

    //float tsd = tx->getInterval();
    int   tsn = tx->getNSample();                                // Number of samples in the segment

// Strech instead of demodulation...

    double txAve = tx->getAverage();                             // Determine the zero offset
    double txMax = tx->getMaximum();                             // Determine the maximum
    double txMin = tx->getMinimum();                             // Determine the minimum
    double cut   = 1.13*(txMax - txMin) / ( 2.0 * 2.92 );        // Set cut threshold (10:3 -> 5)

    for (i=0; i<tsn; i++)                                        // Cut between the high sine and the low sine
       if ( fabs(g[i]-txAve) > cut ) g[i] = true;
         else g[i] = false;

    for (i=0; i<tsn; i++) {                                      // Erase the little gaps where the sines go 0...
      if (  g[i-2] &&  g[i+2] && !g[i] ) g[i]=true;
      if ( !g[i-2] && !g[i+2] &&  g[i] ) g[i]=false;   
    }
    for (i=0; i<tsn; i++) {                                      // Erase the little gaps where the sines go 0...
      if (  g[i-2] &&  g[i+2] && !g[i] ) g[i]=true;
      if ( !g[i-2] && !g[i+2] &&  g[i] ) g[i]=false;
    }
    for (i=0; i<tsn; i++) {                                      // Erase the little gaps where the sines go 0...
      if (  g[i-3] &&  g[i+3] && !g[i] ) g[i]=true;
      if ( !g[i-3] && !g[i+3] &&  g[i] ) g[i]=false;
    }
    float txChS=0;
    for (i=0; i<tsn; i++) {                                      // Erase the little gaps where the sines go 0...
      if (  g[i-1] &&  g[i+1] && !g[i] ) g[i]=true;
      if ( !g[i-1] && !g[i+1] &&  g[i] ) g[i]=false; 
      txChS+=(float)g[i];  
    }

// Verify that the signal was really a IRIG-B signal... ok sort of verify...

    txChS/=tsn; //Compute checksum (Should be between 0.2 and 0.6...)

#ifdef DEBUG_IRIGB
    cout << "\n..................................." 
    << "Time series at " << tx->getStartTime() << " with length " 
	 << tx->getNSample() 
	 << "\nSeries average: " << (int)txAve 
	 << "\nSeries Maximum: " << (int)txMax 
	 << "\nSeries Minimum: " << (int)txMin 
	 << "\nCheckSum:       " << (float)txChS 
	 << "\nCut level:      " << (int)cut
	 << "\n..................................." << endl;
#endif    


//S------------------------Generate Alarms
    lmsg::error_t rc = 0;
    AlarmHandle han;
    if ( (txChS < 0.2) || (txChS > 0.6) ) {
      ostringstream param;
      param << "Ave:" << (int)txAve 
	         << "-Max:" << (int)txMax 
	         << "-Min: " << (int)txMin  
	         << "-CheckSum:" << (float)txChS 
	         << "-CutL:" << (int)cut;
      AlarmData al("IRIGB", "IRIGB_SIGNAL_IS_NOT_PRESENT", 0, 3, "", param.str());
      rc = mAlarm.setAlarm(al, han);
		
#ifdef DEBUG_IRIGB
      cout << "Alarm is set" 
            <<  "\n..................................." 
	    << "\nSeries average: " << (int)txAve 
	    << "\nSeries Maximum: " << (int)txMax 
	    << "\nSeries Minimum: " << (int)txMin 
   	    << "\nSeries AveDiff: " << (int)(((txMax + txMin) / 2) - txAve ) 
	    << "\nCheckSum:       " << (float)txChS 
	    << "\nCut level:      " << (int)cut
	    << "\n..................................." << endl;

      if (rc) cout << "[IRIG-B] Error sending alarm: " << rc << endl;
#endif 
      }
//E------------------------Generate Alarms

// Reconstruct the bits of the time code and locate the start of the second 'P' of 'R'
    ii=0;
    h = 0;
    l = 0;
    b = false;
	 int B0 = -1000;
	 Time GT;
	 long int NanoSec;
    for (i=0; i<tsn; i++) {                                      // Pulse duty factor measurement and bit recognition	 
       if ( !g[i] ) l++;     
       if (  g[i] ) h++;
       if ( !g[i] &&  b ) b = false;	 
       if (  g[i] && !b ) {   
	       if ( ii > 202 ) {cerr << "ERROR! Start marker was not found" << endl; ii=0;goto end;}
          if ( ( ( h > 20 ) && ( l > 20 ) ) && ( h+l > 140 ) ) {
            t = (int) floor ( 100.0 * ( (float) h / (((float) l) + 0.001) ));
            I[ii] = 'E';
            if ( abs(t-100) < 30 ) I[ii] = '1';
            if ( abs(t-25)  < 10 ) I[ii] = '0';
            if ( abs(t-400) < 100) I[ii] = 'P';
#ifdef DEBUG_IRIGB
	  cout  << "Bit : " << ii << " - " << h << "/" << l << "=> " << I[ii] <<  endl;
#endif
  			   if ( (B0 < -900) && ((I[ii-1]=='P') && (I[ii]=='P'))) {	 
			     ii=0;
				  I[ii]='P';
				  B0 = i-h-l-1;
#ifdef DEBUG_IRIGB
	  cout  << "Start : " << i << " - " << ii << " : " << B0 << "=> " << B0/16384 << "###########" << endl;
#endif
			   }
			   ii++;
			 }
			 h=0;
          l=0;
          b = true; 			  
       }
    }
	 
// Takes care of proper rounding of seconds	 
	 GT= tx->getBinT(B0);
	 NanoSec = (long int) (GT.getN()/1000);
	 if (NanoSec > 500000) {
	   GT = GT + HalfSec;
		NanoSec -= 1000000;
	 }
// Update leap seconds if we have non-zero value to begin with
// This assumes the IRIG-B code does not include leap seconds
	 if (LeapSeconds > 0) LeapSeconds = LeapSecondsCorr + LeapS(GT);

// Converts to human readable time	 
#ifdef DEBUG_IRIGB	 
	 cout << "NanoSec: " << NanoSec << endl;
#endif    

      TimeStr(GT, UTCtime, "%D:%H:%N:%S");
      TimeStr(GT, da, "%D");
      day = atoi(da);
      TimeStr(GT, ho, "%H");
      hour = atoi(ho);
      TimeStr(GT, mi, "%N");
      min = atoi(mi);
      TimeStr(GT, se, "%S");
      sec = atoi(se);
	       
// Restores correct PPS edge time 			 
	 if (NanoSec > 500000) {
	   GT = GT - HalfSec;
	 }

// Checks for decoding errors (look for standard IRIG-B markers...		 
    Err=0;
    for (t=9;t<60;t+=10) if (I[t]!='P') Err=1;
    if (I[5]!='0') Err=2;
    for (t=14;t<55;t+=10) if (I[t]!='0') Err=3;
#ifdef DEBUG_IRIGB
    cout << "Error code: " << Err << endl;
#endif
    if (Err>0) {
      //cerr << "ERROR! The time code does not contain the standard separators" << Err << endl; 
      ii=0;
      goto end;
    }

#ifdef DEBUG_IRIGB
    if (Err==0) {cout << "Check Bits are Fine! " << endl;}
#endif

 // Primitive character to digit conversion...bad Szabi bad
    for (l=0; l<ii; l++) I[l]-=48;                              
    secs  = I[1]+2*I[2]+4*I[3]+8*I[4]+10*I[6]+20*I[7]+40*I[8];
    secs -= LeapSeconds;                                                  // Leap second correction 
    mins  = I[10]+2*I[11]+4*I[12]+8*I[13]+10*I[15]+20*I[16]+40*I[17];
    if (secs<0) {secs+=60; mins--;}
    hours = UTC_Corr + I[20]+2*I[21]+4*I[22]+8*I[23]+10*I[25]+20*I[26]+40*I[27];
    if (mins==-1) {mins=59; hours--;}
    days  = I[30]+2*I[31]+4*I[32]+8*I[33]+10*I[35]+20*I[36]+40*I[37]+80*I[38]+100*I[40]+200*I[41]-1;
    if (hours==-1) {
		 hours=23; 
		 days--;
		 if (days<0) days+=(day == 365 ? 366 : 365);
	    }
    if (hours > 23) {
                 hours-=24;
                 days++;
		 if (days >= (day == 365 ? 366 : 365)) {
		    days-=(day == 365 ? 366 : 365);
		 }
            }

    ii=(24*60*60)*(day-days)+(60*60)*(hour-hours)+(60)*(min-mins)+(sec-secs);            // Check whether the IRIG-B code agrees with the DAQ stamp


// Produces a report twice a minute or upon an error
    TDiff = (float)ii + (float)NanoSec/1000000.0;

    if ( fabs(TDiff) < 0.0005 ) wc++;
      else wc=40;


#ifdef DEBUG_IRIGB
    if ( abs(TDiff) < 0.0005 ) cout << "OK  ";
	       else cout << "BAD!!!!!!  ";
    cout << UTCtime << "=<" << (float)TDiff << ">=" << days << ":" << hours << ":" << mins << ":" << secs << endl;
	 
    cout << "Log is written to : " << LogDir << endl;
#endif



    if ( GT > Time(0) ) {
      mTrendMinute.trendData(trend.c_str(), GT, TDiff);
#ifdef DEBUG_IRIGB
      cout << "Trend: " << trend << " => T = " << GT << " D = " << TDiff << endl;
#endif     
    }

    if ((LogDir[0]) && (wc >= 15)) {
      ofstream LogOut(LogDir, ios::app);
      if ( fabs(TDiff) < 0.0005 ) LogOut << "OK  ";
	       else LogOut << "BAD!!!!!!  ";
      LogOut << UTCtime << "=<" << (float)TDiff << ">=" << days << ":" << hours << ":" << mins << ":" << secs << endl;
      LogOut.close();
    }

    if (!WebDir.empty() && (wc >= 15)) {
      ofstream WebOut(WebDir.c_str(), ios::out);
      wc = 0;
      time(&TS);
      gmt = gmtime(&TS);

//S----------------------------------  Generate alarms
      lmsg::error_t rc = 0;
      AlarmHandle han;
      if ( fabs(TDiff) > 0.0005 ) {
      ostringstream param;
      param << TDiff << ends;
      AlarmData al("IRIGB", "Timing_Is_OFF", 0, 7, "", param.str());
      rc = mAlarm.setAlarm(al, han);
#ifdef DEBUG_IRIGB
      cout << "Alarm is set" << endl;
      if (rc) cout << "[IRIG-B] Error sending alarm: " << rc << endl;
#endif 
      }
//E----------------------------------  Generate alarms

// Writes web output

#ifdef DEBUG_IRIGB
      cout << "Web page is written to : " << WebDir << endl;
#endif

//Head
      WebOut	<< "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n<html>\n<head> \n"
		         << "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"> \n"
		         << "<meta name=\"Author\" content=\"Szabolcs Marka / IRIG-B\"> \n"
		         << "<meta name=\"GENERATOR\" content=\"Mozilla/4.78 [en] (Win98; U) [Netscape]\"> \n"
		         << "<title>IRIG-B Timing Monitor at LXO</title> \n</head> \n";
// Body									
		WebOut   << "<body> \n<b><font color=\"#FF6600\"><font size=+2>IRIG-B timing monitor</font></font></b> \n"
		         << "<br>\n<hr SIZE=1 WIDTH=\"100%\">" << endl;
					  
      if ( fabs(TDiff) < 0.0005 ) {
	     WebOut  << "<br><b><font color=\"#00CC00\"><font size=+4>OK...</font></font></b> <br><br>" << endl;
      } else {
	       WebOut  << "<br><b><blink><font color=\"#FF0000\"><font size=+4>ERROR!!</font></font></blink></b> <br><br>" << endl;
      }
		
      WebOut	<< "<hr SIZE=1 WIDTH=\"100%\"> \n"
		         << "<br><b><tt><font color=\"#000099\"><font size=+1>DAQ time stamp&nbsp;&nbsp;&nbsp;&nbsp;: "
		         << UTCtime << " + " << (float)NanoSec/1000000.0
		         << "</font></font></tt></b>\n<br><b><tt><font color=\"#000099\"><font size=+1>IRIG-B time stamp : "
		         << days << ":" << hours << ":" << mins << ":" << secs << " + 0.000"
		         << "</font></font></tt></b>\n";
					
		WebOut	<< "<p><b><tt><font color=\"#FF0099\"><font size=+1>Difference&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: " 
		         << ii << " seconds and " << NanoSec << " microseconds</font></b>"
					<< "<br><br> (believe it on the hundreds of microseconds level for now!)"
		         << "</font></font></tt></b>\n";
// Tail					
		WebOut	<< "<br>\n<hr SIZE=1 WIDTH=\"100%\"> \n"
		         << "<br><font size=+1>This page was last modified : "
		         << asctime(localtime(&TS)) << " ( <b>" << asctime(gmtime(&TS)) << "</b>(UTC) )" 
		         << " by IRIG-B of DMT</font> \n<br><font size=-1>Contact: " 
					<< "<a href=\"mailto:smarka@ligo.caltech.edu\">Szabi Marka</a>.</font> \n"
		         << "<br><b><tt><font color=\"#000099\"><font size=+1></font></font></tt></b><br> \n" 
		         << "<hr SIZE=1 WIDTH=\"100%\"> \n"
		         << "<br><b><tt><font color=\"#FF6600\"><font size=+1>Timing errors (>=1sec) " 
					<< "during the last 13 hours : (An empty list is a good news!)" 
					<< "</font></font></tt></b><br><br>\n";

      WebOut	<< "<SCRIPT LANGUAGE=\"JavaScript\"> \n"
		         << "setTimeout(\"location.reload()\",30000) \n"
		         << "</SCRIPT>\n</body>\n</html>\n";
	
      WebOut.close();
      system(COMM.c_str());

    }

end:
    if(ct>=MaxFrame) exit(Err);
}

