#ifndef BICODIR_HH
#define BICODIR_HH


// Debug Flag -- Define BD_DEBUG to display debug messages

//   Test for uniqueness then define/undefine as needed
// #ifdef BD_DEBUG
// cout << "WARNING:  BicoMon Debug Flag previously defined. Not unique."<<endl;
// #undef BD_DEBUG
// #endif

// #define BD_DEBUG

// Include Files
// -------------

// C++ headers
#include <string>
#include <complex>   
#include <cmath>
#include <cstdlib>
#include <valarray>

// Root typedefs
#include "root/Rtypes.h"

// FFTW headers
#include <fftw3.h>      // FFTW3 header

// DMT-GDS headers
#include "gmutex.hh"
//#include <Complex.hh>   
#include "TSeries.hh"
#include "DecimateBy2.hh"

// DECLARE CONSTANTS
// -----------------
// Bicoherence has a variety of definitions that depend on whether the
//    magnitude is squared and whether the normalization is correlated.
//
// Bicoherence Normalization has two forms:
// Correlated:   N(f_i,f_j) = |P(f_i)*P(f_j)| * |P(f_i + f_j)|
// UnCorrelated: N(f_i,f_j) = |P(f_i)| * |P(f_j)| * |P(f_i + f_j)|
//
// Bicoherence Magnitude has two forms:  Squared or not.
//    For squared magnitude the numenator and denominator are squared.
//
// Vijay uses correlated and not squared.
// MatLab HOSA uses uncorrelated and squared.
//
const bool kBicoNormCorrelated = true ;  
const bool kBicoMagSquared = false ;


// Bicoherence Measurement record
// ------------------------------
// The BicoMeas class holds the parameters required for a given measurement.
// 
class BicoMeas : public thread::mutex {
 
   public:
     
     BicoMeas ();       // Initialize a measurement record
     ~BicoMeas ();      // Destroy a measurement record

		std::string fLabel;
		float 		fFreq1;
		float 		fFreq2;
		float			fRad;
      int         fNConf;   // Number of the associated configuration

};




// Bicoherence (Direct) Configuration record
// -----------------------------------------
// The BicoDirConf class holds the configuration record for the BicoDir class.
// 
// Rename (?)  As it is general enough, I could rename BicoDirConf to BicoConf.

class BicoDirConf : public thread::mutex {
 
   public:
     
     BicoDirConf ();       // Initialized a configuration record
     ~BicoDirConf ();      // Destroy a configuration record
  
     bool   fNew;    // New configuration flag
     bool   fValid;  // Valid configuration flag
     bool   fPause;  // Process Paused flag

     std::string  fChanName1;  // Channel names
     std::string  fChanName2;
     std::string  fChanName3;
     
     Int_t  fChanNum1;	// The number of the channel in the unique channel order.
     Int_t  fChanNum2;
     Int_t  fChanNum3;
     
     Int_t  fNChans;     // Number of Channels
     float  fRate;        //  Channel Data Rate 
     float  fRate1;       
     float  fRate2;
     float  fRate3;
      
     Int_t  fDecim;     // Overall Decimation Rate
     Int_t  fDecim1;    // Decimation Rate, Channel 1 
     Int_t  fDecim2;    // Decimation Rate, Channel 2 
     Int_t  fDecim3;    // Decimation Rate, Channel 3 
     Int_t  fDecOrder1; // Decimation Order, Channel 1, Dec rate = 2^(Dec Order)
     Int_t  fDecOrder2; // Decimation Order, Channel 2 
     Int_t  fDecOrder3; // Decimation Order, Channel 3 
 
     float  fFreqRes;    // Frequency resolution 
     float  fFreqMax;    // Frequency maximum     
     Int_t  fNBins;      // Number of Frequency Bins for each plot dimension
     Int_t  fNPoints;    // Number of Points (samples) per slice
     Int_t  fNFFT;       // Number of bins in 1-sided FFT
     Int_t  fNWinRad;    // Bins in radius of 2-D Window
     float  fOverlap;    // fractional overlap for adjacent data slices
     bool   fWindow1D;    // Flag to use 1D Hanning Window to form PSD's
     
     float  fAverage;    // sample averaging
     float  fNTotal ;    // Total number of points in time series = dec. rate * span
     float	fSpan;       // Time Span, in seconds
     float  fStride;     // Data Stride, in seconds, usually = span
     float  fNSlices ;   // Number of data slices

     bool   fWindow2D;     // Use Window flag
     
};




// Bicoherence (Direct) Class
// --------------------------
// The BicoDir class generates the bicoherence array and calculates the requested
// measurements.  The calling progam must set the data and the config info, then
// call calculate, and finally request a given measurement (an integrated area of
// the array.
// 
// The direct calculation method is used.
// 

class BicoDir {
	         
   public:
     
      BicoDir();     // Constructor
      ~BicoDir();    // Destructor

      BicoDirConf GetConfig();					// Get BicoDir configuration

      float 	Sum(void);                 		// Sum over entire range 
      float 	Sum(float, float, float);  		// Sum over region about (f1,f2)
      float 	Sum(const BicoMeas&);				// Sum over region about (f1,f2)
      void  	Calculate();               		// Calculate Bicoherence
      void  	SetConfig(const BicoDirConf&);	// Set BicoDir configuration
      bool  	CalcConfigParams();					// Calculate remaining Config Parameters
      void  	SetData(int, const TSeries&, bool);    // Set BicoDir input TSeries data
      void  	SetData(int, const TSeries*, bool);    // Set BicoDir input TSeries data
      void		GetBicoData(float*);					// Get the Bicoherence array 
      float*	GetBicoData();							// Get the Bicoherence array 
      void	 	GetPSDData(int, float*);			// Get a PSD data array for a specified TSeries
      float* 	GetPSDData(int);						// Get a PSD data array for a specified TSeries
      void		CopyBicoData(float*);		// Get the Bicoherence array 
      void	 	CopyPSDData(int, float*);			// Get a PSD data array for a specified TSeries
      void		CopyStartTime(Time);	         	// Get Data Start Time 
      Time&		GetStartTime(void);	         	// Get Data Start Time 
      bool  	TestData(int,const TSeries&, const TSeries&, const TSeries&);   // Test Validity of BicoDir input TSeries data
      bool  	TestData(int,const TSeries*, const TSeries*, const TSeries*);   // Test Validity of BicoDir input TSeries data
      
   protected:
      
      float* fBicoDirData; // Pointer to Bicoherence array 

		TSeries	fData1;	// Time series data
		TSeries	fData2;
		TSeries	fData3;
      
      Time fFrameStartTime;

      BicoDirConf fConf;  // Configuration record
       
            
//       bool dbg  ;

    private:
 
      float SumAll(void);                 	// Sum over entire range 
      float SumRegion(float, float, float);  // Sum over region about (f1,f2)
      void  DeleteDynamicArrays(void);
      void  DeleteDMTObjects(void);
      void  CreateDataObjects(void);
      float optFreqWindow(float, float);
           
           
      // Data Channel variables
      // ----------------------
//       bool fFirstTime;             // First Pass
//       int iFrame ;
      float windowNorm ;  // volume of window

      // DMT Data Containers
      // -------------------
      TSeries   tDataSlice1 ;
      TSeries   tDataSlice2 ;
      TSeries   tDataSlice3 ;


      // FFTW Arrays & Plan
      // ------------------      
      float*         ttemp1;        // 1D time series data
      float*         ttemp2;
      float*         ttemp3;
      fftwf_complex* fftOut1;        // 1D FFT of time series
      fftwf_complex* fftOut2;
      fftwf_complex* fftOut3;
      std::complex<float>* ftemp1;        // 1D FFT of time series
      std::complex<float>* ftemp2;
      std::complex<float>* ftemp3;
      
      fftwf_plan     fft_plan1;      // Plan for FFT
      fftwf_plan     fft_plan2;      // Plan for FFT
      fftwf_plan     fft_plan3;      // Plan for FFT
      
     
      // PSD Arrays
      // -----------
      float  *ptemp1;
      float  *ptemp2;
      float  *ptemp3;
      
      
      // Decimation Filters
      // ------------------
      DecimateBy2	fDecFilter1;
      DecimateBy2	fDecFilter2;
      DecimateBy2	fDecFilter3;

     

      // Bispectrum/Bicoherence Arrays
      // -----------------------------
//      fComplex* bsd_data ;
      std::complex<float>* bsd_data ;
      float  *bsdWindow;
      Float_t*  corr_norm ;
      Float_t bic_norm ;
      Float_t psd_temp;
      Float_t bc_temp;
      std::complex<float> bs_temp;
//      fComplex bs_temp;
} ;


#endif
