#include "Impulse.hh"
#include "Time.hh"
#include "constant.hh"
#include <math.h>

//-------------------------------------  Impulse Constructor. 
Impulse::Impulse(const Interval& dur, double ampl,
                const Interval& delay, const Interval& dT, const Time& t0)
  : mT0(t0), mTc(t0), mAmpl(ampl), mDuration (dur), mDelay (delay)
{
    mTl = t0 + dT;
}

//-------------------------------------  Frequency domain template bin.
fComplex 
Impulse::Fspace(double Freq, double dF) const {
    return fComplex (0, 0);
}

//-------------------------------------  Time domain template bin.
double 
Impulse::Tspace(const Time& t0) const {
    return Ampl(t0);
}

//-------------------------------------  Get the t0.
Time 
Impulse::getT0(void) const {
    return mT0;
}

//-------------------------------------  Get the End time.
Time
Impulse::getTEnd(void) const {
    return mTl;
}

//-------------------------------------  Get the Critical time.
Time
Impulse::getTc(void) const {
    return mTc;
}

//-------------------------------------  Time versus Frequency.
Time
Impulse::TvsF(double f) const {
    return mT0;
}

//-------------------------------------  Amplitude.
double 
Impulse::Ampl(const Time& t) const {
    return (((t - mT0) >= mDelay) && ((t - mT0) < mDelay + mDuration)) ?
           mAmpl : 0;
}

void
Impulse::setAmp(double amp) {
    mAmpl = amp;
}

//-------------------------------------  Duration.
Interval 
Impulse::Duration(void) const {
    return mDuration;
}

void
Impulse::setDuration(const Interval& dur) {
    mDuration = dur;
}

//-------------------------------------  Delay.
Interval 
Impulse::Delay(void) const {
    return mDelay;
}

void
Impulse::setDelay(const Interval& delay) {
    mDelay = delay;
}
