/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef XSIL_LIGOLW_HH
#define XSIL_LIGOLW_HH

#include "xsil/xsil.hh"

namespace xsil {

  /**  The ligolw document class is identical to the xsil document class
    *  except that the structure tags are changed from \<XSIL\> to 
    *  \<LIGO_LW\>.
    *  @memo LIGO lightweight structure.
    *  @author J. Zweizig
    *  @version 1.0 ; Modified December 1, 2000
    *  @ingroup IO_xsil
    */
  class ligolw : public XSIL {
  public:
    /**  XSil default constructor.
      *  @memo default constructor.
      */
    ligolw(void);

    /**  XSIL named structure constructor.
      *  @memo Named structure constructor.
      *  @param Name Pointer to structure name string.
      *  @param Type Pointer to structure type string.
      */
    ligolw(const char* Name, const char* Type=0);

    /**  XSIL structure copy constructor.
      *  @memo Copy constructor.
      *  @param x Structure definition to be copied.
      */
    ligolw(const XSIL& x);
    
    /**  Destructor.
      *  @memo Destructor.
      */
    ~ligolw(void);

    /**  Clone a structure.
      *  @memo Clone a structure.
      *  @return opinter to a new object.
      */
    ligolw* Clone(void) const;

    /**  Add a named XSIL substructure.
      *  @memo Add an XSIL substructure.
      *  @param Name Pointer to structure name string.
      *  @param Type Pointer to structure type string.
      *  @return Pointer to the added structure definition.
      */
    XSIL* addXSIL(const char* Name, const char* Type=0);

    /**  Return the object type.
      *  @memo Object type name.
      *  @return Pointer to the object name string.
      */
    const char* getObjType(void) const;
  };

}  // namespace xsil

#endif  //  XSIL_LIGOLW_HH
