/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef XSIL_COLUMN_HH
#define XSIL_COLUMN_HH

#include <xsil/xobj.hh>

namespace xsil {
    class Xwriter;
    class column;

/**  XSil table column definition class.
  *  @memo XSIL column definition class.
  *  @author J. Zweizig
  *  @version 1.2; Modified March 6, 1999
  *  @ingroup IO_xsil
  */
class column : public xobj {
public:
    /**  Default (null) constructor.
      *  @memo Default constructor
      */
    column(void);

    /**  Named table constructor.
      *  @memo Named table constructor
      *  @param Name Pointer to column name string.
      *  @param Type Pointer to column type string.
      *  @param Unit Pointer to column units string.
      */
    column(const char* Name, const char* Type=0, const char* Unit=0);

    /**  Column destructor.
      *  @memo Destructor
      */
    ~column(void);
 
    /**  Write column definition to an XML output file.
      *  @memo Write column to an XML file
      *  @param xout XML output file to receivecolumn definition
      */
    void Spew(Xwriter& xout) const;

    /**  Clone the table column definition
      *  @memo CLone the column
      *  @return Pointer to the cloned column.
      */
    column* Clone(void) const;

    /**  Get the object type
      *  @memo Get the object type
      *  @return Pointer to the object type string
      */
    const char* getObjType(void) const;

    /**  Get the column units.
      *  @memo Get the column units
      *  @return Pointer to the column units string.
      */
    const char* getUnit(void) const;

    /**  Set the column units.
      *  @memo Set the column units
      *  @param Unit Pointer to the column units string.
      */
    void setUnit(const char* Unit);

private:
    std::string mUnit;
};

}

#endif  //  XSIL_COLUMN_HH
