#include "xsil/XSpectrum.hh"
#include "xsil/array.hh"
#include "xsil/stream.hh"
#include <Time.hh>
#include "FSpectrum.hh"

xsil::XSpectrum::XSpectrum(const char* Name, const FSpectrum& fs) 
  : xsil::ligolw(Name, "Spectrum")
{
    int N = fs.getNStep();
    addParam("Subtype",     (char*)0, 1);
    addParam("f0",          "Hz",     fs.getLowFreq());
    addParam("df",          "Hz",     fs.getFStep());
    addTime ("t0",                    fs.getStartTime());
    addParam("dt",          "s",      double(  fs.getEndTime() 
                                            - fs.getStartTime()));
    addParam("BW",          "Hz",     fs.getFStep());
    addParam("Window",      (char*)0, 0);
    addParam("AverageType", (char*)0, 1);
    addParam("Averages",    (char*)0, int(fs.getCount()));
    addParam("N",           (char*)0, N);
    addParam("M",           (char*)0, 1);
    addParam("ChannelA",    "string", (char*)0, fs.getName());

    //----------------------------------  Add the data array object  
    xsil::array* data = addArray(fs.getName(), "float");
    data->addDim("frequency", N);

    //----------------------------------  Fill the local stream with data
    float* dvec = new float[N];
    fs.getData(N, dvec);
    data->refStream().encode64Data((const char*)dvec, N*sizeof(float));
    delete[] dvec;
}

xsil::XSpectrum::~XSpectrum(void) {
}
