#include "xsil/EventTable.hh"
#include "xsil/table.hh"
#include "xsil/column.hh"
#include "xsil/stream.hh"
#include "xsil/xsil.hh"
#include "xsil/Xwriter.hh"

xsil::EventTable::EventTable(void) 
  :  mDoc(0), mTable(0)
{
}

xsil::EventTable::EventTable(const char* Title) 
  : mTitle(Title), mDoc(0), mTable(0)
{
}

xsil::EventTable::~EventTable(void) {
}

void
xsil::EventTable::makeTable(const char* Name, const char* Type) {
    mDoc   = new XSIL(mTitle.c_str(), "Container");
    mTable = mDoc->addTable(Name, Type);
}

void
xsil::EventTable::addColumn(const char* Name, const char* Type, 
			    const void* Addr) {
    if (!mTable) makeTable("NoName", "NoType");
    mTable->addColumn(column(Name, Type));
    eventcolumn ec;
    ec.data_Type = Type;
    ec.data_Addr = Addr;
    mCList.push_back(ec);
}

void
xsil::EventTable::putEvent(void) {
    for (col_iter i=mCList.begin() ; i != mCList.end() ; i++) {
        if (!i->data_Addr) {
	    mTable->refStream().Add("00");
        } if (i->data_Type == "INT4") {
	    mTable->refStream().Add( *(const int*)i->data_Addr );
        } else if (i->data_Type == "STRING") {
	    mTable->refStream().Add( (const char*)i->data_Addr );
        } else if (i->data_Type == "REAL4") {
	    mTable->refStream().Add( *(float*)i->data_Addr );
        } else if (i->data_Type == "REAL8") {
	    mTable->refStream().Add( *(double*)i->data_Addr );
        } else if (i->data_Type == "UCHARVector") {
	    const UCVec* ptr = (UCVec*)i->data_Addr;
	    const unsigned char* pCh = ptr->pData;
	    if (!ptr || !pCh || !ptr->pNBytes) {
	        mTable->refStream().Add("*");
	    } else {
	        std::string bytestr;
	        for (int i=0 ; i  < *(ptr->pNBytes) ; i++) {
		    if (!bytestr.empty()) bytestr += ' ';
		    if (*pCh >= 100) bytestr += '0' + *pCh/100;
		    if (*pCh >= 10)  bytestr += '0' + (*pCh/10)%10;
		    bytestr += '0' + (*pCh++)%10;
		}
		mTable->refStream().Add( bytestr );
	    }
	} else {
	    mTable->refStream().Add("*");
	}
    }
    mTable->refStream().lineBreak();
}

void
xsil::EventTable::putTable(std::ostream& out) {
    Xwriter xw(out);
    mDoc->Spew(xw);
    resetStream();
}

void
xsil::EventTable::resetStream(void) {
    mTable->refStream().Clear();
}
