/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    Dump shared memory partition status.
//
//
#include "lsmp.hh"
#include <cstdlib>
#include <iostream>
#include <cstring>
#include <string>

using namespace std;

//======================================  Syntax print
void
prtSyntax(void) {
    cerr << "Syntax:" << endl;
    cerr << "smdump [-abchvs] [--help] [--no-headers] [<partition-name>]" 
	 << endl;
}

//======================================  Help print
void
prtHelp(void) {
    prtSyntax();
    cout << "The smdump command dumps the status of the specified partition."
	 << endl;
    cout << "If no partition name is specified, the partition named by the"
	 << endl;
    cout << "LIGOSMPART environment variable is used. By default all status"
	 << endl;
    cout << "information is printed. The options allow selection of a specific"
	 << endl;
    cout << "subset as follows: " << endl;
    cout << " -a  Print all status information" << endl;
    cout << " -b  Print buffer status table" << endl;
    cout << " -c  Print consumer status table" << endl;
    cout << " -h  Print header line" << endl;
    cout << " -s  Print the parition control information" << endl;
    cout << " -v  Print verbose consumer settings" << endl;
}

//======================================  Main function
int 
main(int argc, const char *argv[]) {

    const char *name = getenv("LIGOSMPART");
    int flg = 0;
    bool syntax = false;
    for (int i=1; i<argc; ++i) {
	string argi = argv[i];
	if (argi == "--help") {
	    prtHelp();
	}
	else if (argi == "--no-headers") {
	    flg |= 0x0200;
	}
        else if (argi[0] == '-') {
	    for (const char* p=argi.c_str()+1; *p; ++p) {
	       if ( *p == 'a')      flg |= 0xff;
	       else if ( *p == 'b') flg |= 0x04;
	       else if ( *p == 'c') flg |= 0x08;
	       else if ( *p == 'h') flg |= 0x01;
	       else if ( *p == 's') flg |= 0x02;
	       else if ( *p == 'v') flg |= 0x0100;
	       else syntax = true;
	    }
	} else {
	    name = argv[i];
	}
    }
    if (!flg) flg = 0xff;

    //----------------------------------  Check that the name was specified
    if (!name) {
        cerr << "sdump: Partition name not specified" << std::endl;
	syntax = true;
    }

    //----------------------------------  Command syntax error
    if (syntax) {
	prtSyntax();
	return 1;
    }

    //----------------------------------  Dump the partition.
    LSMP_ACCESS part(name);
    if (part.valid()) part.dump(cout, flg);
    else              cerr << "smdump: Unable to access partition " 
			   << name << ": " << part.Error() << endl;
}
