/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "lmsg/TransOutput.hh"
#include "lmsg/Buffer.hh"
#include "Time.hh"

using namespace std;

lmsg::TransOutput::TransOutput(Buffer& b) {
    setBuffer(b);
}

void
lmsg::TransOutput::setBuffer(Buffer& b) {
    mData   = b.getDataAddr();
    mIndex  = 0;
    mLength = b.getDataSize();
}

lmsg::TransOutput::TransOutput(void) 
  : mData(0), mIndex(0), mLength(0)
{
}

template<>
lmsg::size_type 
lmsg::TransOutput::write(const char x[], size_type N) {
    if (full()) return 0;
    if (mIndex + N >= mLength) N = mLength - mIndex;
    memcpy(mData+mIndex, x, N);
    mIndex += N;
    return N;
}

template<>
lmsg::size_type 
lmsg::TransOutput::write(const MsgAddr x[], size_type N) {
    //size_type nB = sizeof(MsgAddr::ipaddr_t);
    //align(nB);
    MsgAddr::ipport_t  ports[2];
    for (size_type i=0; i < N; ++i) {
	MsgAddr::ipaddr_t ipad = x[i].getIPAddr();
	//if (write(reinterpret_cast<char*>(&ipad), nB) != nB) return i;
	if (!write(&ipad, 1)) return i;
	ports[0] = x[i].getIPPort();
	ports[1] = x[i].getSubProcess();
        if (write(ports, 2) != 2) return i;
    }
    return N;
}

template<>
lmsg::size_type 
lmsg::TransOutput::write(const string x[], size_type N) {
    for (size_type i=0; i < N; ++i) {
        unsigned short Ls = x[i].size();
        if (!write(&Ls, 1)) return i;
	if (write(x[i].c_str(), Ls) != Ls) return i+1;
    }
    return N;
}

template<>
lmsg::size_type 
lmsg::TransOutput::write(const Time x[], size_type N) {
    gps_export_type td[2];
    for (size_type i=0; i<N; ++i) {
	td[0] = x[i].getS();
	td[1] = x[i].getN();
	if (write(td, 2) != 2) return i;
    }
    return N;
}

void
lmsg::TransOutput::align(size_type N) {
    size_type nByte = (-mIndex) & (N-1);
    for (size_type i=nByte; i>0; --i) mData[mIndex++] = 0;
}

