/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "lmsg/MsgHeader.hh"
#include "lmsg/Grinder.hh"
#include "lmsg/ErrorList.hh"
#include <iostream>

lmsg::MsgHeader::~MsgHeader(void) 
{}

lmsg::MsgHeader::MsgHeader(void) 
  : mLength(0), mType(0), mTransID(0), mBlockID(0) 
{}

lmsg::MsgHeader::MsgHeader(MsgType type, count_t length, const MsgAddr& dest)
  : mLength(length), mType(type), mDest(dest), mTransID(0), mBlockID(0)
{}

void
lmsg::MsgHeader::Dump(std::ostream& out) const {
    out << "Message Header:" << std::endl;
    out << "  Data Length         " << getMsgLength() << std::endl;
    out << "  Message Type        " << getMsgType() << std::endl;
    out << "  Source Address      " << getSource() << std::endl;
    out << "  Destination Address " << getDest() << std::endl;
    out << "  Transaction ID      " << getTransID() << std::endl;
    out << "  Block ID            " << getBlockID() << std::endl;
}

void
lmsg::MsgHeader::Export(void) {
    Import();
}

void
lmsg::MsgHeader::Import(void) {
    if (export_format_grinder.need_swap()) {
	export_format_grinder.SwapT(&mLength);
	export_format_grinder.SwapT(&mType);
	export_format_grinder.SwapT(&mTransID);
	export_format_grinder.SwapT(&mBlockID);
    }
}

void 
lmsg::MsgHeader::setDest(const MsgAddr& addr) {
    mDest = addr;
}

void 
lmsg::MsgHeader::setSource(const MsgAddr& addr) {
    mSource = addr;
}

void 
lmsg::MsgHeader::setMsgLength(count_t length) {
    mLength = length;
}

void 
lmsg::MsgHeader::setMsgType(MsgType type) {
    mType = type;
}

void 
lmsg::MsgHeader::setTransID(count_t id) {
    mTransID = id;
}

void 
lmsg::MsgHeader::setBlockID(count_t id) {
    mBlockID = id;
}

//=====================================  Messages
std::string 
lmsg::lmsg_error_string(error_type err) {
    switch (err) {
    case lmsg::OK:
	return "No error";
    case lmsg::SystemError:
	return "System error";
    case lmsg::TimeOut:
	return "Time limit expired";
    case lmsg::Continue:
	return "Continue/retry";
    case lmsg::BadAddress:
	return "Bad destination address";
    case lmsg::NoBuffer:
	return "No buffer";
    case lmsg::NoPool:
	return "No pool";
    case lmsg::NotOpen:
	return "Socket is not open";
    case lmsg::SizeError:
	return "Size error";
    case lmsg::Failure:
	return "Failure";
    case lmsg::MisMatch:
	return "MisMatch";
    case lmsg::Syntax:
	return "Syntax";
    case lmsg::Invalid:
	return "Invalid";
    case lmsg::NoHandler:
	return "No handler specified";
    default:
	return "Undefined error code";
    }
}

void 
lmsg::put_lmsg_error(const std::string& msg, error_type err) {
    std::cerr << msg << ": " << lmsg_error_string(err) << std::endl;
}
