#include "html/document.hh"
#include "html/color.hh"
#include "html/writer.hh"

using namespace html;

//====================================== Construct an empty document
document::document(void) 
  : mRefresh(0.0)
{}

document::document(const char* title) 
  : mTitle(title), mRefresh(0.0)
{}

document::document(const document& x) 
  : compound(x), mTitle(x.mTitle), mStyle(x.mStyle), mRefresh(0.0)
{}

document::~document(void) {
}

document*
document::clone(void) const {
    return new document(*this);
}

void 
document::write(writer& out) const {
    out.tag("HTML");

    //----------------------------------  Add header section and meta-data
    out.tag("HEAD");
    if (!mTitle.empty()) {
        out.tag("TITLE");
	out.text(mTitle);
        out.endTag("TITLE");
    }
    out.meta("Content-Type", "text/html; charset=iso-8859-1");
    if (mRefresh != 0.0) out.meta("Refresh", mRefresh);
    out.endTag("HEAD");
    out.endLine();

    //----------------------------------  Add style dictionary
    if (!mStyle.empty()) {
        mStyle.write(out);
	out.endLine();
    }

    //----------------------------------  Add body
    compound::write(out);
    out.endTag("HTML");
}

//======================================  Get the tag
const char *
document::getTag(void) const {
    return "BODY";
}

//======================================  Set the background color.
void 
document::setBackgroundColor(const color& clr) {
    compound::repAttr("BGCOLOR", clr);
}

//======================================  Set the refresh period
void 
document::setRefresh(double t) {
    mRefresh = t;
}

//======================================  Set the refresh period
void 
document::setStyle(const std::string& name, const StyleClass& c) {
    mStyle.addClass(name, c);
}
