/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "framedir.hh"
#include "Time.hh"
#include <cstdlib>
#include <unistd.h>
#include <string>
#include <iostream>
#include <iomanip>
#include <vector>
#include <time.h>
#include <sys/types.h>
#include <utime.h>

//-----------------------------------------------------------------------------
// getopt changed its tune. It used to define EOF for the end-of-option-list
// value. Posix says this value must be -1. For the time being I'll make a
// local definition of EOF = -1, to maintain backward compatibility, but this 
// could cause problems in the future.
#ifndef EOF
#define EOF int(-1)
#endif
//-----------------------------------------------------------------------------

   using namespace std;


   int main (int argc, char** argv)
   {
      // parse cmd line arguments
      int 		c;
      extern int	optind;	
      int		errflag = 0;
      bool		setdir = false;
      vector<string> filenames;
      while ((c = getopt (argc, argv, "dh")) != EOF) {
         switch (c) {
            case 'd':
               {
                  setdir = 1;
                  break;
               }
            case 'h':
               {
                  errflag = 1;
                  break;
               }
         }
      }
      if (errflag || (argc <= 1)) {
         cout << "usage: fsettime [-d] 'frame directory(ies)'" << endl;
         cout << "       option -d: set directory time as well" << endl;
         exit (0);
      }
      for (int i = optind; i < argc; i++) {
         filenames.push_back (argv[i]);
      }
   
      // add filenames to frame dir
      FrameDir fdir;
      //fdir.setDebug (1);
      for (vector<string>::iterator i = filenames.begin(); 
          i != filenames.end(); ++i) {
         fdir.add (i->c_str(), true);
      }
   
      // loop over frames and set creation/modification time
      string olddir = "";
      for (FrameDir::file_iterator i = fdir.begin(); i != fdir.end(); i++) {
         // check if directory has to be updated
         string file = i->getFile();
         if (setdir) {
            string newdir = file;
            string::size_type pos = newdir.find_last_of ('/');
            if (pos == string::npos) {
               newdir = "";
            }
            else {
               newdir.erase (pos);
            }
            if ((olddir != newdir) && !newdir.empty()) {
               time_t t0 = getUTC (i->getStartTime());
               utimbuf ftime = {t0, t0};
               utime (newdir.c_str(), &ftime);
               olddir = newdir;
            }
         }
         // update frame file
         time_t t0 = getUTC (i->getStartTime());
         utimbuf ftime = {t0, t0};
         utime (file.c_str(), &ftime);
      }
   
      return 0;
   }
