#include "ChanName.hh"

using namespace std;

static const char* alf  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
static const char* anum = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
static const char* vnam = 
       "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789._";

//======================================  Null Constructor
ChanName::ChanName(void) {
}

//======================================  Name constructor
ChanName::ChanName(const string& name, bool locale) {
    setChannel(name, locale);
}

//======================================  Name constructor with default
ChanName::ChanName(const string& name, const ChanName& deflt) {
    setChannel(name, deflt);
}

//======================================  Build channel name from parts.
string 
ChanName::getChannel(void) const {
    string r = mIFO + ":" + mSubSystem + "-";
    if (!mLocale.empty()) r += mLocale + "_";
    r += mName;
    return r;
}

//======================================  Set the detector identifier.
void 
ChanName::setIFO(const std::string& ifo) {
    mIFO.clear();
    if (ifo.size() < 2) throw runtime_error("Invalid Ifo specification");
    if (ifo.find_first_of(alf) != 0) throw runtime_error("Invalid site code");
    const char* p = ifo.c_str()+1; 
    while (*p >= '0' && *p <= '9') p++;
    if (*p != 0) throw runtime_error("Invalid detector number");
    mIFO = ifo;
}

//======================================  Set the subsystem name
void 
ChanName::setSubSystem(const string& det) {
    mSubSystem.clear();
    if (det.find_first_not_of(anum) < det.size())
        throw runtime_error("Invalid character in sub-system name");
    mSubSystem = det;
}

//======================================  Set the channel Locale
void 
ChanName::setLocale(const string& loc) {
    mLocale.clear();
    if (loc.find_first_not_of(anum) < loc.size())
        throw runtime_error("Invalid character in Locale name");
    mLocale = loc;
}

//======================================  Set the name field
void 
ChanName::setName(const string& name) {
    mName.clear();
    if (name.find_first_not_of(vnam) < name.size())
        throw runtime_error("Invalid character in chan specific name");
    mName = name;
}

//======================================  Parse a  channel name
void 
ChanName::setChannel(const string& chan, bool locale) {
    string temp = chan;
    string::size_type i = temp.find(":");
    if (i == string::npos) throw runtime_error("No detector specified");
    setIFO(temp.substr(0, i));
    temp.erase(0, i+1);
    i = temp.find("-");
    if (i == string::npos) throw runtime_error("No subsystem specified");
    setSubSystem(temp.substr(0, i));
    temp.erase(0, i+1);
    if (locale) {
        i = temp.find("_");
	if (i != string::npos) {
	    setLocale(temp.substr(0,i));
	    temp.erase(0, i+1);
	}
    }
    setName(temp);    
}

//======================================  Parse a channel name
void 
ChanName::setChannel(const std::string& chan, const ChanName& deflt) {
    string temp = chan;

    //----------------------------------  Fill in ifo field
    string::size_type i = temp.find(":");
    if (!i || i == string::npos) {
        if (!i) temp.erase(0,1);
	setIFO(deflt.getIFO());
    } else {
        setIFO(temp.substr(0, i));
	temp.erase(0, i+1);
    }

    //----------------------------------  Fill in subsystem field
    i = temp.find("-");
    if (!i || i == string::npos) {
        if (!i) temp.erase(0,1);
	setSubSystem(deflt.getSubSystem());
    } else {
        setSubSystem(temp.substr(0, i));
	temp.erase(0, i+1);
    }

    //----------------------------------  Fill in locale
    i = temp.find("_");
    if (!i || i == string::npos) {
        if (!i) temp.erase(0, 1);
	setLocale(deflt.getLocale());
    } else {
        setLocale(temp.substr(0,i));
        temp.erase(0, i+1);
    }

    if (temp.empty()) setName(deflt.getName());
    else              setName(temp);
}
