/* Version $Id: xmldir.cc 6433 2011-05-17 14:53:18Z james.batch@LIGO.ORG $ */
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: xmldir							*/
/*                                                         		*/
/* Module Description: program to list the directory of an xml file	*/
/*                     which was generated by the diagnostics system	*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Includes: 								*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
#include <time.h>
#include <iostream>
#include <string>
#include <unistd.h>
#include "dtt/gdsutil.h"
#include "dtt/gdsdatum.hh"

   using namespace std;
   using namespace diag;


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Constants: _argHelp		argument for displaying help		*/
/*            _argParam		parameter flag				*/
/*            _argValue		value flag				*/
/*            help_text		help text				*/
/*            								*/
/*----------------------------------------------------------------------*/
   const string		_argHelp ("-help");
   const string		_argHelp1 ("--help");
   const string		_argHelp2 ("-h");
   const string		_argHelp3 ("-?");
   const string 	_argParam ("-p");
   const string 	_argValue ("-v");
   const string 	_argIndex ("-i");
   const string 	indexEntry ("Index");
   const string		help_text 
   ("Usage: xmldir -flags filename\n"
   "       filename xml file to be read\n"
   "       -flags control parameters\n"
   "Control parameters\n"
   "       -p		        include parameter information\n"
   "       -v		        include values of parameters\n"
   "       -i		        only print index\n"
   " xmldir version " VERSION "\n"
   " $Id: xmldir.cc 6433 2011-05-17 14:53:18Z james.batch@LIGO.ORG $\n");


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Main Program 							*/
/*                                                         		*/
/* Description: 							*/
/* 									*/
/*----------------------------------------------------------------------*/
   int main (int argc, char *argv[])
   {
      int		i;
      bool		fParam = false;
      bool		fValue = false;
      bool		fIndex = false;
      string		filename;
   
      // no arguments
      if (argc <= 1) {
         cout << help_text;
         return 0;
      }
   
      // parse arguments
      for (i = 1; i < argc; i++) {
         // help
         if (_argHelp == argv[i] || _argHelp1 == argv[i] || _argHelp2 == argv[i] || _argHelp3 == argv[i]) {
            cout << help_text;
            return 0;
         }
         // parameter flag
         else if (_argParam == argv[i]) {
            fParam = true;
         }
         // value flag
         else if (_argValue == argv[i]) {
            fValue = true;
         }
         // index flag
         else if (_argIndex == argv[i]) {
            fIndex = true;
            fValue = true;
            fParam = true;
         }
         // filename flag
         else {
            filename = argv[i];
         }
      }
   
      // open file
      gdsStorage	st (filename, gdsStorage::ioEverything);
      if (!st) {
         cout << "Unable to open " << filename << endl;
         return 1;
      }
   
      // go through list of objects
      if (fParam && !fIndex) {
         cout << "Header" << endl;
         if (!st.creator.empty()) {
            cout << "  Creator";
            if (fValue) {
               cout << " = " << st.creator;
            }
            cout << endl;
         }
         if (!st.date.empty()) {
            cout << "  Date";
            if (fValue) {
               cout << " = " << st.date;
            }
            cout << endl;
         }
         for (gdsDataObject::gdsParameterList::iterator piter =
             st.parameters.begin(); piter != st.parameters.end(); 
             piter++) {
            cout << "  " << (*piter)->name;
            if (fValue) {
               cout << " = " << (gdsDatum&) (**piter);
               if (!(*piter)->unit.empty()) {
                  cout << " " << (*piter)->unit;
               }
            }
            cout << endl;
         }
      }
      for (gdsStorage::gdsObjectList::iterator diter =
          st.objects.begin(); diter != st.objects.end(); diter++) {
         if (fIndex && ((*diter)->name != indexEntry)) {
            continue;
         }
         cout << (*diter)->name << endl;
         if (fParam) {
            for (gdsDataObject::gdsParameterList::iterator piter =
                (*diter)->parameters.begin(); 
                piter != (*diter)->parameters.end(); 
                piter++) {
               cout << "  " << (*piter)->name;
               if (fValue) {
                  cout << " = " << (gdsDatum&) (**piter);
                  if (!(*piter)->unit.empty()) {
                     cout << " " << (*piter)->unit;
                  }
               }
               cout << endl;
            }
         }
      }
   
      return 0;
   }
