#include "testPak.hh"
#include "Time.hh"
#include <iostream>
#include <sstream>

using namespace std;

//======================================  Package test manager constructor
testPak::testPak(const char* ttl, ostream& out) 
  : mOut(out), mPackage(ttl), mSecCount(0), mTestCount(0), mErrorCount(0)
{
    mOut << "Starting test package: " << mPackage << endl;
}

//======================================  Package test manager cdestructor
testPak::~testPak(void) {
    mOut << "Test Package: " << mPackage << " completed " << mSecCount 
	 << " sections, " << mTestCount << " tests with " << mErrorCount 
	 << " total errors." << endl;
}

//======================================  Start a section
void 
testPak::startSection(const char* sec, const char* title) {
    mSection = sec;
    mSecTitle = title;
    mSecCount++;
    mTestSec=0;
    mErrorSec=0;
    mErrorTest=0;
}

//======================================  Start a test
void 
testPak::startTest(const char* sec, const char* title) {
    mTest = sec;
    mTestTitle = title;
    mTestSec++;
    mTestCount++;
    mErrorTest=0;
}

//======================================  End a section
void 
testPak::endSection(void) {
    mOut << "Section: " << mSection << " completed " << mTestSec 
	 << " subtests  with " << mErrorSec << " total errors." << endl;
}

//======================================  End a test
void 
testPak::endTest(void) {
    mOut << "Test " << mSection << ":" << mTest << " completed with "
	 << mErrorTest << " total errors" << endl;
}

//======================================  Count an error and print the message
void 
testPak::printError(const std::string& txt) {
    mOut << "*** Error in " << mSection << ":" << mTest << " - "<< txt << endl;
    mErrorCount++;
    mErrorTest++;
    mErrorSec++;
}

//======================================  Print message and good/bad values
void 
testPak::printErrorVal(const char* txt, double val, double expct, double err) {
    std::ostringstream str;
    str << txt << " value: " << val;
    if (expct != val) str << " expected: " << expct;
    if (err != 0)     str << " +/- " << err;
    printError(str.str());
}

void 
testPak::printErrorVal(const char* txt, size_type inx, double val, 
		       double expct, double err) {
    std::ostringstream str;
    str << txt << " index: " << inx << " value: " << val;
    if (expct != val) str << " expected: " << expct;
    if (err != 0)     str << " +/- " << err;
    printError(str.str());
}

void 
testPak::printErrorVal(const char* txt, const Time& val, const Time& expct) {
    std::ostringstream str;
    str << txt << " value: " << val;
    if (expct != Time(0)) str << " expected: " << expct;
    printError(str.str());
}

//======================================  Test for equal values
bool 
testPak::testError(size_type inx, double val, double expct, double err,	
		   const char* txt) 
{
    if (val == expct) return false;
    printErrorVal(txt, inx, val, expct, err);
    return true;
}

//======================================  Test for equal values
bool
testPak::testError(const Time& val, const Time& expct, const char* txt) {
    if (val == expct) return false;
    printErrorVal(txt, val, expct);
    return true;
}

//======================================  Test for equal values
bool
testPak::testVector(const float* v, const float* x, testPak::size_type N, 
		    const char* txt) {
    bool rc = false;
    for (size_type i=0; i<N; i++) rc |= testError(v[i], x[i], 0.0, txt);
    return rc;
}
