#ifndef GENERATOR_GAUSSNOISE_HH
#define GENERATOR_GAUSSNOISE_HH

#include "DataSource.hh"

namespace generator {

  /**  The WhiteNoise class is a DMT generator data source that produces 
    *  continuous random white gaussian distributed noise. The only parameter
    *  is the amplitude A, which specifies the standard deviation of the 
    *  noise. If A is not specified it is assigned a value of 1.0.
    *
    *  @memo Gaussian noise data source.
    *  @author John Zweizig
    *  @version 1.1; Last modified: April 21, 2004
    */
  class WhiteNoise : public DataSource {
  public:
      /**  Gaussian noise data source constructor.
        *  @param Amp Noise amplitude.
	*/
      WhiteNoise(double Amp=1.0);

      /**  Gaussian noise data source destructor.
        */
      ~WhiteNoise(void);

      /**  Clone a gaussian noise data source.
        *  @return Pointer to an identical cop of the current object.
	*/
      WhiteNoise* clone(void) const;

      /**  Return the type of this data source.
        *  @return Pointer to a constant string containing "WhiteNoise"
	*/
      const char* getDataType(void) const;
  private:
    void getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d);
  };

  //====================================  Inline methods.
  inline const char* 
  WhiteNoise::getDataType(void) const {
      return "WhiteNoise";
  }

} // namespace generator

#endif  // GENERATOR_GAUSSNOISE_HH
