/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef GENERATOR_WALK_HH
#define GENERATOR_WALK_HH

#include "DataSource.hh"

namespace generator {

    /**  The Walk class is a DMT generator data source that produces 
      *  continuous random walk in one dimension. There are two parameters,
      *  a starting point (X0), and an average velocity (V) in units of s^-1.
      *  after one second, the rms distance from the starting point is a
      *  gaussian with sigma V.
      *
      *  @memo Gaussian noise data source.
      *  @author John Zweizig
      *  @version 1.1; Last modified: April 21, 2004
      */
    class Walk : public DataSource {
    public:
	/**  Gaussian noise data source constructor.
	  *  @param Amp Noise amplitude.
	  */
	Walk(double V=1.0, double X0=0.0);

	/**  Random walk data source destructor.
	  */
	~Walk(void);

	/**  Clone a gaussian noise data source.
	  *  @return Pointer to an identical cop of the current object.
	  */
	Walk* clone(void) const;

	/**  Return the type of this data source.
	  *  @return Pointer to a constant string containing "Walk"
	  */
	const char* getDataType(void) const;

    private:
	void getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d);

    private:
	bool   mRun;
	double mX0;
    };

    //====================================  Inline methods.
    inline const char* 
    Walk::getDataType(void) const {
	return "Walk";
    }

} // namespace generator

#endif  // GENERATOR_WALK_HH
