/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "Walk.hh"
#include "rndm.hh"

namespace generator {

   Walk::Walk(double V, double X0)
      : DataSource(kContinuous), mRun(false), mX0(X0)
   {
      setParameter("V",  V);
      setParameter("X0", X0);
   }

   Walk::~Walk(void) {
   }

   Walk*
   Walk::clone(void) const {
      return new Walk(*this);
   }

   void
   Walk::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {
      if (!mRun) {
	 mX0 = getNumeric("X0");
	 mRun = true;
      }
      double sigma = getNumeric("V") * sqrt(dT);
      for (int i=0 ; i<N ; ++i) {
	 mX0  += sigma * Rannor();
	 d[i] = mX0;
      }
   }

} // namespace generator
