#ifndef GENERATOR_SINDATA_HH
#define GENERATOR_SINDATA_HH

#include "generator/DataSource.hh"

namespace generator {

  /**  %SineData is a sinusoid data generator. The generated waveform is:
    *
    *  \f[ x(t)  = A sin(2 \pi F (t-t_0) + \phi_0 )  \f]
    *
    *  where the generator Parameters are:
    *  <table>
    *  <tr><td>\c A </td>
    *      <td> - </td>
    *      <td> Amplitude </td>
    *  </tr>
    *  <tr><td>\c F   </td>
    *      <td>   - </td>
    *      <td> Sinusoid frequency (in Hz) </td>
    *  </tr>
    *  <tr><td>\c Phi  </td>
    *      <td> 0  </td>
    *      <td> Phase at \c t=to (in degrees) </td>
    *  </tr>
    *  </table>
    *
    *  @memo %Sine waveform generator.
    *  @version 1.1; last modified February 23, 2004
    *  @author  John Zweizig
    */
  class SineData : public DataSource {
  public:
      /**  Default constructor.
        *  \brief Construct an empty %SineData object.
        */
      SineData(void);

      /**  Construct a %SineData object and set the parameters.
        *  \brief %Parameter constructor
        *  @param Amp  Sinusoid amplitude.
	*  @param Freq Sinusoid frequency in Hz.
	*  @param Phi  Sinusoid phase at \c t=to.
        */
      SineData(double Amp, double Freq, double Phi=0.0);

      /**  %SineData Destructor.
        *  \brief Destructor
        */
      ~SineData(void);

      /**  Make an exact copy of a %SineData constructor.
        *  @return Pointer to copied object.
        */
      SineData* clone(void) const;

      /**  Return a constant string with the data source type name ("Sine").
	*  @return constant pointer to the character string "Sine".
	*/
      const char* getDataType(void) const;
  private:

      /**  Generate the data.
        */
      void getSeries(const Time& t0, Interval dT, int N, gen_sample_type* data);
  private:
      Time mT0;
  };

  //====================================  Inline methods
  inline const char*
  SineData::getDataType(void) const {
      return "Sine";
  }

} // namespace generator

#endif  // GENERATOR_SINGAUSS_HH
