#include "FilterModule.hh"

using namespace std;


//======================================  Calculate the inverse of a filter
static IIRFilter 
FilterInverse(const IIRFilter& f) {
    IIRFilter rc(f.getFSample());
    const std::vector<IIRSos>& vSos = f.getSOS();
    for (unsigned int i=0 ; i<vSos.size() ; i++) {
        rc *= IIRSos(         1.0, vSos[i].A1(), vSos[i].A2(), 
		     vSos[i].B0(), vSos[i].B1(), vSos[i].B2());
    }
    rc *= 1./f.getGain();
    return rc;
}

//======================================  Default constructor
FilterStage::FilterStage(void)
  : mFlags(0), mID(0)
{
}

//======================================  Data constructor
FilterStage::FilterStage(const char* nm, int id, int fl, const IIRFilter& f)
  : mName(nm), mFlags(fl), mID(id), mFilter(f)
{
}

//======================================  Add or replace a stage
IIRFilter
FilterStage::getInverse(void) const {
    return FilterInverse(mFilter);
}

//======================================  Default constructor
FilterModule::FilterModule(void)
  : mMask(0)
{}

//======================================  FilterModule Destructor
FilterModule::~FilterModule(void) {
}

//======================================  Filter a time series.
TSeries 
FilterModule::filter(const TSeries& ts) {
    return mFilter(ts);
}

//======================================  Add or replace a stage
void 
FilterModule::addStage(unsigned int N, const FilterStage& s) {
    if (mStages.size() <= N) mStages.resize(N+1);
    mStages[N] = s;
}

//======================================  Add or replace a stage
IIRFilter
FilterModule::getInverse(void) const {
    return FilterInverse(mFilter);
}

//======================================  Set the stage mask, calculate filter
void 
FilterModule::setMask(int mask) {
    if (mMask == mask) return;
    int maskBit = 1;
    mFilter = IIRFilter(16384);
    for (stage_iter i=mStages.begin() ; i != mStages.end() ; i++) {
        if ((maskBit & mask) != 0) mFilter *= i->getFilter();
	maskBit <<= 1;
    }
    mMask = mask;
}
