AC_DEFUN([AC_GDS_CXX_HAS_IS_NOTHROW_SWAPPABLE],[dnl
	AC_LANG_PUSH([C++])
	AC_COMPILE_IFELSE([AC_LANG_PROGRAM( [[
#include <algorithm>

struct gstruct
{
  void Swap( gstruct& rhs );
};

namespace std {
  template<>
  inline void swap<>( gstruct& lhs,
                gstruct& rhs )
  noexcept( __is_nothrow_swappable< gstruct >::value )
  {
    lhs.Swap( rhs );
  }
}
]],[[]])],[AC_DEFINE([HAVE_IS_NOTHROW_SWAPPABLE],[1],[Defined if swap needs __is_nothrow_swappable])
           HAVE_IS_NOTHROW_SWAPPABLE=1
          ],[HAVE_IS_NOTHROW_SWAPPABLE=0])
	AC_LANG_POP([C++])
	AC_SUBST([HAVE_IS_NOTHROW_SWAPPABLE])
])

AC_DEFUN([AC_GDS_CXX_HAS_IS_NOTHROW_MOVEABLE],[dnl
	AC_LANG_PUSH([C++])
	AC_COMPILE_IFELSE([AC_LANG_PROGRAM( [[
#include <algorithm>

struct gstruct
{
  void Swap( gstruct& rhs );
};

namespace std {
  template<>
  inline void swap<>( gstruct& lhs, gstruct& rhs )
  noexcept( __and_<is_nothrow_move_constructible< gstruct >,
                   is_nothrow_move_assignable< gstruct > >::value )
  {
    lhs.Swap( rhs );
  }
}
]],[[]])],[AC_DEFINE([HAVE_IS_NOTHROW_MOVEABLE],[1],[Defined if swap needs __is_nothrow_move_constructible+assignable])
           HAVE_IS_NOTHROW_MOVEABLE=1
          ],[HAVE_IS_NOTHROW_MOVEABLE=0])
	AC_LANG_POP([C++])
	AC_SUBST([HAVE_IS_NOTHROW_MOVEABLE])
])

AC_DEFUN([AC_GDS_CXX_HAVE_ISFINITE],[dnl
  AC_LANG_PUSH([C++])
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM( [[
#include <cmath>
]],[[
double a = 30;
if ( isfinite(a) )
{
  return( 0 );
}
]])],[AC_DEFINE([HAVE_ISFINITE],[1],[Defined if isfinite is available])])
  AC_LANG_POP([C++])
])

AC_DEFUN([AC_GDS_CXX_HEADERS],[dnl
  AC_LANG_PUSH([C++])
  AC_CHECK_HEADERS([unorderd_map])
  AC_CHECK_HEADERS([tr1/unorderd_map])
  AC_CHECK_HEADERS([ext/hash_map])
  AC_LANG_POP([C++])
])dnl AC_GDS_CXX_HEADERS


AC_DEFUN([AC_GDS_CXX_HAS_NOEXCEPT],[dnl
  AC_LANG_PUSH([C++])
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM( [[
int test_except(void) noexcept;
int test_except(void) noexcept {
  return 1;
}
]],[[
return test_except();
]])],[AC_SUBST([NOEXCEPT],[noexcept])],[AC_SUBST([NOEXCEPT],["throw()"])])
AC_LANG_POP([C++])
])

