#include "Trend.hh"
#include "ParseLine.hh"
#include <string>
#include <fstream>
#include <iostream>
#include <vector>

using namespace std;

int
main(int argc, const char* argv[]) {
    bool syntax = false;
    bool debug = false;
    string ofile;
    string name("Merge");

    int inx = 1;
    for (; inx<argc && (*argv[inx] == '-'); ++inx) {
        string argi=argv[inx];
	if (argi == "--debug") {
	    debug = true;
	} else if (argi == "--name" || argi == "-n") {
	   name = argv[++inx];
	} else if (argi == "-o") {
	    ofile = argv[++inx];
	} else if (argi == "--") {
	    inx++;
	    break;
	} else {
	    cerr << "Unrecognized keyword: " << argi << endl;
	    syntax = true;
	}
    }
    
    syntax = syntax || (inx+2 >= argc);
    if (syntax) {
        cerr << "Command syntax: " << endl;
	cerr << "   MergeTrends [-o <output-file>] [--] [--name <trend-name>]" 
	     << endl
	     << "   <list-file> <trend-1> <trend-2> [... <trend-N>]" << endl;
	return 1;
    }

    Trend::TrendType ttype(Trend::kMinute);
    vector<string> chanvect;

    ParseLine pl(argv[inx++]);
    if (!pl.isOpen()) {
        cerr << "Unable to open configuration file: " << argv[inx-1] << endl;
	return 2;
    }
    while (pl.getLine() >= 0) {
        chanvect.push_back(pl[0]);
    }

    Trend templ(name.c_str(), ttype);
    for (unsigned long i=0; i<chanvect.size(); ++i) {
        templ.addChannel(chanvect[i].c_str());
    }

    Trend merge(templ);
    merge.read(argv[inx++]);
    if (debug) merge.dump(cout);

    for (; inx < argc; ++inx) {
        Trend frameN(templ);
	frameN.read(argv[inx]);
	if (debug) frameN.dump(cout);
	merge += frameN;
	frameN.clear();
    }

    if (!ofile.empty()) merge.setFile(ofile.c_str());
    merge.Update();
    templ.clear();
}
