//
//    Trigger raw data descriptor methods.
//
#include <stdio.h>
#include <time.h>
#include <iostream>
//#include "framecpp/frame.hh"
//#include "framecpp/detector.hh"
#include "TrigRaw.hh"
#include "Time.hh"

using namespace std;
//
//    Data source descriptor costructor
//
trig::TrigRaw::TrigRaw(void) {
}

trig::TrigRaw::TrigRaw(const char* File, const char* FrameID, 
		       Interval Start, Interval Length) 
  : mFile(File), mFrameID(FrameID), mChannel(""), 
    mEpochStart(Start), mEpochLength(Length)

{
}

trig::TrigRaw::TrigRaw(const trig::TrigRaw& x) {
    mFile        = x.mFile;
    mFrameID     = x.mFrameID;
    mChannel     = x.mChannel;
    mEpochStart  = x.mEpochStart;
    mEpochLength = x.mEpochLength;
}

trig::TrigRaw&
trig::TrigRaw::operator=(const trig::TrigRaw& x) 
{
    mFile        = x.mFile;
    mFrameID     = x.mFrameID;
    mChannel     = x.mChannel;
    mEpochStart  = x.mEpochStart;
    mEpochLength = x.mEpochLength;
    return *this;
}

//--------------------------------------  Dump the raw data file to a stream.
void
trig::TrigRaw::Serialize(ostream& serial) const {
  serial << mFrameID << " " << mChannel << " " 
	 << mEpochStart << " " << mEpochLength;
}

//--------------------------------------  Set the channel name.
void
trig::TrigRaw::setChannel(const string& Name) {
    mChannel = Name;
}
