/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "TrigBase.hh"
#include "TrigProc.hh"
#include "TrigRaw.hh"
#include <cstring>

using namespace trig;

//======================================  Default Constructor
TrigBase::TrigBase(void) 
  : mCreatorDB(0), mTime(0), mDuration(0), mPriority(p_info), 
    mDisposition(d_metaDB), mSize(0.0), mSignificance(0.0),
    mFrequency(0.0), mBandwidth(0.0), mLength(0), mPeakTime(0),
    mAvgTime(0), mTimeSigma(0), mFreqPeak(0), mFreqAvg(0), mFreqSigma(0),
    mNoisePower(0), mSignalPower(0), mPixelCount(0), mConfidence(0)
{}

//======================================  Copy Constructor
TrigBase::TrigBase(const TrigBase& x) {
    *this = x;
}

//======================================  Data Constructor
TrigBase::TrigBase(const char* ID, const char* SubID, 
			 const Time& When, const Interval& dTime, 
			 double Size, double Significance, double Freq,
			 const char* ifo) 
  : mCreatorDB(0), mPriority(p_info), mDisposition(d_metaDB),
    mFrequency(Freq), mBandwidth(0.0), mLength(0), mPeakTime(0),
    mAvgTime(0), mTimeSigma(0), mFreqPeak(0), mFreqAvg(0), mFreqSigma(0),
    mNoisePower(0), mSignalPower(0), mPixelCount(0), mConfidence(0)
{
    if (ID)    mName  = ID;
    if (SubID) mSubID = SubID;
    if (ifo)   mIfo   = ifo;
    mTime     = When;
    mDuration = dTime;
    mSize     = Size;
    mSignificance = Significance;
}

//======================================  Accessors
TrigBase::index_type
TrigBase::getData(index_type inx, index_type len, char* data) const {
    if (inx > mLength) inx = mLength;
    if (inx + len > mLength) len = mLength - inx;
    if (len != 0) memcpy(data, mResults+inx, len);
    return len;
}

//======================================  Set result data
void 
TrigBase::appData(const char* data, index_type len) {
    modData(data, mLength, len);
}

void 
TrigBase::modData(const char* data, index_type inx, index_type len) {
    if (inx > sizeof(mResults)) inx = sizeof(mResults);
    if (inx + len > sizeof(mResults)) len = sizeof(mResults) - inx;
    if (len == 0) return;
    memcpy(mResults+inx, data, len);
    if (inx+len > mLength) mLength = inx + len;
}

void 
TrigBase::setData(const char* data, index_type len) {
    mLength = 0;
    modData(data, 0, len);
}

void 
TrigBase::zeroResult(index_type inx, index_type len) {
    if (inx > sizeof(mResults)) inx = sizeof(mResults);
    if (inx + len > sizeof(mResults)) len = sizeof(mResults) - inx;
    if (len == 0) return;
    memset(mResults+inx, 0, len);
    if (inx+len > mLength) mLength = inx + len;
}

//======================================  Mutators
TrigBase& 
TrigBase::operator=(const TrigBase& x) {
    mCreatorDB = x.mCreatorDB;
    mProcess = x.mProcess;
    mFilter = x.mFilter;
    mName = x.mName;
    mSubID = x.mSubID;
    mIfo =  x.mIfo;
    mTime = x.mTime;
    mDuration = x.mDuration;
    mPriority = x.mPriority;
    mDisposition = x.mDisposition;
    mSize = x.mSize;
    mSignificance = x.mSignificance;
    mFrequency = x.mFrequency;
    mBandwidth = x.mBandwidth;
    mLength = x.mLength;
    if (mLength > sizeof(mResults)) mLength = sizeof(mResults);
    memcpy(mResults, x.mResults, mLength);
    mEventID = x.mEventID;
    mPeakTime = x.mPeakTime;
    mAvgTime = x.mAvgTime;
    mTimeSigma = x.mTimeSigma;
    mFreqPeak = x.mFreqPeak; 
    mFreqAvg = x.mFreqAvg; 
    mFreqSigma = x.mFreqSigma;
    mNoisePower = x.mNoisePower; 
    mSignalPower = x.mSignalPower; 
    mPixelCount = x.mPixelCount; 
    mConfidence = x.mConfidence;
    return *this;
}

void 
TrigBase::setAvgOffset(Interval dT) {
    mAvgTime = dT;
}

void 
TrigBase::setAvgTime(const Time& t) {
    mAvgTime = t - mTime;
}

void
TrigBase::setBandwidth(double bw) {
    mBandwidth = bw;
}

void 
TrigBase::setConfidence(double cl) {
    mConfidence = cl;
}

void 
TrigBase::setDisposition(int disp) {
    mDisposition = disp;
}

void 
TrigBase::setDuration(Interval dT) {
    mDuration = dT;
}

void
TrigBase::setFrequency(double f0) {
    mFrequency = f0;
}

void 
TrigBase::setFreqAvg(double f) {
    mFreqAvg = f;
}

void 
TrigBase::setFreqPeak(double f) {
    mFreqPeak = f;
}

void 
TrigBase::setFreqSigma(double s) {
    mFreqSigma = s;
}

void 
TrigBase::setID(const std::string& id, const std::string& subid) {
    mName  = id;
    mSubID = subid;
}

void 
TrigBase::setIfos(const char* IFO) {
    mIfo = IFO;
}

void 
TrigBase::setIntensity(double Mag) {
    mSize = Mag;
}

void 
TrigBase::setNoisePower(double np) {
    mNoisePower = np;
}

void 
TrigBase::setPeakOffset(Interval dT) {
    mPeakTime = dT;
}

void 
TrigBase::setPeakTime(const Time& t) {
    mPeakTime = t - mTime;
}

void 
TrigBase::setPixelCount(int N) {
    mPixelCount = N;
}

void 
TrigBase::setPriority(TrigPrio prio) {
    mPriority = prio;
}

void 
TrigBase::setProcess(const char* procID) {
    mProcess = procID;
}

void 
TrigBase::setSignalPower(double sp) {
    mSignalPower = sp;
}

void 
TrigBase::setSignificance(double sigma) {
    mSignificance = sigma;
}

void 
TrigBase::setTime(const Time& T0) {
    mTime = T0;
}


void 
TrigBase::setTimeSigma(Interval s) {
    mTimeSigma = s;
}

bool 
TrigBase::operator==(const TrigBase& x) const {
    return (mProcess == x.mProcess && 
	    mName == x.mName && 
	    mSubID == x.mSubID && 
	    mTime == x.mTime && 
	    mIfo == x.mIfo);
}
