#include "events/MetaDataUtil.hh"

#include "events/Event.hh"
#include "events/Set.hh"
#include "events/Layout.hh"
#include "events/ColumnType.hh"
#include "events/Value.hh"
#include "events/Factory.hh"
#include "events/ColumnInfo.hh"

#include "Time.hh"

#include <strings.h>
#include <fstream>
#include <iostream>

   using namespace std;

namespace events {

// file must be comma-delimited and include column names 
   void ReadMetaData(const char* filename, Set& eventset) {
      ifstream file;
      file.open(filename,ios::in);
      if (!file.is_open()) {
         cerr << filename << " Not Found." << endl;
         return;
      }
   
      Layout layout(LayoutInfo::GdsTrigger());
      if (!layout.IsRegistered()) {
         layout.AddColumn("CREATOR_DB",ColumnType::kInt);
         layout.AddColumn("PROCESS_ID",ColumnType::kString);
         layout.AddColumn("FILTER_ID",ColumnType::kString);
         layout.AddColumn("SUBTYPE",ColumnType::kString);
         layout.AddColumn("DURATION",ColumnType::kReal);
         layout.AddColumn("PRIORITY",ColumnType::kInt);
         layout.AddColumn("DISPOSITION",ColumnType::kInt);
         layout.AddColumn("SIZE",ColumnType::kReal);
         layout.AddColumn("SIGNIFICANCE",ColumnType::kReal);
         layout.AddColumn("FREQUENCY",ColumnType::kReal);
         layout.AddColumn("BANDWIDTH",ColumnType::kReal);
         layout.AddColumn("BINARYDATA",ColumnType::kString);
         layout.AddColumn("BINARYDATA_LENGTH",ColumnType::kInt);
         layout.AddColumn("EVENT_ID",ColumnType::kString);
         layout.Register();
      }
   
      bool isEmpty = eventset.Empty();
      Chain eventchain;
   
      bool init = true;
      std::string line;
      std::vector<string> colnames, element;
      while (!file.eof()) {
         getline(file,line);
      
         if (init) {
            ParseMetaData(line,colnames);
            init = false;
         }
         else {
            Event event(layout);
         
            ParseMetaData(line,element);
            if (colnames.size() == element.size()) {
               std::vector<string>::iterator colitr = colnames.begin();
               std::vector<string>::iterator itr = element.begin();
               for ( ; colitr != colnames.end() && itr != element.end(); 
               ++itr, ++colitr ) {
                  if (itr->data()) {
                     const ColumnInfo* col = layout.GetColumn(colitr->c_str());
                     if (col) {
                        if (strcasecmp(colitr->c_str(),"NAME") == 0) {
                           event.SetName(Name(itr->c_str()));
                        }
                        else {
                           Value val;
                           if (itr->data())
                              ConvertValue (itr->c_str(), col->GetType(), val);
                           event.SetValue(colitr->c_str(),val);
                        }
                     }
                     else if (strcasecmp(colitr->c_str(),"START_TIME") == 0) {
                        long sec = atol(itr->c_str());
                        Time t;
                        t = event.GetTime();
                        t.setS(sec);
                        event.SetTime(t);
                     }
                     else if (strcasecmp(colitr->c_str(),"START_TIME_NS") == 0) {
                        long nsec = atol(itr->c_str());
                        Time t;
                        t = event.GetTime();
                        t.setN(nsec);
                        event.SetTime(t);
                     }
                     else if (strcasecmp(colitr->c_str(),"IFO") == 0) {
                        int ifo;
                        ifo = IfoSet::GetBit(itr->c_str());
                        if (!ifo) ifo = IfoSet::Register(itr->c_str());
                        Value val;
                        val.Read(ifo);
                        event.SetValue(ColumnType::kColumnIfoName,val);
                     }
                  }
               }
               if (isEmpty) eventchain.PushBack(event);
               else eventset.PushBack(event);
            }
         }
      }
   
      if (isEmpty) eventset.AddChain(eventchain);
   }

   void ParseMetaData(const std::string line, std::vector<string>& element) {
      element.clear();
      std::string linecpy = line + ",";
      std::string::size_type pos, prev_pos;
      pos = prev_pos = 0;
      while ( (pos = linecpy.find_first_of(",",pos))
      != string::npos) {
         string word = linecpy.substr( prev_pos, pos - prev_pos);
         element.push_back(word);
         prev_pos = ++pos;
      }
   }

   void ConvertValue (const char* source, ColumnType::Enum type, Value& val) {
      switch (type) {
         case ColumnType::kInvalid:
            break;
         case ColumnType::kComplex:
            break;
         case ColumnType::kTime:
            break;
         case ColumnType::kReal:
            double ddata;
            ddata = atof(source);
            val.Read(ddata);
            break;
         case ColumnType::kInt:
            int idata;
            idata = atoi(source);
            val.Read(idata);
            break;
         case ColumnType::kString:
            val.Read(source);
            break;
         case ColumnType::kEvent:
            break;
         default:
            break;
      }
   }
}
