#include <time.h>
#include <stdio.h>
#include <iostream>
#include <fstream>

   using namespace std;

   // Unary oparators
   const char* const uops[] = {
   0, 0
   };

   // Binary oparators
   const char* const bops[] = {
   "operator==", "Equal",
   "operator< ", "Less",
   "operator<=", "LessEqual",
   "operator> ", "Greater",
   "operator>=", "GreaterEqual",
   "operator!=", "Unequal",
   0, 0
   };

   // Standard type
   const char* const stdtype[] = {
   "const Function&",
   "const FunctionPtr&",
   0
   };

   const char* const stdcond = "const Comparison&";

   // Value types
   const char* const vtypes[] = {
   "int",
   "double",
   "const std::complex<double>&",
   "const Time&",
   "const char*",
   "const std::string&",
   0
   };

   // Pattern for unary oparators
   const char* const upattern = 
   "inline Comparison %s (%s f) {\n"
   "   return Comparison (%s, Comparison::op%s); }";

   // Pattern for binary oparators
   const char* const bpattern = 
   "inline Comparison %s (%s f1, %s f2) {\n"
   "   return Comparison (%s, %s, Comparison::op%s); }";

   // Comment
   const char* const ucomment = "/// Comparison: %s (%s)";
   const char* const bcomment = "/// Comparison: %s (%s, %s)";

   int main (int argc, char** argv)
   {
      if (argc != 2) {
         cout << "usage: MAKE_MATHOPS 'header file'" << endl;
         return 1;
      }
      char buf[16*1024];
      ofstream out (argv[1]);
      out << "// ============================================= //" << endl;
      out << "// Automatically generated header: DO NOT CHANGE //" << endl;
      out << "// ============================================= //" << endl;
      out << endl;
   
      // first do: OP 'function'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* p = uops; *p; p += 2) {
            sprintf (buf, ucomment, *p, *stdt);
            out << buf << endl;
            sprintf (buf, upattern, *p, *stdt, "f", *(p+1));
            out << buf << endl;
         }
      }
   
      // then do: 'function' OP 'function'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* p = bops; *p; p += 2) {
            sprintf (buf, bcomment, *p, *stdt, *stdt);
            out << buf << endl;
            sprintf (buf, bpattern, *p, *stdt, *stdt, 
               "f1", "f2", *(p+1));
            out << buf << endl;
         }
      }
      // next do: 'function' OP 'value'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* t = vtypes; *t; t++) {
            for (const char* const* p = bops; *p; p += 2) {
               sprintf (buf, bcomment, *p, *stdt, *t);
               out << buf << endl;
               sprintf (buf, bpattern, *p, *stdt, *t, 
                  "f1", "Value(f2)", *(p+1));
               out << buf << endl;
            }
         }
      }
      // next do: 'value' OP 'function'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* t = vtypes; *t; t++) {
            for (const char* const* p = bops; *p; p += 2) {
               sprintf (buf, bcomment, *p, *t, *stdt);
               out << buf << endl;
               sprintf (buf, bpattern, *p, *t, *stdt, 
                  "Value(f1)", "f2", *(p+1));
               out << buf << endl;
            }
         }
      }
      // next do: 'condition' OP 'function'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* p = bops; *p && (p-bops < 10); p += 2) {
            sprintf (buf, bcomment, *p, stdcond, *stdt);
            out << buf << endl;
            sprintf (buf, bpattern, *p, stdcond, *stdt, 
               "f1", "f2", *(p+1));
            out << buf << endl;
         }
      }
      // next do: 'condition' OP 'value'
      for (const char* const* t = vtypes; *t; t++) {
         for (const char* const* p = bops; *p && (p-bops < 10); p += 2) {
            sprintf (buf, bcomment, *p, stdcond, *t);
            out << buf << endl;
            sprintf (buf, bpattern, *p, stdcond, *t, 
               "f1", "Value(f2)", *(p+1));
            out << buf << endl;
         }
      }
   }
