/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    TrigPar  passes the parameters for a trigger filter or detector.
//
#include <time.h>
#include <iostream>
#include "PConfig.h"
#include <sstream>
#include <cstdio>
#include <cstdlib>
#include "Param.hh"

using namespace std;

//
//-->  Parameter base-class methods.
const char* Param::mTypStr[Param::t_end] = {"v", "i", "d", "s"};

Param::Param(char Type) {
    switch (Type) {
    case 'i':
        mType=t_int;
	break;
    case 'd':
        mType=t_double;
	break;
    case 's':
        mType=t_string;
	break;
    default:
        mType=t_void;
    }
};

template<class T, const char tchar>
param_type<T,tchar>::param_type(void) : Param(tchar) {}

template<class T, const char tchar>
param_type<T,tchar>::param_type(T Value) 
  : Param(tchar), mValue(Value) {
}

template<class T, const char tchar>
param_type<T,tchar>::param_type(const Param& x)
  : Param(tchar) {
    mValue = T(x);
}

template<class T, const char tchar>
param_type<T,tchar>::~param_type(void) {
}

template<class T, const char tchar>
std::string
param_type<T,tchar>::cvtstring() const {
    ostringstream sstr;
    sstr << mValue;
    return sstr.str();
}

//
//-->  int parameter class methods
template<>
param_int::param_type(const char *str) : Param('i') {
    mValue = strtol(str, (char**) 0, 0);
}

template<>
param_int::operator int() const {
    return mValue;}

template<>
param_int::operator double() const {
    return (double) mValue;}

template<>
int
param_int::operator=(int v) {
    mValue = v;
    return v;
}

template<>
double
param_int::operator=(double v) {
    mValue = int(v + 0.5);
    return v;
}

template<>
string
param_int::operator=(const string& v) {
    mValue = strtol(v.c_str(), (char**)0, 0);
    return v;
}

//
//-->  double parameter class methods
template<>
param_double::param_type(const char *str) : Param('d') {
    mValue = strtod(str, (char**) 0);
}

template<>
param_double::operator int()   const {
    return int(mValue + 0.5);
}

template<>
param_double::operator double() const {
    return mValue;
}

template<>
int
param_double::operator=(int v) {
    mValue = double(v);
    return v;
}

template<>
double
param_double::operator=(double v) {
    mValue = v;
    return v;
}

template<>
string
param_double::operator=(const string& v) {
    mValue = strtod(v.c_str(), (char**)0);
    return v;
}

//
//-->  string parameter class methods

template<>
param_string::param_type(const Param& x)
  : Param('s') {
    mValue = x.cvtstring();
}


template<>
param_string::param_type(const char *str) : Param('s') {
    mValue = str;
}

template<>
param_string::operator int()    const {
    return strtol(mValue.c_str(), (char**) 0, 0);
}

template<>
param_string::operator double() const {
    return strtod(mValue.c_str(), (char**) 0);
}

template<>
int
param_string::operator=(int v) {
    char temp[32];
    sprintf(temp,"%i", v);
    mValue = temp;
    return v;
}

template<>
double
param_string::operator=(double v) {
    char temp[32];
    sprintf(temp, "%f", v);
    return v;
}

template<>
string
param_string::operator=(const string& v) {
    mValue = v;
    return mValue;
}

//--------------------------------------  The alpha compiler wants these 
//                                        after the specializations.
template class param_type<int,    'i'>;
template class param_type<double, 'd'>;
template class param_type<string, 's'>;

