/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef STDIO_FD_HH
#define STDIO_FD_HH
#include <iosfwd>
#include <cstdio>
#include "PConfig.h"

class stdio_fd {
public:
   stdio_fd(int fd);
   stdio_fd(FILE* file);
#ifndef P__DARWIN
   stdio_fd(const std::ifstream& fs);
   stdio_fd(const std::ofstream& fs);
#endif
   void block(bool on);
   bool is_pipe(void) const;
   int fd(void) const;

   /**  Set the buffer size of a named pipe file. The fcntl function required 
    *  to implement this method added t othe linus kernel-2.6.35 amd is not
    *  available in the SL6 O/S. The maximum buffer size is 
    *  specified by the /proc/sys/fs/pipe-max-size system parameter.
    */
   void set_pipe_size(int buf_size);

private:
   int _fd;
};

//======================================  inline methods
inline
stdio_fd::stdio_fd(int fd) 
   : _fd(fd)
{}

inline int
stdio_fd::fd(void) const {
   return _fd;
}

#endif // !defined(STDIO_FD_HH)
