// $Id: callineMon.hh 6200 2010-03-20 04:58:31Z jordi.burguet-castell $

#ifndef CALLINEMON_HH
#define CALLINEMON_HH

#include "DVecType.hh"
#include "DatEnv.hh"
#include "FrWriter.hh"
#include "MonServer.hh"
#include "FixedLenTS.hh"
#include "TSeries.hh"
#include "FSpectrum.hh"
#include "Trend.hh"
#include <vector>
#include <string>
#include <complex>


/*
 * @name    callineMon
 * @memo    Calibration Lines Monitor
 * @author  Jordi Burguet-Castell
 * @version 1.0
 */
class callineMon : public DatEnv, MonServer {
public:
    callineMon(int argc, const char *argv[]);
    ~callineMon();
    void ProcessData(void);      // process 1 data stride
    void Attention(void);        // handle message signal

private:
    Trend     mTrend;          // trend writer
    double    mStride;         // time stride (duration of the data chunk)
    int       mNGammaFT;       // number of gamma samples in spectra
    FrWriter  mFrameWriter;    // frame writer
    float     mDt;             // factors integration time
    float     mAlpha;          // weight of the last spectrum in the PSD
    bool      mDoSpectrum;     // compute the spectrum?
    bool      mLastWasZero;    // previous iteration had zeroed gamma?
    bool      mWriteFrames;    // write frame files with all the gammas?
    
    /* Calibration lines, open loop gain and dewhitening */
    std::vector<double>    mFreqs;      // frequencies of the calibration lines
    // All the calibration lines can be found, for example, here:
    // http://blue.ligo-wa.caltech.edu/scirun/S5/Results/CalibrationStability/

    std::vector< std::complex<double> > mG0;  // open loop gain at cal lines
    // This guys change every time the filters file change, and can be
    // obtained from files like
    // calibration/frequencydomain/runs/S6/MatlabScripts/WriteH1V2CalFiles.m

    std::vector< std::complex<double> > mW0;  // dewhitening at cal lines
    // These don't change often, and can be obtained from
    // calibration/timedomain/runs/S5/DARMwhitener.m

    /* Data history (for visualization) */
    std::vector<FixedLenTS*> mHistory;  // time series of gamma factors
    std::vector<FSpectrum*> mPow;       // power spectra of gamma factors TSs
    std::vector<FSpectrum*> mPowAvg;    // exponential average (estimate of PSD)

    /* Input channel names */
    std::string mDCTRLChanName;  // Xn:LSC-DARM_CTRL
    std::string mEXCChanName;    // Xn:LSC-DARM_CTRL_EXC_DAQ
    std::string mSVChanName;     // Xn:IFO-SV_STATE_VECTOR

    /* Ouput channel names */
    std::vector<std::string> mGammaChanNames;   // Xn:DMT-CLIN_GAMMA_<freq>_{Re,Im}
    std::vector<std::string> mPowChanNames;     // Xn:DMT-CLIN_POWER_<freq>
    std::vector<std::string> mPowAvgChanNames;  // Xn:DMT-CLIN_POWER_AVG_<freq>

    std::string mOutputFileName;  // name of the output file (calline-%s-60.gwf)

    /* Header with the command line and other info to add to the history */
    std::string mHeader;

    FSpectrum* compute_spectrum(float* GAMMA_RE, float* GAMMA_IM,
                                const Time& t0);
    int  initialize_input_data(int argc, const char *argv[]);
    int  write_frames(std::vector<TSeries*> gammas,
                      std::vector<FSpectrum*> powers,
                      std::vector<FSpectrum*> powavgs);
    void set_channel_names(std::string ifo);
    void append_nums(std::vector<double>& v, std::string nums,
                     const char* separators=",");
};


#endif     //  CALLINEMON_HH
