#ifndef WPIPE_TYPES_HH
#define WPIPE_TYPES_HH

#include "TSeries.hh"
#include "fSeries/DFT.hh"
#include <string>
#include <vector>

// If defined, DFTs are unnormalized immediately after they are calculated.
// The results should remain the same, although a few normalization operations
// are repeated.
// #define UNNORMALIZED_DFTS 1

//  If defined the matlab bugs are left in.
// #define OMEGA_MATLAB_BUGS 1

//  Don't attempt to compile coherent search code (not implemented).
#define NO_TARGETED 1
#define NO_COHERENT 1
#define NO_COINCIDENCE 1
#define NO_FOLLOWUP 1

/**  Namespace %wpipe contains the classes used to calculate the Omega (Q) 
  *  transform, search for events in the trasformed data, an write or plot 
  *  the results.
  *  \brief Omega_c pipeline components 
  *
  *  \author John zweizig (john.zweizig@ligo.org)
  */
namespace wpipe {

  /**  Bool vector type for Omega_c pipeline.
    */
  typedef std::vector<bool>            bool_vect;

  /**  Double precision vector type for Omega_ pipeline.
    */
  typedef std::vector<double>          dble_vect;

  /**  Double precision vector iterator for Omega_ pipeline.
    */
  typedef dble_vect::iterator          dble_iter;
  
  /**  DFT vector type for Omega_c pipeline.
    */
  typedef std::vector<containers::DFT> dft_vect;

  /**  TSeries vector type for Omega_c pipeline.
    */
  typedef std::vector<TSeries>         tser_vect;
  
  /**  String vector type for Omega_c pipeline.
    */
  typedef std::vector<std::string>     str_vect;

  /**  TString vector iterator for Omega_c pipeline.
    */
  typedef str_vect::const_iterator     const_strv_iter;

}
#endif // !defined(WPIPE_TYPES_HH)
